function d = ld_test(a, d)
%d = ld_test(a, d)
% Make predictions with the linear discriminant method.
% Inputs:
% a -- A linear discriminant model.
% d -- A data structure.
% Returns:
% d -- The same data structure, but X is replaced by the discriminant
% values.

% Isabelle Guyon -- September 2005 -- isabelle@clopinet.com

if a.algorithm.verbosity>1
    disp(['running ld_test...'])
end
  
Xte=get_x(d); 
[p, n]=size(Xte);

Yest = Xte*a.W' + a.b0(ones(p,1),:);

% remove ties:
zero_val=find(Yest==0);
Yest(zero_val)=a.algorithm.default_output*eps;

d=set_x(d,Yest); 