function area = auc(Output, Target)
%area = auc(Output, Target)
% This computation gives the same results as the AUC when there are no
% ties.
% Inputs:
%  Output -- Matrix of classifier discriminant values of dim (num pattern, num tries)
%  Target -- Vector of corresponding +-1 target values.
%  Returns:
%  area -- Area under the ROC curve.
% We still need to work out the case of ties.
% From Hollander and Wolfe pp 107 & 117.

% Isabelle Guyon -- isabelle@clopinet.com -- June 2005

% Compute the Wilcoxon statistic
midx=find(Target<0);
nidx=find(Target>0);
m=length(midx);
n=length(nidx);
[u,i]=sort(Output);
S(i)=1:n+m;
W=sum(S(nidx));

% Compute the Mann-Withney statistic
U=W-n*(n+1)/2;

% Compute the AUC
area=U/(m*n);
