//--------------------------------------------------------------
// file: fspike.cpp - Matlab Mex function application
//--------------------------------------------------------------
#include <iostream.h>
#include <math.h>
 
extern "C" {
#include "mex.h"
}
 
// TODO: Add you supporting functions here
 

//--------------------------------------------------------------
// function: fspike - Entry point from Matlab environment (via
//   mexFucntion(), below)
// INPUTS:
//   nlhs - number of left hand side arguments (outputs)
//   plhs[] - pointer to table where created matrix pointers are
//            to be placed
//   nrhs - number of right hand side arguments (inputs)
//   prhs[] - pointer to table of input matrices
//--------------------------------------------------------------
void fspike( int nlhs, mxArray *plhs[], int nrhs, const mxArray  *prhs[] )
{
 
 double N,p,lam;
 int lens,lent;
 
 N=mxGetScalar(prhs[0]);
 p=mxGetScalar(prhs[1]);
 lens=(int)mxGetScalar(prhs[2]);
 lent=(int)mxGetScalar(prhs[3]);
 lam=mxGetScalar(prhs[4]);
 

// mexPrintf("%f %f %f %f %f\n",N,p,lens,lent,lam);
 

 double *dmu,*Kn,*Kn1;
 dmu= mxGetPr(prhs[5]);
 Kn= mxGetPr(prhs[6]);
 Kn1= mxGetPr(prhs[7]);
 

/* MATLAB-CODE
res = 0;
 
lam2=lam^2;
 
for n=1:N
    for s=n:lens
        Kt = 1;
        for t=n:lent
           
           
            Kt1 = lam2*Kn(s,t)*dmu(s,t) + lam*Kt;
 
            Kn1(s+1,t+1) = lam*Kn1(s,t+1) + Kt1;
    
    
            Kt = Kt1;
        end          
    end
    res = res + Kn1(lens+1,lent+1)*p^n;
    Kn = Kn1;
end
 
*/
 
 double res = 0;
 double Kt,Kt1;
 double lam2=lam *lam;
 double pp = p;

 
 for (int n=0;n<N;n++)
 {
  for (int s=n;s<lens;s++)
  {
   Kt = 1;
   for (int t=n;t<lent;t++)
   {
    
    Kt1 = lam2*Kn[t*(lent+1)+s]  *dmu[t*lent+s] + lam*Kt;
    
    Kn1[(t+1)*(lent+1)+s+1] = lam*Kn1[(t+1)*(lent+1)+s] + Kt1;

 //   mexPrintf("%f %f\n",Kt1,Kn1[(t+1)*(lent+1)+s+1]);

    Kt = Kt1;
   }
  }
 // mexPrintf("%f \n",Kn1[(lent)*(lent+1)+lens] );
  
  res = res + Kn1[(lent)*(lent+1) + lens]  *pp;
  pp = pp*p;
 // mexPrintf("%f \n",res);
    
  memcpy(Kn,Kn1,(lent+1)*(lens+1)*sizeof(double) ); 
 }
 
 
 plhs[0]= mxCreateDoubleMatrix(1, 1, mxREAL);
 double * result=mxGetPr(plhs[0]);
 *result=res;
 
 
/*   float mat[4][4];
 
  if( nrhs ==2)
  {
   // m X n
   int m=mxGetM(prhs[1]);
   int n=mxGetN(prhs[1]);
 
   if(m !=4 || n != 4)
   {
    mexErrMsgTxt("Usage : 'setMatrix' matrix[4][4]\n");
    return;
   }
 
   double *_matrix= mxGetPr(prhs[1]);
*/
 
 
// (seqS,seqT,N,lam,mu,p)
} // end fspike()
 
extern "C" {
  //--------------------------------------------------------------
  // mexFunction - Entry point from Matlab. From this C function,
  //   simply call the C++ application function, above.
  //--------------------------------------------------------------
  void mexFunction( int nlhs, mxArray *plhs[], int nrhs, const mxArray  *prhs[] )
  {
    fspike(nlhs, plhs, nrhs, prhs);
  }
}

