function dret = readfrom(d,format,filename)

switch(lower(format))   
case {'libsvm'}
    X=[];
    Y=[];
    
    fid=fopen(filename,'rt');
    index=1;
    
    while 1
        tline = fgetl(fid);
        
        if ~ischar(tline), break, end
        % read label
        [token,rem] = strtok(tline);
        Y(index,1)=str2num(token);
        [token,rem] = strtok(rem);
        
        while(~isempty(rem))
            a=sscanf(token,'%d:%e');
            X(index,a(1))=a(2);
            [token,rem] = strtok(rem);            
        end 
        index=index+1;
        if (mod(index,50)==0)
            fprintf('Line: %d\n',index)
        end
    end
    
    fclose(fid);
    dret=data(X,Y);
otherwise 
    warning(['Unknown format ',format])
end
