
function data = data_struct(name,X,Y) 

%========================================================================================================  
% DATA_STRUCT data object
%========================================================================================================
% Stores data into two components X (input) and Y (output).
%
% An object is created with:
%   data('name',X,Y); 
%       or 
%   data(X,Y); (no name)
%       or 
%   data(X); (in case there's no output, e.g clustering)
%
%
% Public attributes:
%  X          -- input cell array        
%  Y          -- output cell array    
%  index      -- original parent indices of examples 
%
% NOTE:
% All functions for a data_struct object also take the findex argument.
% This is due to be compatible with the data object of the spider. Since
% feature indices do not make sense for general data types IT IS NOT USED
% in any function.
%
%
%
% Public methods:
%  d=get(data,index,featInd)             -- return data,index only (ind)examples,(find)features 
%  x=get_x(data,index,fInd)              -- return x,index only (ind)examples,(find)features 
%  y=get_y(data,index,fInd)              -- return y,index only (ind)examples,(find)features 
%  d=set_x(data,X,indes,featInd)         -- set inputs indexed by (ind)examples,(find)features
%  d=set_y(data,Y,index,featInd)         -- set outputs indxed by (ind)examples,(find)features
%  [indes,featInd]=get_index(d)          -- returns example and feature indices
%  numEx =get_dim(d)                         -- returns number of examples
%
% Example: 
%               get_x(data_struct({rand(2),rand(2),rand(2)},{rand(3),rand(3),rand(3)}))
  
  if nargin==0
     name='structured data (empty)';
     data.X={}; data.Y={};
     data.index=[]; data.findex=[];

   else 
     data.X={}; data.Y={};
     if nargin>=2 data.X=X; end
     if nargin>=3 data.Y=Y; end;
     if ~isa(name,'char') 
       data.Y=data.X;
       data.X=name;
       name=['data_struct'];
     end
     
     X=data.X;
     if isa(X,'cell')
       data.index = [1:length(X)];
       data.findex = [];       
     else
       data.index = [1:size(X,1)];
       if isempty(data.index) data.index = [1:size(data.Y,1)]; end;
       data.findex = [];       
     end

  end
   
  
  p=algorithm(name); p.is_data=1;
  data= class(data,'data_struct',p);
    
  
