function a = kha(hyper) 

%===================================================================
% KHA Kernel Hebbian Algorithm to learn Kernel pca incrementally
% Kwang In Kim
%===================================================================
%
% hyperparameters
%    LearningParameter = 0.0005;
%    NumofEigenvectors = 3;
%    MovementThreshold = 0.0000001;
%    IterationLimit = 500000;
%    GaussianSigma = 0.1;
%
% model
%    e_vec              % eigenvectors  
%    e_val              % eigenvalues  
%    dat                % training data
%    EmpiricalSumKernelMap      % for fast computation
%    EmpiricalKernelSum         % for fast computation
%
% method
%    train, test
%===================================================================
% Reference : Kernel Hebbian Algorithm for Iterative Kernel Principal Component Analysis
% Author    : Kwang In Kim , Matthias O. Franz , Bernhard Schlkopf
% Link      : http://www.kyb.tuebingen.mpg.de/publications/pdfs/pdf2302.pdf
%===================================================================

a.child=kernel;

% hyperparameters for KHA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    a.LearningParameter = 0.0005;
    a.NumofEigenvectors = 3;
    a.MovementThreshold = 0.0000001;
    a.IterationLimit = 500000;
    a.PolyDegree = 2;
    a.GaussianSigma = 0.1;
    a.KernelType = 2;;
% hyperparameters for KHA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    a.e_vec=[]; % eigenvectors  
    a.e_val=0; % eigenvalues  
    a.dat=[]; % training data
    a.EmpiricalSumKernelMap=[]; % for fast computation
    a.EmpiricalKernelSum=0; % for fast computation
% model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
    p=algorithm('kha');
    a=class(a,'kha',p);

if nargin==1,
    eval_hyper;
end;
