function d  =  testing(a,d)

A = a.e_vec';
EmpiricalSumKernelMap = a.EmpiricalSumKernelMap;
EmpiricalKernelSum = a.EmpiricalKernelSum;

if(strcmp(a.child.ker, 'linear') ==1)
    KernelType = 1;
elseif(strcmp(a.child.ker, 'poly') ==1)
    KernelType = 2;
    PolyDegree = a.child.kerparam;
else
    KernelType = 3;
end;

TestPtn=get_x(d);
TrnPtn=get_x(a.dat);

[NumofTestPatterns,dum] = size(TestPtn);
[NumofEigenvectors,dum] = size(A);
[NumofTrnPatterns,dum] = size(TrnPtn);

for i=1:NumofTestPatterns
    % Prepare empirical kernel map for test pattern i: to compute sum 1
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        switch KernelType
            case 1 % linear
                EmpiricalTestKernelMap = TestPtn(i,:)*TrnPtn';
            case 2 % polynomial
                EmpiricalTestKernelMap = (TestPtn(i,:)*TrnPtn').^PolyDegree;
            case 3 % Gaussian
                EmpiricalTestKernelMap = get_kernel(a.child,d,a.dat,[i])';
            otherwise % user defined
                EmpiricalTestKernelMap = get_kernel(Child,d,a.dat,[i])';
        end
    % Prepare empirical kernel map for test pattern i: to compute sum 1
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     
    % Compute output Y
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        Y=zeros(1, NumofEigenvectors);

        Sum1 = EmpiricalTestKernelMap*A';
        
        Sum2 = EmpiricalSumKernelMap*A';
        Sum2 = Sum2/NumofTrnPatterns;
        
        AlphaSum = sum(A');
        Sum3 = sum(EmpiricalTestKernelMap)*AlphaSum;
        Sum3 = Sum3/NumofTrnPatterns;
        
        Sum4 = EmpiricalKernelSum*AlphaSum;
        Sum4 = Sum4/(NumofTrnPatterns^2);

        Y=Sum1-Sum2-Sum3+Sum4;
    % Compute output Y
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    test_features(i,:) = Y;
end

d=set_x(d,test_features);
% d.name=[get_name(d) ' -> ' get_name(a)]; 
