function out = migrate_spider(dst)
%MIGRATE_SPIDER   copy the spider using rsync and switch to the copy
% 
% MIGRATE_SPIDER
% MIGRATE_SPIDER(DEST)
% 
% Use rsync on a unix-like system to copy the spider-for-matlab distribution
% from:
%     whichever directory contains the copy of MIGRATE_SPIDER currently
%     being called,
% to:
%     the directory DEST, which by default is /tmp/$USER/spider/spider
% 
% Files at the destination location are overwritten and/or deleted as
% appropriate (the source-spider is considered to be the master copy).
% Then the source-spider pathnames are removed from the matlab path (if
% they are there to begin with) using USE_SPIDER(0), and the copies are
% added instead, with USE_SPIDER(1)
% 
% See also USE_SPIDER

if ~isunix, error('unix-like system required'), end
if nargin < 1, dst = ''; end
if isempty(dst)
	dst = fullfile('/tmp', getenv('USER'), 'spider', 'spider');
end
syscmd(['mkdir -p ''' dst '''']);

if datenum(version('-date')) >= datenum('May 6 2004')
 % look at this lovely mutual incompatibility between R14+ and previous releases
 % well done MathWorks, you've made our lives needlessly difficult AGAIN!
 src = dbstack('-completenames');
 src = pawd(fileparts(src(1).file));
else
 src = dbstack; 
 src = pawd(fileparts(src(1).name));
end   



call = sprintf('rsync -avCW --exclude ''*~'' --exclude ''.svn'' --delete ''%s/'' ''%s/''', src, dst);
if ~nargout, disp(sprintf('%s\n%s', call, syscmd(call))), end

olddir = pawd;
cd(src)
use_spider(0)
ws = warning('off', 'MATLAB:rmpath:DirNotFound');
rmpath(src)
warning(ws)
cd(dst)
use_spider(1)
cd(olddir)

spiderroot = updir(updir(updir(which('svm'))));
if nargout
	out = spiderroot;
else
	disp(sprintf('\nnow using spider distribution at %s', spiderroot))
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function d = updir(d)
d = fileparts(d);
if d(end)==filesep, d(end) = []; end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function d = pawd(d)

if nargin < 1
	if isunix
		[d err] = syscmd('echo $PWD'); % better (non-)resolution of symlinks, /.amd_mnt etc
		if ~isempty(err), d = pwd; end
	else
		d = pwd;
	end 
end
if ~isunix, return, end
[dd err] = syscmd(['pawd ''' d '''']);
if isempty(err), d = dd; end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [str, err] = syscmd(cmd)

err = '';
[failed str] = system(cmd);
str = deblank(str);
if failed
	err = sprintf('system call failed:\n%s\n%s', cmd, str);
	str = '';
	if nargout < 2, error(err), end
end
