
function a = adaboost(C,hyper) 
   
%  ADABOOST
%  
%  
% A=ADABOOST(C,H) returns a template object initialized with learning algorithm C and hyperparameters H. 
%
%  The template object is a simple linear support vector machine, with
%   soft margin hyperparameter C. Please use this template to
%   implement your own algorithms.
%
% Hyperparameters, and their defaults
% kmax = 5                -- number of weak learners
%
% Methods:
%  train, test
%
% Model:
%  child                  -- learning algorithm
% Example:
%
% % Use adaboost with 1-knn as weak learner and validate with 2 fold cross validation.
% c1=[2,0];
% c2=[-2,0];
% X1=randn(50,2)+repmat(c1,50,1);
% X2=randn(50,2)+repmat(c2,50,1);
% 
% d=data([X1;X2],[ones(50,1);-ones(50,1)]);
% [r,a]=train(cv(adaboost(knn),'folds=2'),d);
%
% ========================================================================
% Reference : The boosting approach to machine learning: An overview
% Author    : Robert E. Schapire
% Link      : http://www.cs.princeton.edu/~schapire/uncompress-papers.cgi/msri.ps
% ========================================================================

  
  a.kmax=5;
  % model
  a.alpha=ones(a.kmax,1);  
  for i=1:a.kmax
  	a.child{i}=C;
  end  
  
  p=algorithm('adaboost');
  a= class(a,'adaboost',p);
 
  if nargin==2,
    eval_hyper;
  end;
  disp([num2str(a.kmax) ' classifiers'])