function [results,alg] =  training(al,dat)
   
 disp(['training ' get_name(al) '.... '])

 %% make names
 fileID = fopen('c45tmp.names','W'); 
 [numEx,vDim,oDim]=get_dim(dat); 
 if oDim==1 
     oDim=2; 
 end;  
 
 for i=1:oDim-1 
     fprintf(fileID,'%d,',i); 
 end; 
 fprintf(fileID,'%d.',oDim);
 fprintf(fileID,'\n\n');
 
 for i=1:vDim
   fprintf(fileID,'A%d: continuous.\n',i);
 end
 fclose('all');
   
 %% make train data
 fileID = fopen('c45tmp.data','W'); [X,Y]=get_xy(dat);
  
 for i=1:size(X,1)
   for j=1:size(X,2)
     fprintf(fileID,'%f,',X(i,j));
   end
   labels=find(Y(i,:)==1);  %% multi-class case in general
   if size(Y,2)==1           %% binary case 
     if Y(i)==1 
         labels=1; 
     else 
         labels=2;  
     end
   end
   fprintf(fileID,'%d\n',floor(labels));
 end 
 fclose('all');
 s=spider_path(0); 

 if isunix,
   evalstr=[s 'Optimization/c4.5o -f c45tmp'];
 else
   evalstr=[s 'Optimization/c45o -f c45tmp'];
 end;
 if isunix, 
   status = unix(evalstr);
 else
   status = dos(evalstr);
 end
 results=test(al,dat); 
 alg=al;
  
  
 
  
