function a = pmg_rr(hyper) 
%=================================================================
% Pre-Image by ridge regression given KPCA coordinates
%=================================================================
% a = pmg_rr(alg,hyper)
% generates a pre-image object; uses ridge regression learning
% -------------------------------------------------------
% hyperparameters:
% child=kernel     kernel to work with.
% kp=kpca		   kpca object
% dn=sample data   data pool, if empty uses kp.dat		
%
% model:
% rmap             learnt ridge regression object
% mean_x           mean of data
% rn=sample data coordinates from data pool
% stats:
% methods:
% train         calls test
% test			find the preimage 
%
% example:
% k=kernel('rbf',0.75);
% d=gen(toy2d);
% d2=gen(toy2d('l=100'));
% 
% [r,kp]=train(kpca({k,'feat=50'}),d2);
% p0=pmg_rr;p0.kp=kp; p0.child=k;
% p0.dn=d2;
% p0.rmap_model_selection=1;
% [r,p1]=train(p0,d2);
% r2=test(kp,d);
% reconstruct=test(p1,r2)
% reconstruct.X=reconstruct.X;
% 
% 
% clf;
% hold on;
% colormap white;
% 
% plot3(d2.X(:,1),d2.X(:,2),d2.X(:,2)*0+10,'k.');
% plot3(d.X(:,1),d.X(:,2),d.X(:,2)*0+10,'rx'); hold on;
% plot3(reconstruct.X(:,1),reconstruct.X(:,2),reconstruct.X(:,2)*0+10,'o');
% 
% t=text(d.X(1,1),d.X(1,2)+0.005,d.X(1,2)*0+10,sprintf('Ideal Pre-Image'));
% set(t,'Fontsize',10);
% set(t,'Color',[1,0,0])
%=============================================================================
% Reference : Learning To Find Pre-Images
% Author    : gkhan 
% Link      : -
%=================================================================


  % hyperparameters
  a.child=kernel;
  a.kp = [];
  a.dn =[];
  
  a.rmap = multi_rr;
  a.rmap_model_selection=1;
  a.mean_x = [];
  a.mean_rx = [];
  a.rn = [];

  if nargin==0
    a.kp=kpca;  
  end
  
  p = algorithm('pmg_rr');
  a = class(a,'pmg_rr',p);
  
  if nargin==1
    eval_hyper;
  end
  