function [d, a] =  training(a,d)
  
if a.algorithm.verbosity>0
  disp(['calculating pre-image for each coordinate specified in data with ', get_name(a.child)])
end

if(a.kp.algorithm.trained==0)
	disp('kpca must be trained object');
    return;
end

if(isempty( a.dn) )
	a.dn=a.kp.dat;	
end

if( isempty(a.rn))
	a.rn=test(a.kp,a.dn);	
end

a.mean_rx=mean(a.rn.X);
a.mean_x=mean(a.dn.X);

rn=a.rn.X - ones(get_dim(a.rn),1)*a.mean_rx;
x=a.dn.X - ones(get_dim(a.dn),1)*a.mean_x;


d2=data(rn,x);

a.rmap.child=a.child;
if(strcmp(get_name(a.rmap.algorithm),'multi_rr')==1 & a.rmap_model_selection == 1 )
    ridges=1./[2.^linspace(2,20,10)];
    p=param(a.rmap,'ridge',ridges);
    % use max 500 only for model selection
    k=min([500,get_dim(d2)]);
    [r,cvresult]=train(cv(p),get(d2,1:k));
    r=get_mean(loss(r,'quadratic_loss'));
    s=[];
    for k=1:length(r.child)
        k
        s=[s;r.child{k}.Y];
    end
    [v,k]=sortrows(s);
    a.rmap.ridge=ridges(k(1));
end
%a.rmap.ridge
%[r,a.rmap]=train(

[d,a.rmap]=train(a.rmap,d2);

d.X=d.X+ ones(get_dim(a.dn),1)*a.mean_x;
d.Y=d.Y+ ones(get_dim(a.dn),1)*a.mean_x;
