function ret = rbf_map(a,x_i,x_j,z_nn,df,k)

% calculates input space distances of a point,
% regarding the feature space distances df
% for the rbf kernel
% supply like function for other kernels, see williams 02

switch k.ker
case 'rbf'
  Kx = .25 * (calc(k,data(x_i)) + calc(k,data(x_j)) + 2*calc(k,data(x_i), data(x_j)));
  for i=1:size(z_nn,1)
      Ki = calc(k, data(z_nn(i,:)));
      arg = .5*(Kx + Ki - df(i));
       if arg <= 0
           disp('negative logarithm argument - no input distance computable... aborting.')
           return;
       else 
           ret(i) = -2*k.kerparam^2 * log(arg);
       end;
  end;
otherwise
 ret = NaN;
 disp('supply other inverse function from feature to input space!')
 return;
end;
