
function a = kmp(hyper) 

% KMP kernel mapping pursuit object
% 
% A=KMP(H) returns a kmp object initialized with hyperparameters H. 
%
%
%  Example: 
%
% Hyperparameters, and their defaults
%  C=Inf                -- the soft margin C parameter
%  optimizer='default'  -- other choices={andre,quadprog,svmlight,libsvm}
%  nu = 0               -- bernhard's nu svm parameter
%  child=kernel         -- the kernel is stored as a member called "child"
% 
% Model
%  alpha                -- the weights
%  b0                   -- the threshold
%  Xsv                  -- the Support Vectors
%
% Methods:
%  train, test, get_w 
  
  %hyperparams 
  a.child=kernel('rbf',1);
  a.max_loops=100;
  a.optimizer='full_inversion';
  a.verbosity=10;
  a.inversion_every=20; % do inversion only every 20 steps
  a.trn_err_frac=1;     % amount of trn pts look at to evaluate error rate
  a.ridge = 1e-4;
  % model 
  a.alpha=[];
  a.Xsv=[];
  a.res=[];   % sotre error on each round (train,test)
  a.selection_criterion = 'kmp';
  
  p=algorithm('kmp');
  a= class(a,'kmp',p);
  a.algorithm.use_signed_output=0;
  
  if nargin==1,
    eval_hyper;
  end; 
  
 
