function [results,alg] =  training(alg,dat)
  % [results,algorithm] =  training(algorithm,data,loss)
  disp(['training ' get_name(alg) '.... '])
  Y = get_y(dat);
  if isempty(alg.indices), 
    kern = get_kernel(alg.child,dat,dat);
    R = kern;
  else
    X = get_x(dat);
    datTemp = data('tmp',X(alg.indices,:),Y(alg.indices,:));
    kern = get_kernel(alg.child,dat,datTemp);
    kern = kern';
    R = get_kernel(alg.child,datTemp,datTemp);
   end;
  kernRowNo = size(kern,1);

if 0
  if alg.use_b
    toInv = (kern'*[kern,ones(kernRowNo,1)] + alg.ridge*[R,zeros(size(R,1),1)]);
    keyboard
    alpha = toInv\(kern'*Y);  
    alg.alpha=alpha(1:kernRowNo,:);
    alg.b0=alpha(kernRowNo+1,:);
else
    toInv = (kern'*kern + alg.ridge*R);
    alg.alpha = toInv\(kern'*Y);  
    alg.b0=0;
end
else  
  %% optimization way of doing it
  kern=kern+eye(length(kern))*alg.ridge;
  H=kern'*kern; 
  f=-2*Y'*kern;
  if alg.use_b 
    H=[H 0.5*sum(kern)']; 
    H=[H; 0.5*sum(kern) length(kern)]; 
    f=[f -sum(Y)];
end 
  options= optimset('MaxIter',10000,'LargeScale','off');
  [alpha,fVal]=quadprog(2*H,f,[],[],[],[],[],[],[],options);
  if alg.use_b
    alg.alpha=alpha(1:length(alpha)-1);
    alg.b0=alpha(length(alpha));
else 
    alg.alpha=alpha;
end  
end
  if isempty(alg.indices),
    alg.X=dat;
else
    alg.X = datTemp;
end;
  results=test(alg,dat);
  






