
function a = trans_marg(I,hyper) 

%=============================================================================   
% TRANS_MARG 
%============================================================================= 
% A=TRANS_MARG(H) returns a trans_marg object initialized 
%  with hyperparameters H. 
%
%  This algorithm iteratively trains a (possible conditional probability 
%  estimating, or at least real-valued output giving) algorithm I,
%  adding examples from an unlabeled set if they have a
%  sufficiently large threshold.
%
% Hyperparameters, and their defaults
%  tpos=0.9             -- positive threshold, i.e unlabeled pts with output
%                          greater than this will become positive examples
%  tneg=0.1             -- negative threshold, i.e unlabeled pts with output
%                          less than this will become negative examples
%  tboth=0;             -- if nonzero, uses this instead of
%                          tneg,tpos to define tneg=tboth; tpos=1-tboth; 
%  tmarg=0;             -- if nonzero, uses this instead of
%                          tneg,tpos to define tneg=-1+tmarg; tpos=1-tmarg; 
%   
%  max_iter=100         -- maximum iterations (stops anyway if
%                          there is no unlabeled points added).
%
%
% Model
%  child=platt          -- child algorithm, default is an svm with
%                          conditional probability estimation (platt)
%  class_alg=[]         -- algorithm for final classification, if class_alg=[]
%                          then use same as the base/child algorithm
%  dat                  -- training data
%
% Methods:
%  train, test 
%
% Example: 
% get_mean(train(cv({trans_marg('tboth=0.1') svm}),gen(toy('seed=1'))))
% get_mean(train(cv({trans_marg(svm,'tmarg=0.1'),svm}),gen(toy('seed=1'))))
%
% a1=trans_marg(svm); a2=param(a1,'tmarg',[0 0.05 0.1 0.2 0.3]);
% a3=gridsel(a2); get_mean(train(cv({a2 a3 svm}),gen(toy('seed=1'))))
%================================================================================
% Reference : 
% Author    : 
% Link      : 
%================================================================================
  
  % model
    
  a.class_alg=[];
  if nargin>0 & isa(I,'algorithm')
    a.child=I; if nargin==1 hyper=[]; end;
  else
    a.child=platt; a.class_alg=svm; 
    if nargin>0 hyper=I; end;
  end
  a.max_iter=100;
  a.tneg=0.1; a.tpos=0.9; a.tboth=0; a.tmarg=0;
  a.dat=[];
  
  p=algorithm('trans_marg');
  a=class(a,'trans_marg',p);
 
  a.child.algorithm.use_signed_output=0;
    
  if ~isempty(hyper)
    eval_hyper;
  end;

  






