function idx=descramble(filename, key)
%idx=descramble(filename, key)
% Function to scramble/descramble labels
% filename -- name of file containing values to scramble/descramble
% key -- scrambling key
% idx -- index to scramble of descramble
% The function writes a file .labels with descrambled data is provided
% with a .scrambled_labels file, and vice versa.

% Isabelle Guyon -- isabelle@clopinet.com -- March 05, 2006

if nargin<2, error('Need 2 arguments'); end
if ~ischar(key), error('key should be a string'); end
if ~exist('filename') == 2, error('could not open file'); end
lbl=load(filename);
ext=filename(findstr(filename, '.')+1: length(filename));
filename=filename(1:findstr(filename, '.')-1);
alpha='0123456789abcdefghijklemnoqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

idx=1:length(lbl);
for k=1:length(key)
    n=findstr(alpha, key(k));
    if mod(k,2)
        idx=shift_idx(idx,n);
    else
        idx=turn_idx(idx,n);
    end
end

if strcmp(ext, 'labels')
    lbl=lbl(idx);
    fp=fopen([filename '.scrambled_labels'], 'w');
    for k=1:length(lbl)
        fprintf(fp, '%d\n', lbl(k));
    end
    fclose(fp);
else
    invidx(idx)=1:length(lbl);
    lbl=lbl(invidx);
    fp=fopen([filename '.labels'], 'w');
    for k=1:length(lbl)
        fprintf(fp, '%d\n', lbl(k));
    end
    fclose(fp);
end

function idxnew=shift_idx(idx,n)
idxnew=zeros(size(idx));
N=length(idx);
idxnew(n+1:N)=idx(1:N-n);
idxnew(1:n)=idx(N-n+1:N);

function idxnew=turn_idx(idx,n)
idxnew=zeros(size(idx));
N=length(idx);
idxnew(n+1:N)=idx(N:-1:n+1);
idxnew(1:n)=idx(n:-1:1);