function fn = best_feat(date, dataset, i)

if nargin<3, i=[]; end

dec1_arcene_dir={'vqUNMWlP', 'VeJsRriv', 'DZSQTBfy', 'XNexBfhI', 'HEdOWjxU'};
dec1_dexter_dir={'DZSQTBfy', 'voCGSrBX', 'EoeosKio', 'UFXqDSHR', 'XyxUJuLe'};
dec1_dorothea_dir={'aIiushFx', 'DZSQTBfy', 'WSRyGqDz', 'HEdOWjxU', 'pwKPKbca'};
dec1_gisette_dir={'tKBRMGYn', 'DRDFlzUC', 'GbXDjoiG', 'UFXqDSHR', 'DZSQTBfy'};
dec1_madelon_dir={'kPdhkAos', 'UFXqDSHR', 'WOzFIref', 'DZSQTBfy', 'DRDFlzUC'};

dec8_arcene_dir={'caBnuxYN', 'UHLVxHZK', 'RpBzOXAE', 'ZdtHhsyQ', 'wCttZQak'};
dec8_dexter_dir={'ZdtHhsyQ', 'caBnuxYN', 'bMLBEZfq', 'PVxqJatq', 'BuVgdqsc'};
dec8_dorothea_dir={'wCttZQak', 'caBnuxYN', 'untoIUbA', 'UHLVxHZK', 'oIiuFkuN'};
dec8_gisette_dir={'RqsEHylt', 'PVxqJatq', 'MLOvCsXB', 'oIiuFkuN', 'caBnuxYN'};
dec8_madelon_dir={'PDDChpVk', 'caBnuxYN', 'BuVgdqsc', 'jMqjOeOo', 'NiMXNqvY'};

switch date
    case 'dec1'
        switch lower(dataset)
            case 'arcene'
                if isempty(i) fn = dec1_arcene_dir; else fn = dec1_arcene_dir{i}; end
            case 'dexter'
                if isempty(i) fn = dec1_dexter_dir; else fn = dec1_dexter_dir{i}; end
            case 'dorothea'
                if isempty(i) fn = dec1_dorothea_dir; else fn = dec1_dorothea_dir{i}; end
            case 'gisette'
                if isempty(i) fn = dec1_gisette_dir; else fn = dec1_gisette_dir{i}; end
            case 'madelon'
                if isempty(i) fn = dec1_madelon_dir; else fn = dec1_madelon_dir{i}; end
        end
    case 'dec8'
        switch lower(dataset)
            case 'arcene'
                if isempty(i) fn = dec8_arcene_dir; else fn = dec8_arcene_dir{i}; end
            case 'dexter'
                if isempty(i) fn = dec8_dexter_dir; else fn = dec8_dexter_dir{i}; end
            case 'dorothea'
                if isempty(i) fn = dec8_dorothea_dir; else fn = dec8_dorothea_dir{i}; end
            case 'gisette'
                if isempty(i) fn = dec8_gisette_dir; else fn = dec8_gisette_dir{i}; end
            case 'madelon'
                if isempty(i) fn = dec8_madelon_dir; else fn = dec8_madelon_dir{i}; end
        end    
end
