/*
 * Decompiled with CFR 0.152.
 */
package applications.collages;

import algebras.algebra;
import applications.collages.collage;
import applications.collages.collageAlgebra;
import applications.collages.part;
import applications.geoWorld.geoWorldAlgebra;
import displays.PSDisplay;
import gui.scrollCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import util.list;

public class collageDisplay
extends PSDisplay {
    private collage displayed = null;
    private displayCanvas theCanvas = new displayCanvas();
    private static double initialScaling = 10.0;
    private boolean autoZoom = false;
    private boolean clip = false;
    private static double autoZoomSize = 0.9;
    private static double zoomFactor = 1.5;
    private double width = 500.0;
    private double height = 500.0;
    private static String zoomIn = "zoom in";
    private static String zoomOut = "zoom out";
    private static String auto = "auto zoom";
    private static String manual = "manual zoom";
    private static String reset = "reset";
    private static String clipOn = "clipping on";
    private static String clipOff = "clipping off";
    private static String[][] manualCommands = new String[][]{{zoomIn, zoomOut}, {auto, reset}};
    private static String[][] autoCommands = new String[][]{{manual}};
    private static String[] clipOffCommands = new String[]{clipOn};
    private static String[] clipOnCommands = new String[]{clipOff};
    private static String noInput = "missing or undefined input";
    private static Font noInputFont = new Font("Monospaced", 1, 14);

    public collageDisplay() {
        this.theCanvas.setSize((int)this.width, (int)this.height);
        this.theCanvas.resetView();
    }

    public boolean acceptable(algebra algebra2) {
        return algebra2 instanceof collageAlgebra || algebra2 instanceof geoWorldAlgebra;
    }

    protected void displayObject(Object object) {
        this.displayed = object instanceof collage ? (collage)object : null;
        this.setAbs();
        this.theCanvas.repaint();
    }

    private void setAbs() {
        if (this.displayed != null) {
            Rectangle2D.Double double_ = this.displayed.bounds();
            double_.x -= double_.width * (1.0 - autoZoomSize) / 2.0;
            double_.width /= autoZoomSize;
            double_.y -= double_.height * (1.0 - autoZoomSize) / 2.0;
            double_.height /= autoZoomSize;
            this.theCanvas.setAbsSilently(double_.x, double_.x + double_.width, -double_.y - double_.height, -double_.y);
        } else {
            this.theCanvas.setAbsSilently(0.0, 100.0, 0.0, 100.0);
        }
    }

    public Component visualizer() {
        return this.theCanvas;
    }

    public list commands() {
        list list2 = new list();
        String[][] stringArray = this.autoZoom ? autoCommands : manualCommands;
        for (int i = 0; i < stringArray.length; ++i) {
            list2.append(stringArray[i]);
        }
        if (super.PSOutputPossible()) {
            if (this.clip) {
                list2.append(clipOnCommands);
            } else {
                list2.append(clipOffCommands);
            }
        }
        list2.concat(super.commands());
        return list2;
    }

    public void execute(String string) {
        if (zoomIn.equals(string)) {
            this.theCanvas.scaleBy(zoomFactor);
            this.theCanvas.repaint();
        } else if (zoomOut.equals(string)) {
            this.theCanvas.scaleBy(1.0 / zoomFactor);
            this.theCanvas.repaint();
        } else if (reset.equals(string)) {
            this.theCanvas.enableScaling(true);
            this.theCanvas.resetView();
        } else if (auto.equals(string) || manual.equals(string)) {
            this.autoZoom = auto.equals(string);
            this.theCanvas.enableScrolling(!this.autoZoom);
            this.theCanvas.enableScaling(!this.autoZoom);
            if (this.autoZoom) {
                this.theCanvas.repaint();
            }
        } else if (clipOn.equals(string) || clipOff.equals(string)) {
            this.clip = clipOn.equals(string);
        } else {
            super.execute(string);
        }
    }

    protected final boolean PSOutputPossible() {
        return super.PSOutputPossible() && this.displayed != null;
    }

    protected final void PSOutput() {
        Enumeration enumeration2 = this.displayed.parts();
        while (enumeration2.hasMoreElements()) {
            part part2 = (part)enumeration2.nextElement();
            if (this.clip && !part2.getOutline().intersects(this.theCanvas.visible)) continue;
            Color color = part2.getColour();
            this.PSSetColour((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            double d = part2.getThickness();
            this.PSOutputBezierPart(part2, d);
        }
        this.PSOutputPreamble();
    }

    private void PSOutputBezierPart(part part2, double d) {
        PathIterator pathIterator = part2.getOutline().getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = part2.largeBounds();
        this.PSSetbbox(dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(dArray)) {
                case 0: {
                    this.PSMoveto(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    this.PSNextPointOfPath(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    this.PSNextBezierSegment(dArray[0], dArray[1], dArray[2], dArray[3], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    this.PSNextBezierSegment(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    this.PSWrite("  closepath\n");
                }
            }
            pathIterator.next();
        }
        this.PSStrokeOrFill(part2, d);
    }

    private void PSStrokeOrFill(part part2, double d) {
        if (part2.type() == 0) {
            this.PSFillPath();
        } else if (d >= 0.0) {
            this.PSStrokeThickPath(d);
        } else {
            this.PSStrokePath();
        }
    }

    private void PSOutputPreamble() {
        Rectangle2D.Double double_ = this.clip ? this.theCanvas.visible : this.displayed.bounds();
        this.PSPreamble(double_.x, double_.y, double_.x + double_.width, double_.y + double_.height);
    }

    private final class displayCanvas
    extends scrollCanvas {
        private static final long serialVersionUID = 1393729918001416214L;
        public Rectangle2D.Double visible = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        private AffineTransform view = new AffineTransform();
        private BufferedImage buffer = null;

        private displayCanvas() {
        }

        private void resetView() {
            Dimension dimension = this.getSize();
            this.setViewSilently((double)(-dimension.width) / initialScaling, (double)dimension.width / initialScaling, (double)(-dimension.height) / initialScaling, (double)dimension.height / initialScaling);
            this.repaint();
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.buffer != null) {
                graphics.drawImage(this.buffer, 0, 0, this);
            } else {
                this.repaint();
            }
        }

        public void update(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            this.waiting(graphics);
            BufferedImage bufferedImage = (BufferedImage)this.createImage(dimension.width, dimension.height);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setBackground(this.getBackground());
            if (collageDisplay.this.displayed != null) {
                if (collageDisplay.this.autoZoom) {
                    this.setZoom();
                }
                double d = (double)dimension.width / (this.viewR - this.viewL);
                this.view.setToTranslation((double)dimension.width / 2.0, (double)dimension.height / 2.0);
                this.view.scale(d, -d);
                this.view.translate(-(this.viewL + this.viewR) / 2.0, (this.viewB + this.viewT) / 2.0);
                this.visible.x = this.viewL;
                this.visible.y = -this.viewB;
                this.visible.width = this.viewR - this.viewL;
                this.visible.height = this.viewB - this.viewT;
                graphics2D.setTransform(this.view);
                Enumeration enumeration2 = collageDisplay.this.displayed.parts();
                while (enumeration2.hasMoreElements()) {
                    this.drawPart((part)enumeration2.nextElement(), graphics2D, d);
                }
            } else {
                graphics2D.setColor(Color.red);
                graphics2D.translate(this.getSize().width / 2, this.getSize().height / 2);
                graphics2D.setFont(noInputFont);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(noInputFont);
                int n = fontMetrics.stringWidth(noInput);
                int n2 = fontMetrics.getMaxAscent();
                graphics2D.drawString(noInput, -n / 2, n2 / 2);
                int n3 = fontMetrics.getMaxAdvance();
                graphics2D.drawRect(-(n + n3) / 2, -n2, n + n3, 2 * n2);
            }
            this.buffer = bufferedImage;
            this.paint(graphics);
            this.adjustScrollBars();
        }

        private void waiting(Graphics graphics) {
            if (this.buffer != null && collageDisplay.this.displayed != null && collageDisplay.this.displayed.numParts() > 5000) {
                String string = "Creating image...";
                Dimension dimension = this.getSize();
                Graphics2D graphics2D = this.buffer.createGraphics();
                graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics2D);
                float_.setRect(fontMetrics.getStringBounds(string, graphics2D));
                graphics2D.drawString(string, (int)((float)dimension.width - float_.width) / 2, (int)((float)dimension.height + float_.height) / 2 - (int)lineMetrics.getDescent());
                this.paint(graphics);
            }
        }

        public void setZoom() {
            Dimension dimension = this.getSize();
            Rectangle2D.Double double_ = collageDisplay.this.displayed.bounds();
            double_.x -= double_.width * (1.0 - autoZoomSize) / 2.0;
            double_.y -= double_.height * (1.0 - autoZoomSize) / 2.0;
            double_.width /= autoZoomSize;
            double_.height /= autoZoomSize;
            if ((double)dimension.width / (double)dimension.height >= double_.width / double_.height) {
                double d = double_.height / (double)dimension.height * (double)dimension.width;
                double_.x -= (d - double_.width) / 2.0;
                double_.width = d;
            } else {
                double d = double_.width / (double)dimension.width * (double)dimension.height;
                double_.y -= (d - double_.height) / 2.0;
                double_.height = d;
            }
            this.setViewSilently(double_.x, double_.x + double_.width, -double_.y - double_.height, -double_.y);
        }

        public void scaleBy(double d) {
            double d2 = (this.viewR - this.viewL) / d;
            double d3 = (this.viewB - this.viewT) / d;
            this.setViewSilently((this.viewL + this.viewR - d2) / 2.0, (this.viewL + this.viewR + d2) / 2.0, (this.viewT + this.viewB - d3) / 2.0, (this.viewT + this.viewB + d3) / 2.0);
        }

        private void drawPart(part part2, Graphics2D graphics2D, double d) {
            graphics2D.setColor(part2.getColour());
            GeneralPath generalPath = part2.getOutline();
            if (part2.type() == 0 || part2.getThickness() < 0.0) {
                graphics2D.setStroke(new BasicStroke((float)(1.0 / d), 0, 0));
            } else {
                graphics2D.setStroke(new BasicStroke((float)part2.getThickness(), 0, 0));
            }
            graphics2D.draw(generalPath);
            if (part2.type() == 0) {
                graphics2D.fill(generalPath);
            }
        }

        protected void resizeView() {
            double d = this.getSize().width;
            double d2 = this.getSize().height;
            if (!collageDisplay.this.autoZoom) {
                double d3 = (this.viewR - this.viewL) * (d / collageDisplay.this.width);
                double d4 = (this.viewL + this.viewR - d3) / 2.0;
                double d5 = (this.viewL + this.viewR + d3) / 2.0;
                d3 = (this.viewB - this.viewT) * (d2 / collageDisplay.this.height);
                this.setViewSilently(d4, d5, (this.viewT + this.viewB - d3) / 2.0, (this.viewT + this.viewB + d3) / 2.0);
            }
            collageDisplay.this.width = d;
            collageDisplay.this.height = d2;
            this.invalidate();
            this.repaint();
        }

        protected void scalingRequest(double d, double d2, double d3, double d4) {
            this.setViewSilently(d, d2, d3, d4);
            this.resizeView();
        }
    }
}

