/*
 * Decompiled with CFR 0.152.
 */
package applications.lineDrawings;

import applications.lineDrawings.line;
import applications.lineDrawings.lineDrawing;
import applications.lineDrawings.lineDrawingAlgebra;
import java.awt.Color;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.turtleAlgebraParser;
import terms.signature;
import terms.symbol;

public class turtleAlgebra
extends lineDrawingAlgebra {
    private signature Fs;
    private signature fs;
    private static String hide = "hide";
    private static String encapsulate = "enc";
    private static char plus = (char)43;
    private static char minus = (char)45;
    private static String branch = "branch";
    private static String fill = "fill";
    private static int rotOp = 0;
    private static int branchOp = 1;
    private static int fillOp = 2;
    private double angle = 1.5707963267948966;
    private double Fx;
    private double Fy;

    protected Object apply(symbol symbol2, Object[] objectArray) {
        if (this.Fs.contains(symbol2)) {
            return new lineDrawing(new line(0.0, 0.0, this.Fx, this.Fy));
        }
        if (this.fs.contains(symbol2)) {
            line line2 = new line(0.0, 0.0, this.Fx, this.Fy);
            line2.hidden = true;
            lineDrawing lineDrawing2 = new lineDrawing(line2);
            return lineDrawing2;
        }
        lineDrawing lineDrawing3 = (lineDrawing)super.apply(symbol2, objectArray);
        if (hide.equals(symbol2.toString())) {
            lineDrawing3.hideLines();
        } else if (encapsulate.equals(symbol2.toString())) {
            lineDrawing3.setEndpoint(0.0, 0.0);
            lineDrawing3 = new lineDrawing(lineDrawing3, lineDrawing.branch, null);
        } else {
            Object object = this.operationOf(symbol2);
            if (object instanceof operation) {
                operation operation2 = (operation)object;
                if (operation2.type == rotOp || operation2.type == branchOp) {
                    if (operation2.angle != 0.0) {
                        lineDrawing3.rotate(operation2.angle);
                    }
                    if (operation2.type == branchOp) {
                        lineDrawing3.setEndpoint(0.0, 0.0);
                        lineDrawing3 = new lineDrawing(lineDrawing3, lineDrawing.branch, null);
                    }
                } else {
                    lineDrawing3 = new lineDrawing(lineDrawing3, lineDrawing.filledPolygon, new Color(operation2.r, operation2.g, operation2.b));
                }
            }
        }
        return lineDrawing3;
    }

    protected Object extendBy(symbol symbol2) {
        Object object = super.extendBy(symbol2);
        if (object != null) {
            return object;
        }
        String string = symbol2.toString();
        if (string.startsWith(encapsulate)) {
            string = string.substring(encapsulate.length()) + branch;
        }
        if (string.endsWith(branch)) {
            return this.rotOp(string, true);
        }
        if (string.startsWith(fill)) {
            return this.fillOp(string);
        }
        return this.rotOp(string, false);
    }

    private operation rotOp(String string, boolean bl) {
        int n;
        int n2 = 1;
        int n3 = string.length() - 1;
        if (bl) {
            n3 -= branch.length();
        }
        if (n3 < 0 || string.charAt(n3) != plus && string.charAt(n3) != minus) {
            return new operation(0.0, false);
        }
        if (string.charAt(n3) == minus) {
            n2 = -1;
        }
        if (n3 == 0) {
            return new operation((double)n2 * this.angle, bl);
        }
        String string2 = string.substring(0, n3);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return new operation(0.0, false);
        }
        if (n <= 0) {
            return new operation(0.0, false);
        }
        return new operation((double)n2 * this.angle * (double)n, bl);
    }

    private operation fillOp(String string) {
        String string2;
        String string3;
        String string4;
        int n = (string = string.substring(fill.length())).indexOf(45);
        if (n < 0) {
            string3 = string4 = string;
            string2 = string4;
        } else {
            string2 = string.substring(0, n);
            if ((n = (string = string.substring(n + 1)).indexOf(45)) < 0) {
                return new operation(0.0, false);
            }
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        try {
            float f = Float.valueOf(string2).floatValue();
            float f2 = Float.valueOf(string3).floatValue();
            float f3 = Float.valueOf(string4).floatValue();
            if (f >= 0.0f && f <= 1.0f && f2 >= 0.0f && f2 <= 1.0f && f3 >= 0.0f && f3 <= 1.0f) {
                return new operation(f, f2, f3);
            }
            return new operation(0.0, false);
        }
        catch (NumberFormatException numberFormatException) {
            return new operation(0.0, false);
        }
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        turtleAlgebraParser turtleAlgebraParser2 = new turtleAlgebraParser(aSCII_CharStream);
        turtleAlgebraParser2.turtleAlgebra();
        this.angle = turtleAlgebraParser2.angle;
        this.Fx = Math.cos(turtleAlgebraParser2.Fangle);
        this.Fy = Math.sin(turtleAlgebraParser2.Fangle);
        this.Fs = turtleAlgebraParser2.FSynonyms;
        this.fs = turtleAlgebraParser2.fSynonyms;
    }

    private class operation {
        public double angle;
        public float r;
        public float g;
        public float b;
        public int type;

        public operation(double d, boolean bl) {
            this.angle = d;
            this.type = bl ? branchOp : rotOp;
        }

        public operation(float f, float f2, float f3) {
            this.r = f;
            this.g = f2;
            this.b = f3;
            this.type = fillOp;
        }
    }
}

