/*
 * Decompiled with CFR 0.152.
 */
package displays;

import displays.display;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.Window;
import util.list;

public class textualDisplay
extends display {
    private int fontSize = 18;
    private String fontName;
    private static int fontStyle = 1;
    private static String noText = "   < undefined >   ";
    private int rows = 1;
    private int columns = 30;
    private TextArea area = new TextArea("", this.rows, this.columns, 0);
    private static String larger = "larger";
    private static String smaller = "smaller";
    private static String adjustSize = "adjust window size";
    private static String[] fontCommands = new String[]{larger, smaller};
    private static String[] windowCommands = new String[]{adjustSize};

    public textualDisplay() {
        this.area.setEditable(false);
        this.area.setBackground(Color.white);
        this.fontName = "Monospaced";
        this.setFontSize();
    }

    private void setFontSize() {
        this.area.setFont(new Font(this.fontName, fontStyle, this.fontSize));
    }

    private String formatText(String string) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                stringBuffer.append(" \n ");
                continue;
            }
            if (string.charAt(i) == '\\' && i + 1 < string.length() && string.charAt(i + 1) == '\\') {
                stringBuffer.append(" \n ");
                ++i;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    protected void displayObject(Object object) {
        if (object != null) {
            this.columns = 0;
            int n = 0;
            this.rows = 1;
            String string = this.formatText(object.toString());
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '\n') {
                    ++this.rows;
                    this.columns = Math.max(this.columns, n);
                    n = 0;
                    continue;
                }
                ++n;
            }
            this.columns = Math.max(this.columns, n);
            this.area.setText(string);
        } else {
            this.area.setText(noText);
            this.rows = 1;
            this.columns = noText.length();
        }
    }

    public Component visualizer() {
        return this.area;
    }

    public list commands() {
        list list2 = new list();
        list2.append(fontCommands);
        list2.append(windowCommands);
        return list2;
    }

    public void execute(String string) {
        if (adjustSize.equals(string)) {
            this.area.setRows(this.rows);
            this.area.setColumns(this.columns);
        } else if (larger.equals(string) || smaller.equals(string) && this.fontSize > 1) {
            this.fontSize = larger.equals(string) ? ++this.fontSize : --this.fontSize;
            this.setFontSize();
            this.area.setColumns(this.area.getColumns());
        }
        for (Container container = this.area.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            ((Window)container).pack();
            container.repaint();
            break;
        }
    }
}

