/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.sortManager;
import generators.treeGrammar;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.treeEnumeratorParser;
import terms.symbol;
import terms.term;
import util.list;

public class treeEnumerator
extends treeGrammar {
    protected static final String advance = "advance";
    protected static String enumerate = "enumeration";
    protected static String generate = "random generation";
    protected static String refine = "refine";
    protected static String back = "back";
    protected static String reset = "reset";
    private static String[][] eCommands = new String[][]{{"advance", reset}, {generate}};
    private static String[][] gCommands = new String[][]{{refine, back, reset}, {enumerate}};
    public boolean isEnumerate = true;
    private term currTerm;
    private term resultingTerm;
    private sortManager sm = new sortManager();
    private int currDepth = 0;
    private boolean noMoreTerms = false;
    private int mainSort;

    public list commands() {
        list list2 = new list();
        if (this.isEnumerate) {
            for (int i = 0; i < eCommands.length; ++i) {
                list2.append(eCommands[i]);
            }
        } else {
            for (int i = 0; i < gCommands.length; ++i) {
                list2.append(gCommands[i]);
            }
        }
        return list2;
    }

    public void execute(String string) {
        if (advance.equals(string) && this.isEnumerate) {
            this.advance(0);
        } else if (reset.equals(string)) {
            this.reset();
        } else if (refine.equals(string) && !this.isEnumerate) {
            this.refine();
        } else if (back.equals(string) && !this.isEnumerate) {
            this.back();
        } else if (enumerate.equals(string) && !this.isEnumerate) {
            this.isEnumerate = true;
            if (this.currTerm != null) {
                this.noMoreTerms = false;
                if (this.randomTermination(this.currTerm)) {
                    this.currDepth = this.depth(this.currTerm);
                } else {
                    this.currDepth = this.minSortDepth(this.currTerm);
                    if (this.currDepth == 0) {
                        this.advance(0);
                    } else {
                        this.advance(1);
                    }
                }
            } else {
                this.noMoreTerms = true;
            }
        } else if (generate.equals(string) && this.isEnumerate) {
            this.isEnumerate = false;
            if (this.noMoreTerms) {
                this.reset();
            } else {
                this.removeLeaves(this.currTerm, this.currDepth);
                this.currDepth = 0;
            }
        }
        this.computeResultingTerm();
    }

    public boolean requestsExit(String string) {
        return string == reset;
    }

    public void setMainSort(String string) {
        this.mainSort = this.sm.findSort(string);
    }

    public void initMinDepths() {
        this.sm.initMinDepths();
    }

    public void addSymbol(String string, String string2, String[] stringArray, double d) {
        this.sm.addSymbol(string, string2, stringArray, d);
    }

    public term currentTerm() {
        return this.resultingTerm;
    }

    private void computeResultingTerm() {
        this.resultingTerm = this.currTerm == null ? null : (this.isEnumerate ? (this.noMoreTerms ? null : this.computeResultingTerm(this.currTerm, this.currDepth)) : (term)this.currTerm.clone());
    }

    private term computeResultingTerm(term term2, int n) {
        term term3 = new term(term2.topSymbol());
        symbol symbol2 = term2.topSymbol();
        for (int i = symbol2.rank(); i > 0; --i) {
            if (n == 1) {
                term3.defineSubterm(i, new term(this.sm.sortSymbol(this.sm.sortIndex(symbol2, i))));
                continue;
            }
            term3.defineSubterm(i, this.computeResultingTerm(term2.subterm(i), n - 1));
        }
        return term3;
    }

    private void reset() {
        this.noMoreTerms = false;
        this.currDepth = 0;
        if (this.isEnumerate) {
            this.advance(0);
        } else {
            this.currTerm = new term(this.sm.sortSymbol(this.mainSort));
        }
    }

    private void advance(int n) {
        int n2 = 0;
        boolean bl = false;
        while (!this.noMoreTerms) {
            this.allowExit();
            if (this.currDepth == 0) {
                if (n2 > this.sm.numberOfSorts()) {
                    this.noMoreTerms = true;
                } else {
                    symbol symbol2 = this.sm.firstSymbol(this.mainSort);
                    while (symbol2 != null) {
                        if (n > 0 || symbol2.rank() == 0) {
                            this.currTerm = new term(symbol2);
                            break;
                        }
                        symbol2 = this.sm.nextSymbol(symbol2);
                    }
                    ++n2;
                    if (symbol2 == null) {
                        ++n;
                    } else {
                        this.currDepth = 1;
                        bl = false;
                    }
                }
            } else {
                list list2 = this.getBottomLine(this.currTerm, this.currDepth - 1);
                if (n == 0) {
                    if (!this.tryAdvance(list2, true)) {
                        bl = true;
                        n = 1;
                        --this.currDepth;
                        ++n2;
                    }
                } else if (bl) {
                    if (this.tryAdvance(list2, false)) {
                        bl = false;
                    } else {
                        ++n;
                        --this.currDepth;
                    }
                } else if (this.tryDownwards(list2, n == 1)) {
                    --n;
                    ++this.currDepth;
                } else {
                    bl = true;
                }
            }
            if (n != 0) continue;
            return;
        }
    }

    private list getBottomLine(term term2, int n) {
        list list2 = new list();
        if (n == 0) {
            list2.append(term2);
        } else {
            int n2 = term2.topSymbol().rank();
            for (int i = 0; i < n2; ++i) {
                list2.concat(this.getBottomLine(term2.subterm(i), n - 1));
            }
        }
        return list2;
    }

    private boolean tryAdvance(list list2, boolean bl) {
        while (!list2.isEmpty()) {
            this.allowExit();
            term term2 = (term)list2.head();
            symbol symbol2 = this.sm.nextSymbol(term2.topSymbol());
            while (symbol2 != null) {
                if (!bl || symbol2.rank() == 0) {
                    term2.relabel(symbol2);
                    return true;
                }
                symbol2 = this.sm.nextSymbol(symbol2);
            }
            symbol2 = this.sm.firstSymbol(this.sm.sortIndex(term2.topSymbol()));
            while (symbol2 != null) {
                if (!bl || symbol2.rank() == 0) {
                    term2.relabel(symbol2);
                    list2 = list2.tail();
                    break;
                }
                symbol2 = this.sm.nextSymbol(symbol2);
            }
            if (symbol2 != null) continue;
            return false;
        }
        return false;
    }

    private boolean tryDownwards(list list2, boolean bl) {
        boolean bl2 = false;
        while (!list2.isEmpty()) {
            this.allowExit();
            term term2 = (term)list2.head();
            symbol symbol2 = term2.topSymbol();
            if (symbol2.rank() > 0) {
                for (int i = 0; i < symbol2.rank(); ++i) {
                    symbol symbol3 = this.sm.firstSymbol(this.sm.sortIndex(symbol2, i));
                    while (symbol3 != null) {
                        if (!bl || symbol3.rank() == 0) {
                            term2.defineSubterm(i, new term(symbol3));
                            break;
                        }
                        symbol3 = this.sm.nextSymbol(symbol3);
                    }
                    if (symbol3 != null) continue;
                    return false;
                }
                bl2 = true;
            }
            list2 = list2.tail();
        }
        return bl2;
    }

    private int depth(term term2) {
        if (term2 == null) {
            return 0;
        }
        symbol symbol2 = term2.topSymbol();
        if (this.sm.isSort(symbol2)) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < symbol2.rank(); ++i) {
            n = Math.max(n, this.depth(term2.subterm(i)));
        }
        return n + 1;
    }

    private int minSortDepth(term term2) {
        if (term2 == null) {
            return 0;
        }
        symbol symbol2 = term2.topSymbol();
        if (this.sm.isSort(symbol2)) {
            return 0;
        }
        int n = -2;
        for (int i = 0; i < symbol2.rank(); ++i) {
            int n2 = this.minSortDepth(term2.subterm(i));
            if (n2 < 0) continue;
            n = n >= 0 ? Math.min(n, n2) : n2;
        }
        return n + 1;
    }

    private void refine() {
        if (this.currTerm != null && !this.refine(this.currTerm)) {
            this.currTerm = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean refine(term term2) {
        this.allowExit();
        symbol symbol2 = term2.topSymbol();
        if (this.sm.isSort(symbol2)) {
            symbol symbol3 = this.sm.firstSymbol(this.sm.sortIndex(symbol2));
            double d = 0.0;
            double d2 = 0.0;
            boolean bl = false;
            while (symbol3 != null) {
                double d3 = this.sm.getWeight(symbol3);
                if (d3 > 0.0) {
                    d += d3;
                    if (Math.random() <= d3 / d) {
                        term2.relabel(symbol3);
                        bl = true;
                    }
                } else if (d == 0.0) {
                    d2 += 1.0;
                    if (Math.random() <= 1.0 / d2) {
                        term2.relabel(symbol3);
                        bl = true;
                    }
                }
                symbol3 = this.sm.nextSymbol(symbol3);
            }
            if (!bl) return false;
            symbol2 = term2.topSymbol();
            for (int i = 0; i < symbol2.rank(); ++i) {
                term2.defineSubterm(i, new term(this.sm.sortSymbol(this.sm.sortIndex(symbol2, i))));
            }
            return true;
        } else {
            for (int i = 0; i < symbol2.rank(); ++i) {
                if (this.refine(term2.subterm(i))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean randomTermination(term term2) {
        symbol symbol2 = term2.topSymbol();
        if (this.sm.isSort(symbol2)) {
            if (this.sm.getMinDepth(symbol2) == 2.147483647E9) {
                return false;
            }
            this.terminate(term2);
            return true;
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (this.randomTermination(term2.subterm(i))) continue;
            return false;
        }
        return true;
    }

    private void terminate(term term2) {
        symbol symbol2 = term2.topSymbol();
        symbol symbol3 = this.sm.firstSymbol(this.sm.sortIndex(symbol2));
        double d = 0.0;
        while (symbol3 != null) {
            double d2 = this.sm.getWeight(symbol3);
            if ((d2 > 0.0 || d == 0.0) && this.sm.getMinDepth(symbol3) == this.sm.getMinDepth(symbol2) && ((d += d2) == 0.0 || Math.random() <= d2 / d)) {
                term2.relabel(symbol3);
            }
            symbol3 = this.sm.nextSymbol(symbol3);
        }
        symbol2 = term2.topSymbol();
        for (int i = 0; i < symbol2.rank(); ++i) {
            term2.defineSubterm(i, new term(this.sm.sortSymbol(this.sm.sortIndex(symbol2, i))));
            this.terminate(term2.subterm(i));
        }
    }

    private void back() {
        int n = this.depth(this.currTerm);
        if (n > 0) {
            this.removeLeaves(this.currTerm, n);
        }
    }

    private void removeLeaves(term term2, int n) {
        symbol symbol2 = term2.topSymbol();
        if (n == 1) {
            term2.relabel(this.sm.sortSymbol(this.sm.sortIndex(symbol2)));
        } else {
            for (int i = 0; i < symbol2.rank(); ++i) {
                this.removeLeaves(term2.subterm(i), n - 1);
            }
        }
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        treeEnumeratorParser treeEnumeratorParser2 = new treeEnumeratorParser(aSCII_CharStream);
        treeEnumerator treeEnumerator2 = treeEnumeratorParser2.treeEnumerator();
        this.sm = treeEnumerator2.sm;
        this.mainSort = treeEnumerator2.mainSort;
        this.advance(0);
        this.computeResultingTerm();
    }
}

