/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.edge;
import gui.node;
import gui.nodeTypes.worksheetNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class invisibleNode
extends node
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1234662582113166399L;
    private edge dangling = null;
    private static Color colourOK;
    private static Color colourKO;

    public invisibleNode() {
        colourOK = Color.green.darker();
        colourKO = Color.red;
    }

    public void activateAtWith(int x, int y, edge dangling) {
        this.setPosition(x, y);
        this.dangling = dangling;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setChanged();
        this.notifyObservers();
    }

    public void mouseClicked(MouseEvent e) {
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.parent().setTarget(this.position);
        this.dangling = null;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.setPosition(this.position.x + e.getPoint().x, this.position.y + e.getPoint().y);
    }

    private void setPosition(int x, int y) {
        Dimension d = this.getParent().getSize();
        x = Math.min(x, d.width);
        y = Math.min(y, d.height);
        this.position.x = Math.max(0, x);
        this.position.y = Math.max(0, y);
        this.setBounds(this.position.x, this.position.y, 0, 0);
        this.setChanged();
        this.notifyObservers();
    }

    public boolean contains(int x, int y) {
        return this.dangling != null;
    }

    public boolean contains(Point p) {
        return true;
    }

    public Point getBorderPoint(Point seenFrom) {
        if (this.dangling == null) {
            return this.position;
        }
        worksheetNode n = this.parent().getNodeAt(this.position.x, this.position.y);
        if (n != null && n.acceptsSource((worksheetNode)this.dangling.source)) {
            this.dangling.setColour(colourOK);
            return n.getBorderPoint(seenFrom);
        }
        this.dangling.setColour(colourKO);
        return this.position;
    }
}

