/*
 * Decompiled with CFR 0.152.
 */
package gui.nodeTypes;

import gui.commandPanel;
import gui.componentGraph;
import gui.edge;
import gui.editor;
import gui.errorDisplay;
import gui.popupMenu;
import gui.reactive;
import gui.visibleNode;
import gui.worksheet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.TokenMgrError;
import parsers.objectParser;
import parsers.parsable;
import util.ExitException;
import util.exitableThread;
import util.includer;
import util.list;
import util.observable;

public class worksheetNode
extends visibleNode
implements Runnable,
ActionListener {
    private static final long serialVersionUID = -3135688418575383122L;
    public parsable contents;
    public String fileName = null;
    public static String edit = "edit";
    public static String reload = "reload";
    public static String delete = "delete";
    private static String[] commands = new String[]{edit, reload, delete};
    public static int USER_COMMAND = 0;
    public static int VALUE = 1;
    public static int STOP = 2;
    private commandPanel panel;
    private popupMenu menu;
    private exitableThread contentsThread;
    private list pendingCommands = new list();
    protected observable obs = new observable();
    protected edge inputEdge = null;
    private list editors = new list();

    public worksheetNode(parsable obj, String fileName) {
        this.fileName = fileName;
        this.contents = obj;
        this.addLabel(this.getName());
        this.addLabel("[" + obj.getClassName() + "]");
        this.panel = new commandPanel(this);
        this.menu = new popupMenu(this);
        this.add(this.menu);
    }

    public void inputEdgeEstablished(edge e) {
        if (this.inputEdge != null) {
            this.parent().deleteEdge(this.inputEdge);
        }
        this.inputEdge = e;
        worksheetNode source = (worksheetNode)e.source;
        this.transferCommand(source.current(), VALUE);
    }

    public void inputEdgeDeleted(edge e) {
        this.inputEdge = null;
        this.transferCommand(null, VALUE);
    }

    protected synchronized Object current() {
        return null;
    }

    public void start() {
        this.updateCommandList();
        this.contentsThread = new exitableThread(this);
        this.contentsThread.start();
    }

    public String getName() {
        return this.contents.getName();
    }

    public void initialize() throws ParseException {
    }

    public int openWindows() {
        return worksheet.tabs.isShown(this.panel) ? 1 : 0;
    }

    public boolean acceptsSource(worksheetNode source) {
        return !this.parent().existsPath(this, source);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isAltDown() || e.isMetaDown()) {
            this.menu.show(this, e.getPoint().x, e.getPoint().y);
        } else {
            super.mousePressed(e);
        }
    }

    public void actionPerformed(ActionEvent event) {
        componentGraph p = this.parent();
        p.addToActiveCount(1);
        String command = event.getActionCommand();
        if (edit.equals(command)) {
            new editor(this.fileName, this);
        } else if (reload.equals(command)) {
            this.reload(this.fileName);
        } else if (delete.equals(command)) {
            this.delete(false);
        } else {
            this.transferCommand(command, USER_COMMAND);
        }
        p.addToActiveCount(-1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reload(String file) {
        block17: {
            oldContentsThread = this.contentsThread;
            this.transferCommand(null, worksheetNode.STOP);
            try {
                oldContentsThread.join();
            }
            catch (InterruptedException var3_3) {
                // empty catch block
            }
            ok = false;
            parsed = null;
            input = null;
            try {
                try {
                    input = new includer(new File(file));
                    parser = new objectParser(new ASCII_CharStream(input, 1, 1));
                    parsed = parser.parse();
                    this.fileName = file;
                    ok = true;
                }
                catch (includer.IncludeFileNotFoundException e) {
                    errorDisplay.show("Parsing of `" + this.fileName + "' failed: file not found");
                }
                catch (ParseException e) {
                    errorDisplay.show("Parsing of `" + this.fileName + "' failed:\n" + e.getMessage());
                }
                catch (TokenMgrError e) {
                    errorDisplay.show("Parsing of `" + this.fileName + "' failed:\n" + e.getMessage());
                }
            }
            catch (Throwable var8_11) {
                var7_12 = null;
                if (input == null) throw var8_11;
                try {
                    input.close();
                    throw var8_11;
                }
                catch (IOException var9_14) {
                    // empty catch block
                }
                throw var8_11;
            }
            {
                var7_13 = null;
                if (input == null) break block17;
            }
            ** try [egrp 3[TRYBLOCK] [6 : 216->224)] { 
lbl41:
            // 1 sources

            input.close();
            break block17;
lbl43:
            // 1 sources

            catch (IOException var9_15) {
                // empty catch block
            }
        }
        if (ok) {
            if (parsed.getClass().equals(this.contents.getClass())) {
                if (parsed.getName() == null) {
                    parsed.setName("file " + this.fileName.substring(this.fileName.lastIndexOf(File.separatorChar) + 1));
                }
                this.reinit(parsed);
            } else {
                errorDisplay.show("Reload failed! Unable to reload '" + this.fileName + "' because the class of the component has been changed");
            }
        }
        this.updateCommandList();
        this.contentsThread = new exitableThread(this);
        this.contentsThread.start();
        if (this.inputEdge != null) {
            source = (worksheetNode)this.inputEdge.source;
            this.transferCommand(source.current(), worksheetNode.VALUE);
            return ok;
        }
        this.transferCommand(null, worksheetNode.VALUE);
        return ok;
    }

    public void delete(boolean force) {
        if (force || this.confirm()) {
            while (!this.editors.isEmpty()) {
                ((editor)this.editors.head()).dispose();
                this.editors.removeFirst();
            }
            exitableThread oldContentsThread = this.contentsThread;
            this.transferCommand(null, STOP);
            try {
                oldContentsThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dispose();
            this.parent().deleteNode(this);
        }
    }

    public synchronized boolean isUnsaved() {
        list l = this.editors;
        while (!l.isEmpty()) {
            if (((editor)l.head()).isUnsaved()) {
                return true;
            }
            l = l.tail();
        }
        return false;
    }

    public synchronized void addEditor(editor ed) {
        this.editors.prepend(ed);
    }

    public synchronized void removeEditor(editor ed) {
        list l = this.editors;
        while (!l.isEmpty()) {
            if (l.head() == ed) {
                l.removeFirst();
                break;
            }
            l = l.tail();
        }
    }

    public synchronized boolean confirm() {
        if (!this.isUnsaved()) {
            return true;
        }
        int choice = JOptionPane.showConfirmDialog(null, "Unsaved file(s). Delete node anyway?", "Unsaved file(s)!", 0, 3);
        return choice == 0;
    }

    public synchronized void transferCommand(Object com, int type) {
        if (type == STOP) {
            this.pendingCommands.removeAllElements();
            if (this.contentsThread != null) {
                this.contentsThread.exitRequest(true);
            }
        } else if (type == USER_COMMAND && edit.equals(com)) {
            new editor(this.fileName, this);
        } else if (type == VALUE || type == USER_COMMAND && this.contents instanceof reactive && ((reactive)((Object)this.contents)).requestsExit((String)com)) {
            list l = this.pendingCommands;
            while (!l.isEmpty()) {
                if (((cmd)this.pendingCommands.head()).type == VALUE) {
                    l.removeFirst();
                    continue;
                }
                l = l.tail();
            }
            if (this.contentsThread != null) {
                this.contentsThread.exitRequest(true);
            }
        }
        this.pendingCommands.append(new cmd(com, type));
        this.notifyAll();
    }

    protected void broadcastResult(Object o) {
        this.obs.setChanged();
        this.obs.notifyObservers(o);
    }

    public void open() {
        if (!worksheet.tabs.isShown(this.panel)) {
            worksheet.tabs.addTab(this.contents.getName(), this.panel);
        }
    }

    private void updateCommandList() {
        list com = this.contents instanceof reactive ? ((reactive)((Object)this.contents)).commands() : new list();
        com.append(commands);
        this.panel.setCommands(com);
        this.menu.setCommands(com);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            Object var4_5;
            int type;
            Object command;
            worksheetNode worksheetNode2 = this;
            synchronized (worksheetNode2) {
                while (true) {
                    if (!this.pendingCommands.isEmpty()) {
                        command = ((cmd)this.pendingCommands.head()).com;
                        type = ((cmd)this.pendingCommands.head()).type;
                        this.pendingCommands.removeFirst();
                        this.contentsThread.exitRequest(false);
                        this.notifyAll();
                        break;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (type == STOP) {
                this.contentsThread = null;
                worksheetNode2 = this;
                synchronized (worksheetNode2) {
                    this.notifyAll();
                    return;
                }
            }
            try {
                try {
                    this.parent().addToActiveCount(1);
                    this.runContents(command, type);
                }
                catch (ExitException exitException) {}
            }
            catch (Throwable throwable) {
                var4_5 = null;
                this.parent().addToActiveCount(-1);
                throw throwable;
            }
            {
                var4_5 = null;
                this.parent().addToActiveCount(-1);
                this.updateCommandList();
                continue;
            }
            break;
        }
    }

    public void runContents(Object command, int type) {
        if (type == USER_COMMAND && this.contents instanceof reactive) {
            ((reactive)((Object)this.contents)).execute((String)command);
        }
    }

    protected synchronized void dispose() {
        this.panel.dispose();
        this.menu.removeActionListener(this);
        this.parent().removeComponentListener(this);
        this.contents.dispose();
        this.obs.deleteObservers();
    }

    public void addObservingEdge(edge e) {
        this.obs.addObserver(e);
    }

    public void deleteObservingEdge(edge e) {
        this.obs.deleteObserver(e);
    }

    protected void reinit(parsable newContents) {
        parsable oldContents = this.contents;
        this.contents = newContents;
        try {
            this.initialize();
        }
        catch (ParseException e) {
            errorDisplay.show("Initialization failed:\n" + e.getMessage());
            this.contents = oldContents;
            return;
        }
        oldContents.dispose();
        this.contents.setName(this.contents.getBasename());
        this.removeLabels();
        this.addLabel(this.contents.getName());
        this.addLabel("[" + newContents.getClassName() + "]");
        this.invalidate();
        this.repaint();
    }

    private class cmd {
        public Object com;
        public int type;

        public cmd(Object c, int t) {
            this.com = c;
            this.type = t;
        }
    }
}

