/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import generators.rexp;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ET0LTreeGrammarParserConstants;
import parsers.ET0LTreeGrammarParserTokenManager;
import parsers.ParseException;
import parsers.Token;
import parsers.componentParser;
import parsers.setParser;
import parsers.termParser;
import parsers.trsParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.term;
import terms.variable;

public class ET0LTreeGrammarParser
implements componentParser,
ET0LTreeGrammarParserConstants {
    protected ASCII_CharStream inputStream;
    private rulesParser tableParser;
    private termParser terms;
    private setParser tablesParser;
    private Vector rules;
    private int tableNameNo = 0;
    private String tableName;
    public Vector tables = new Vector();
    public Vector tableNames = new Vector();
    public fixedRankSignature nonterminals = new fixedRankSignature(0);
    public finiteSignature sig = new finiteSignature();
    public term axiom;
    public rexp regulation = null;
    public ET0LTreeGrammarParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private final int[] jj_la1_0 = new int[]{1024, 1024, 8512, 6144, 8512};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public ET0LTreeGrammarParser(ASCII_CharStream aSCII_CharStream) {
        this(new ET0LTreeGrammarParserTokenManager(aSCII_CharStream));
        this.tableParser = new rulesParser(aSCII_CharStream);
        this.tablesParser = new setParser(aSCII_CharStream);
        this.terms = new termParser(aSCII_CharStream);
        this.inputStream = aSCII_CharStream;
    }

    public void component() throws ParseException {
        do {
            this.tableName = "t" + ++this.tableNameNo;
        } while (this.nonterminals.contains(new symbol(this.tableName, 0)) || this.sig.contains(new symbol(this.tableName, 1)));
        this.tableNames.addElement(this.tableName);
        this.rules = new Vector();
        this.tables.addElement(this.rules);
        this.tableParser.rules();
    }

    public final void ET0LTreeGrammar() throws ParseException {
        this.jj_consume_token(6);
        this.nonterminals.parse(this.inputStream);
        this.jj_consume_token(10);
        this.sig.parse(this.inputStream);
        this.jj_consume_token(10);
        this.tablesParser.set(this);
        this.jj_consume_token(10);
        this.axiom = this.tableParser.mkRHS(this.terms.term());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                this.regulation = this.rexp();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
    }

    public final rexp rexp() throws ParseException {
        rexp rexp2 = this.rexp1();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                rexp rexp3 = this.rexp();
                return rexp.union(rexp2, rexp3);
            }
        }
        this.jj_la1[1] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp1() throws ParseException {
        rexp rexp2 = this.rexp2();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 8: 
            case 13: {
                rexp rexp3 = this.rexp1();
                return rexp.conc(rexp2, rexp3);
            }
        }
        this.jj_la1[2] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp2() throws ParseException {
        rexp rexp2 = this.rexp3();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                return rexp.star(rexp2);
            }
            case 12: {
                this.jj_consume_token(12);
                return rexp.plus(rexp2);
            }
        }
        this.jj_la1[3] = this.jj_gen;
        return rexp2;
    }

    public final rexp rexp3() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token token = this.jj_consume_token(13);
                int n = 0;
                try {
                    n = Integer.parseInt(token.image);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n > this.tables.size()) {
                    throw new ParseException("undefined table `" + n + "' in regulating expression");
                }
                return rexp.num(n);
            }
            case 6: {
                this.jj_consume_token(6);
                rexp rexp2 = this.rexp();
                this.jj_consume_token(7);
                return rexp2;
            }
            case 8: {
                this.jj_consume_token(8);
                rexp rexp3 = this.rexp();
                this.jj_consume_token(9);
                return rexp.opt(rexp3);
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public ET0LTreeGrammarParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new ET0LTreeGrammarParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ET0LTreeGrammarParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new ET0LTreeGrammarParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ET0LTreeGrammarParser(ET0LTreeGrammarParserTokenManager eT0LTreeGrammarParserTokenManager) {
        this.token_source = eT0LTreeGrammarParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ET0LTreeGrammarParserTokenManager eT0LTreeGrammarParserTokenManager) {
        this.token_source = eT0LTreeGrammarParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[14];
        for (n2 = 0; n2 < 14; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 5; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 14; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, ET0LTreeGrammarParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private class rulesParser
    extends trsParser {
        public rulesParser(ASCII_CharStream aSCII_CharStream) {
            super(aSCII_CharStream);
        }

        protected void insertRule(term term2, term term3, double d) throws ParseException {
            if (!ET0LTreeGrammarParser.this.nonterminals.contains(term2.topSymbol())) {
                throw new ParseException("Left-hand side `" + term2.topSymbol() + "' not a nonterminal");
            }
            Object[] objectArray = new Object[]{this.mkLHS(term2), this.mkRHS(term3), new Double(d)};
            ET0LTreeGrammarParser.this.rules.addElement(objectArray);
        }

        public term mkLHS(term term2) {
            symbol symbol2 = new variable(1);
            term term3 = new term(symbol2);
            symbol2 = new symbol(ET0LTreeGrammarParser.this.tableName, 1);
            term term4 = new term(symbol2);
            term4.defineSubterm(0, term3);
            term3 = term4;
            symbol2 = new symbol(term2.topSymbol().toString(), 1);
            term4 = new term(symbol2);
            term4.defineSubterm(0, term3);
            return term4;
        }

        public term mkRHS(term term2) throws ParseException {
            symbol symbol2 = term2.topSymbol();
            if (ET0LTreeGrammarParser.this.nonterminals.contains(symbol2)) {
                term2.relabel(new symbol(symbol2.toString(), 1));
                term2.defineSubterm(0, new term(new variable(1)));
            } else if (ET0LTreeGrammarParser.this.sig.contains(symbol2)) {
                for (int i = 0; i < symbol2.rank(); ++i) {
                    this.mkRHS(term2.subterm(i));
                }
            } else {
                if (symbol2.rank() > 0) {
                    throw new ParseException("signature contains no symbol " + symbol2 + " of rank " + symbol2.rank());
                }
                throw new ParseException("symbol " + symbol2 + " of rank zero neither in signature nor among the nonterminals");
            }
            return term2;
        }
    }
}

