/*
 * Decompiled with CFR 0.152.
 */
package applications.lineDrawings;

import algebras.algebra;
import applications.lineDrawings.line;
import applications.lineDrawings.lineDrawing;
import applications.lineDrawings.lineDrawingAlgebra;
import displays.PSDisplay;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Enumeration;

public class lineDrawingDisplay
extends PSDisplay {
    private lineDrawing displayed = null;
    private displayCanvas theCanvas = new displayCanvas();
    private static int distance = 20;

    public lineDrawingDisplay() {
        this.theCanvas.setSize(500, 500);
    }

    public boolean acceptable(algebra algebra2) {
        return algebra2 instanceof lineDrawingAlgebra;
    }

    protected void displayObject(Object object) {
        this.displayed = object instanceof lineDrawing ? (lineDrawing)object : null;
        this.theCanvas.invalidate();
        this.theCanvas.repaint();
    }

    protected final boolean PSOutputPossible() {
        return super.PSOutputPossible() && this.displayed != null;
    }

    protected void PSOutput() {
        this.PSDraw(this.displayed);
        double[] dArray = this.computeBounds();
        this.PSPreamble(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    private void PSDraw(lineDrawing lineDrawing2) {
        Enumeration enumeration2 = lineDrawing2.elements(lineDrawing.returnAsIs, lineDrawing.flatten);
        while (enumeration2.hasMoreElements()) {
            Object object;
            Object e = enumeration2.nextElement();
            if (e instanceof line) {
                object = (line)e;
                if (((line)object).hidden) continue;
                double d = Math.min(((line)object).x1, ((line)object).x2);
                double d2 = Math.min(((line)object).y1, ((line)object).y2);
                double d3 = Math.max(((line)object).x1, ((line)object).x2);
                double d4 = Math.max(((line)object).y1, ((line)object).y2);
                this.PSSetColour(0.0, 0.0, 0.0);
                this.PSSetbbox(d, d2, d3, d4);
                this.PSMoveto(((line)object).x1, ((line)object).y1);
                this.PSNextPointOfPath(((line)object).x2, ((line)object).y2);
                this.PSStrokePath();
                continue;
            }
            object = (lineDrawing)e;
            this.PSDraw((lineDrawing)object);
            Color color = (Color)((lineDrawing)object).specialInfo;
            this.PSSetColour((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
            Enumeration enumeration3 = ((lineDrawing)object).elements(lineDrawing.flatten, lineDrawing.skip);
            if (!enumeration3.hasMoreElements()) continue;
            this.PSStartLongPath();
            line line2 = (line)enumeration3.nextElement();
            this.PSMoveto(line2.x1, line2.y1);
            while (enumeration3.hasMoreElements()) {
                line2 = (line)enumeration3.nextElement();
                this.PSNextPointOfPath(line2.x1, line2.y1);
            }
            this.PSNextPointOfPath(line2.x2, line2.y2);
            this.PSWrite("eofill\n");
        }
    }

    private double[] computeBounds() {
        double[] dArray = this.computeBranchBounds(this.displayed);
        if (dArray[0] == Double.POSITIVE_INFINITY) {
            dArray[3] = 0.0;
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
        }
        return dArray;
    }

    private double[] computeBranchBounds(lineDrawing lineDrawing2) {
        Enumeration enumeration2 = lineDrawing2.elements(lineDrawing.returnAsIs, lineDrawing.flatten);
        double[] dArray = new double[4];
        dArray[1] = Double.POSITIVE_INFINITY;
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray[3] = Double.NEGATIVE_INFINITY;
        dArray[2] = Double.NEGATIVE_INFINITY;
        while (enumeration2.hasMoreElements()) {
            Object object;
            Object e = enumeration2.nextElement();
            if (e instanceof line) {
                object = (line)e;
                if (((line)object).hidden) continue;
                if (((line)object).x1 < ((line)object).x2) {
                    dArray[0] = Math.min(dArray[0], ((line)object).x1);
                    dArray[2] = Math.max(dArray[2], ((line)object).x2);
                } else {
                    dArray[0] = Math.min(dArray[0], ((line)object).x2);
                    dArray[2] = Math.max(dArray[2], ((line)object).x1);
                }
                if (((line)object).y1 < ((line)object).y2) {
                    dArray[1] = Math.min(dArray[1], ((line)object).y1);
                    dArray[3] = Math.max(dArray[3], ((line)object).y2);
                    continue;
                }
                dArray[1] = Math.min(dArray[1], ((line)object).y2);
                dArray[3] = Math.max(dArray[3], ((line)object).y1);
                continue;
            }
            object = this.computePolygonBounds((lineDrawing)e);
            dArray[0] = Math.min(dArray[0], (double)object[0]);
            dArray[1] = Math.min(dArray[1], (double)object[1]);
            dArray[2] = Math.max(dArray[2], (double)object[2]);
            dArray[3] = Math.max(dArray[3], (double)object[3]);
        }
        return dArray;
    }

    private double[] computePolygonBounds(lineDrawing lineDrawing2) {
        Enumeration enumeration2 = lineDrawing2.elements(lineDrawing.flatten, lineDrawing.returnAsIs);
        double[] dArray = new double[4];
        dArray[1] = Double.POSITIVE_INFINITY;
        dArray[0] = Double.POSITIVE_INFINITY;
        dArray[3] = Double.NEGATIVE_INFINITY;
        dArray[2] = Double.NEGATIVE_INFINITY;
        while (enumeration2.hasMoreElements()) {
            Object object;
            Object e = enumeration2.nextElement();
            if (e instanceof line) {
                object = (line)e;
                if (((line)object).x1 < ((line)object).x2) {
                    dArray[0] = Math.min(dArray[0], ((line)object).x1);
                    dArray[2] = Math.max(dArray[2], ((line)object).x2);
                } else {
                    dArray[0] = Math.min(dArray[0], ((line)object).x2);
                    dArray[2] = Math.max(dArray[2], ((line)object).x1);
                }
                if (((line)object).y1 < ((line)object).y2) {
                    dArray[1] = Math.min(dArray[1], ((line)object).y1);
                    dArray[3] = Math.max(dArray[3], ((line)object).y2);
                    continue;
                }
                dArray[1] = Math.min(dArray[1], ((line)object).y2);
                dArray[3] = Math.max(dArray[3], ((line)object).y1);
                continue;
            }
            object = this.computeBranchBounds((lineDrawing)e);
            dArray[0] = Math.min(dArray[0], (double)object[0]);
            dArray[1] = Math.min(dArray[1], (double)object[1]);
            dArray[2] = Math.max(dArray[2], (double)object[2]);
            dArray[3] = Math.max(dArray[3], (double)object[3]);
        }
        return dArray;
    }

    public Component visualizer() {
        return this.theCanvas;
    }

    private class displayCanvas
    extends Canvas {
        private static final long serialVersionUID = -8661511216981700468L;
        double winCentreX;
        double winCentreY;
        double xCentre;
        double yCentre;
        double unit;

        private displayCanvas() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.black);
            int n = 3;
            Cursor cursor = Cursor.getPredefinedCursor(n);
            lineDrawingDisplay.this.theCanvas.setCursor(cursor);
            if (lineDrawingDisplay.this.displayed != null) {
                double[] dArray = lineDrawingDisplay.this.computeBounds();
                double d = dArray[0];
                double d2 = dArray[1];
                double d3 = dArray[2];
                double d4 = dArray[3];
                Rectangle rectangle = this.getBounds();
                rectangle.width -= 2 * rectangle.x;
                rectangle.height -= 2 * rectangle.y;
                this.winCentreX = rectangle.x + rectangle.width / 2;
                this.winCentreY = rectangle.y + rectangle.height / 2;
                double d5 = rectangle.width - 2 * distance;
                double d6 = rectangle.height - 2 * distance;
                this.unit = d3 == d ? (d4 == d2 ? 1.0 : d6 / (d4 - d2)) : (d4 == d2 ? d5 / (d3 - d) : Math.min(d5 / (d3 - d), d6 / (d4 - d2)));
                this.xCentre = d + (d3 - d) / 2.0;
                this.yCentre = d2 + (d4 - d2) / 2.0;
                this.paint(graphics, lineDrawingDisplay.this.displayed);
            }
            int n2 = 0;
            Cursor cursor2 = Cursor.getPredefinedCursor(n2);
            lineDrawingDisplay.this.theCanvas.setCursor(cursor2);
        }

        public void paint(Graphics graphics, lineDrawing lineDrawing2) {
            Enumeration enumeration2 = lineDrawing2.elements(lineDrawing.returnAsIs, lineDrawing.flatten);
            while (enumeration2.hasMoreElements()) {
                Object object;
                Object e = enumeration2.nextElement();
                if (e instanceof line) {
                    object = (line)e;
                    if (((line)object).hidden) continue;
                    graphics.drawLine((int)Math.round(this.winCentreX + (((line)object).x1 - this.xCentre) * this.unit), (int)Math.round(this.winCentreY - (((line)object).y1 - this.yCentre) * this.unit), (int)Math.round(this.winCentreX + (((line)object).x2 - this.xCentre) * this.unit), (int)Math.round(this.winCentreY - (((line)object).y2 - this.yCentre) * this.unit));
                    continue;
                }
                object = new Polygon();
                Enumeration enumeration3 = ((lineDrawing)e).elements(lineDrawing.flatten, lineDrawing.skip);
                line line2 = null;
                while (enumeration3.hasMoreElements()) {
                    line2 = (line)enumeration3.nextElement();
                    ((Polygon)object).addPoint((int)Math.round(this.winCentreX + (line2.x1 - this.xCentre) * this.unit), (int)Math.round(this.winCentreY - (line2.y1 - this.yCentre) * this.unit));
                }
                if (line2 != null) {
                    ((Polygon)object).addPoint((int)Math.round(this.winCentreX + (line2.x2 - this.xCentre) * this.unit), (int)Math.round(this.winCentreY - (line2.y2 - this.yCentre) * this.unit));
                }
                graphics.setColor((Color)((lineDrawing)e).specialInfo);
                graphics.fillPolygon((Polygon)object);
                graphics.setColor(Color.black);
                this.paint(graphics, (lineDrawing)e);
            }
        }
    }
}

