/*
 * Decompiled with CFR 0.152.
 */
package displays;

import displays.display;
import gui.scrollCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Hashtable;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.setParser;
import parsers.treeDisplayParser;
import terms.symbol;
import terms.term;
import util.list;

public class treeDisplay
extends display {
    private static int horizontalPixels = 500;
    private static int verticalPixels = 500;
    private static int inset = 20;
    private int distanceX;
    private int distanceY;
    private int initialFontSize;
    private int fontSize;
    private static int fontStyle = 1;
    private Hashtable colours;
    private term inputTerm;
    private layoutTerm displayed;
    private displayCanvas theCanvas;
    private FontMetrics metrics;
    private static String noTree = "missing or undefined input";
    private static Font noTreeFont = new Font("Monospaced", fontStyle, 14);
    private static String larger = "larger";
    private static String smaller = "smaller";
    private static String smallest = "smallest";
    private static String reset = "reset view";
    private static String[] fontCommands = new String[]{larger, smaller, smallest};
    private static String[] otherCommands = new String[]{reset};

    public treeDisplay() {
        this.fontSize = this.initialFontSize = 14;
        this.colours = new Hashtable(10);
        this.inputTerm = null;
        this.displayed = null;
        this.theCanvas = new displayCanvas();
        this.theCanvas.setSize(horizontalPixels, verticalPixels);
        this.theCanvas.setView(-horizontalPixels / 2, horizontalPixels / 2, 0.0, verticalPixels);
        this.initFont();
    }

    private void initFont() {
        Font font = new Font("Serif", fontStyle, this.fontSize);
        this.theCanvas.setFont(font);
        this.theCanvas.enableScaling(false);
        this.metrics = this.theCanvas.getFontMetrics(font);
        this.distanceX = this.fontSize;
        this.distanceY = 2 * this.fontSize;
    }

    public void setColour(symbol symbol2, Color color) {
        this.colours.put(symbol2, color);
    }

    protected void displayObject(Object object) {
        if (object != null && object instanceof term) {
            this.inputTerm = (term)object;
            this.displayed = new layoutTerm(this.inputTerm);
        } else {
            this.displayed = null;
            this.inputTerm = null;
        }
        this.setAbs();
        this.theCanvas.invalidate();
        this.theCanvas.repaint();
    }

    private void setAbs() {
        if (this.displayed != null) {
            int n = Math.max(this.displayed.width + 2 * inset, this.theCanvas.getSize().width) / 2;
            int n2 = this.displayed.height * (this.distanceY + this.metrics.getMaxAscent()) + 2 * inset + this.metrics.getMaxAscent();
            this.theCanvas.setAbs(-n, n, 0.0, Math.max(n2, this.theCanvas.getSize().height));
        } else {
            this.theCanvas.setAbs(0.0, 1.0, 0.0, 1.0);
        }
    }

    public Component visualizer() {
        return this.theCanvas;
    }

    public list commands() {
        list list2 = new list();
        list2.append(fontCommands);
        list2.append(otherCommands);
        return list2;
    }

    public void execute(String string) {
        if (reset.equals(string)) {
            this.fontSize = this.initialFontSize;
            this.theCanvas.setView(-horizontalPixels / 2, horizontalPixels / 2, 0.0, verticalPixels);
        } else if (larger.equals(string)) {
            ++this.fontSize;
        } else if (smaller.equals(string) && this.fontSize > 1) {
            --this.fontSize;
        } else if (smallest.equals(string)) {
            this.fontSize = 1;
        }
        this.initFont();
        if (this.inputTerm != null) {
            this.displayed = new layoutTerm(this.inputTerm);
        }
        this.setAbs();
        this.theCanvas.invalidate();
        this.theCanvas.repaint();
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        setParser setParser2 = new setParser(aSCII_CharStream);
        setParser2.set(new treeDisplayParser(aSCII_CharStream, this));
    }

    private class displayCanvas
    extends scrollCanvas {
        private static final long serialVersionUID = -1303828560222021564L;

        private displayCanvas() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (treeDisplay.this.displayed != null) {
                graphics.setColor(Color.black);
                graphics.translate((this.getSize().width - (int)(this.viewL + this.viewR)) / 2, -((int)this.viewT));
                this.paint(treeDisplay.this.displayed, 0, inset + treeDisplay.this.metrics.getMaxAscent(), graphics);
            } else {
                this.paintNoTree(graphics);
            }
        }

        private void paint(layoutTerm layoutTerm2, int n, int n2, Graphics graphics) {
            symbol symbol2 = layoutTerm2.topSymbol();
            String string = symbol2.toString();
            Object v = treeDisplay.this.colours.get(symbol2);
            if (v != null) {
                graphics.setColor((Color)v);
            }
            graphics.drawString(symbol2.toString(), n - treeDisplay.this.metrics.stringWidth(string) / 2, n2);
            if (v != null) {
                graphics.setColor(Color.black);
            }
            int n3 = n - layoutTerm2.subWidth / 2;
            int n4 = n2 + treeDisplay.this.distanceY + treeDisplay.this.metrics.getMaxAscent();
            for (int i = 0; i < symbol2.rank(); ++i) {
                layoutTerm layoutTerm3 = (layoutTerm)layoutTerm2.subterm(i);
                int n5 = n3 + layoutTerm3.width / 2;
                int n6 = n2 + treeDisplay.this.metrics.getMaxDescent();
                int n7 = n4 - treeDisplay.this.metrics.getMaxAscent();
                graphics.drawLine(n, n6, n5, n7);
                this.paint(layoutTerm3, n5, n4, graphics);
                n3 = n3 + layoutTerm3.width + treeDisplay.this.distanceX;
            }
        }

        private void paintNoTree(Graphics graphics) {
            graphics.setColor(Color.red);
            graphics.translate(this.getSize().width / 2, this.getSize().height / 2);
            graphics.setFont(noTreeFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(noTreeFont);
            int n = fontMetrics.stringWidth(noTree);
            int n2 = fontMetrics.getMaxAscent();
            graphics.drawString(noTree, -n / 2, n2 / 2);
            int n3 = fontMetrics.getMaxAdvance();
            graphics.drawRect(-(n + n3) / 2, -n2, n + n3, 2 * n2);
        }

        protected void resizeView() {
            double d = (double)this.getSize().width - (this.viewR - this.viewL);
            double d2 = (double)this.getSize().height - (this.viewB - this.viewT);
            this.setView(this.viewL - d / 2.0, this.viewR + d / 2.0, this.viewT, this.viewB + d2);
        }
    }

    private class layoutTerm
    extends term {
        public int width;
        public int subWidth;
        public int height;

        public layoutTerm(term term2) {
            super(term2.topSymbol());
            int n = this.topSymbol().rank();
            this.subWidth = n > 0 ? (n - 1) * treeDisplay.this.distanceX : 0;
            this.height = 0;
            for (int i = 0; i < n; ++i) {
                layoutTerm layoutTerm2 = new layoutTerm(term2.subterm(i));
                this.defineSubterm(i, layoutTerm2);
                this.subWidth += layoutTerm2.width;
                this.height = Math.max(this.height, layoutTerm2.height + 1);
            }
            this.width = Math.max(this.subWidth, treeDisplay.this.metrics.stringWidth(this.topSymbol().toString()));
        }
    }
}

