/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.SyncedRule;
import java.util.Enumeration;
import java.util.Vector;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.synchronizedSymbol;
import terms.term;

public class SuperTable {
    private Vector subTables = new Vector();
    private Vector rules = new Vector();
    private boolean containsSubTables = false;
    private boolean containsRules = false;
    private double weight = 1.0;
    private String name;

    public SuperTable() {
        this(false);
    }

    public SuperTable(boolean bl) {
    }

    public boolean isTerminable(finiteSignature finiteSignature2, finiteSignature finiteSignature3) {
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                if (!superTable.isTerminable(finiteSignature2, finiteSignature3)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.getNumRules(); ++i) {
                term term2 = this.getRule(i).getRhs();
                if (!this.isTerminal(term2, finiteSignature2, finiteSignature3)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isTerminal(term term2, finiteSignature finiteSignature2, finiteSignature finiteSignature3) {
        symbol symbol2 = term2.topSymbol();
        if (finiteSignature3.contains(symbol2)) {
            return false;
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (this.isTerminal(term2.subterm(i), finiteSignature2, finiteSignature3)) continue;
            return false;
        }
        return true;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    public int getNumTables() {
        return this.subTables.size();
    }

    public SuperTable getSubTable(int n) {
        return (SuperTable)this.subTables.elementAt(n);
    }

    public int getNumRules() {
        return this.rules.size();
    }

    public SyncedRule getRule(int n) {
        return (SyncedRule)this.rules.elementAt(n);
    }

    public void addSubTable(SuperTable superTable) {
        if (this.containsRules) {
            throw new RuntimeException("Errnous usage of SuperTable.java. \nCurrently no support for having subtables and rules in same table.\n");
        }
        this.subTables.addElement(superTable);
        this.containsSubTables = true;
    }

    public void removeSubTable(SuperTable superTable) {
        this.subTables.remove(superTable);
    }

    public void addRule(SyncedRule syncedRule) {
        if (this.containsSubTables) {
            throw new RuntimeException("Errnous usage of SuperTable.java. \nCurrently no support for having subtables and rules in same table.\n");
        }
        this.rules.addElement(syncedRule);
        this.containsRules = true;
    }

    public Vector getTablesAtDepth(int n) {
        Vector<SuperTable> vector = new Vector<SuperTable>();
        if (n == 0) {
            vector.addElement(this);
        } else {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                Vector vector2 = superTable.getTablesAtDepth(n - 1);
                vector.addAll(vector2);
            }
        }
        return vector;
    }

    public void addImplicitRules(fixedRankSignature fixedRankSignature2, int n) {
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                superTable.addImplicitRules(fixedRankSignature2, n);
            }
        } else {
            Vector<symbol> vector = new Vector<symbol>();
            Enumeration enumeration2 = fixedRankSignature2.elements();
            block1: while (enumeration2.hasMoreElements()) {
                symbol symbol2 = (symbol)enumeration2.nextElement();
                for (int i = 0; i < this.getNumRules(); ++i) {
                    if (symbol2.equals(this.getRule(i).getLhs())) continue block1;
                }
                vector.addElement(symbol2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                symbol symbol3 = (symbol)vector.elementAt(i);
                synchronizedSymbol synchronizedSymbol2 = new synchronizedSymbol(symbol3.toString(), n);
                for (int j = 0; j < n; ++j) {
                    synchronizedSymbol2.setSync(j, 0);
                }
                SyncedRule syncedRule = new SyncedRule(symbol3, new term(synchronizedSymbol2));
                this.addRule(syncedRule);
            }
        }
    }

    public Vector getUsedSyncBranchNumbers(int n) {
        Vector vector = new Vector();
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                Vector vector2 = superTable.getUsedSyncBranchNumbers(n);
                vector.addAll(vector2);
            }
        } else {
            for (int i = 0; i < this.rules.size(); ++i) {
                SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(i);
                Vector vector3 = syncedRule.getUsedSyncBranchNumbers(n);
                vector.addAll(vector3);
            }
        }
        return vector;
    }

    public Vector getUsedSyncBranchNumbersForSyncLevel(int n, int n2) {
        Vector vector = new Vector();
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                Vector vector2 = superTable.getUsedSyncBranchNumbersForSyncLevel(n, n2);
                vector.addAll(vector2);
            }
        } else {
            for (int i = 0; i < this.rules.size(); ++i) {
                SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(i);
                Vector vector3 = syncedRule.getUsedSyncBranchNumbersForSyncLevel(n, n2);
                vector.addAll(vector3);
            }
        }
        return vector;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String string) {
        String string2 = string + this.name;
        string2 = string2 + " {\n";
        int n = 0;
        while (n < this.rules.size()) {
            SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(n);
            string2 = string2 + string + "  " + syncedRule.lhs + " -> " + syncedRule.rhs + " weight " + syncedRule.weight;
            Vector vector = syncedRule.getSyncStrings();
            if (vector.size() > 0) {
                string2 = string2 + " sync ";
                int n2 = 0;
                while (n2 < vector.size()) {
                    int[] nArray = (int[])vector.elementAt(n2);
                    string2 = string2 + "<";
                    int n3 = 0;
                    while (n3 < nArray.length) {
                        string2 = string2 + nArray[n3++];
                        if (n3 >= nArray.length) continue;
                        string2 = string2 + " ";
                    }
                    string2 = string2 + ">";
                    if (++n2 >= vector.size()) continue;
                    string2 = string2 + " ";
                }
            }
            if (++n >= this.rules.size()) continue;
            string2 = string2 + ",\n";
        }
        n = 0;
        while (n < this.subTables.size()) {
            string2 = string2 + ((SuperTable)this.subTables.elementAt(n)).toString(string + "  ");
            if (++n >= this.subTables.size()) continue;
            string2 = string2 + ",\n";
        }
        string2 = string2 + "\n" + string + "} weight " + this.weight;
        return string2;
    }

    public fixedRankSignature nonterminalslnRhsThatUseGivenSyncNumber(finiteSignature finiteSignature2, int n, int n2, int n3) {
        fixedRankSignature fixedRankSignature2 = new fixedRankSignature(0);
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                fixedRankSignature fixedRankSignature3 = superTable.nonterminalslnRhsThatUseGivenSyncNumber(finiteSignature2, n, n2, n3);
                fixedRankSignature2.unionWith(fixedRankSignature3);
            }
        } else {
            for (int i = 0; i < this.rules.size(); ++i) {
                SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(i);
                term term2 = syncedRule.getRhs();
                if (finiteSignature2 != null && !finiteSignature2.contains(syncedRule.getLhs())) continue;
                fixedRankSignature fixedRankSignature4 = syncedRule.nonterminalsThatUseGivenSyncNumber(term2, n, n2, n3);
                fixedRankSignature2.unionWith(fixedRankSignature4);
            }
        }
        return fixedRankSignature2;
    }

    public void increaseLengthOfSyncSymbolTuplesWithOne(int n) {
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                superTable.increaseLengthOfSyncSymbolTuplesWithOne(n);
            }
        } else {
            for (int i = 0; i < this.rules.size(); ++i) {
                SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(i);
                syncedRule.increaseLengthOfSyncSymbolTuplesWithOne(n);
            }
        }
    }

    public void relabelSymbol(symbol symbol2, symbol symbol3) {
        if (this.containsSubTables) {
            for (int i = 0; i < this.subTables.size(); ++i) {
                SuperTable superTable = (SuperTable)this.subTables.elementAt(i);
                superTable.relabelSymbol(symbol2, symbol3);
            }
        } else {
            for (int i = 0; i < this.rules.size(); ++i) {
                SyncedRule syncedRule = (SyncedRule)this.rules.elementAt(i);
                syncedRule.relabelSymbol(symbol2, symbol3);
            }
        }
    }
}

