/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.treeTransducer;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Random;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.mtTransducerParser;
import terms.extendedTerm;
import terms.finiteSignature;
import terms.parameter;
import terms.symbol;
import terms.term;
import terms.variable;
import util.list;

public class mtTransducer
extends treeTransducer {
    private boolean io = true;
    private static String ioText = "switch to IO";
    private static String oiText = "switch to OI";
    private static String nextStep = "single step";
    private static String parallelStep = "parallel step";
    private static String back = "back";
    private static String singleSteps = "derive stepwise";
    private static String completeRuns = "results only";
    private static String newSeedText = "new random seed";
    private static String safeText = "make safe derivations";
    private static String unSafeText = "make blind derivations";
    private boolean safeMode = true;
    protected boolean performance = false;
    private finiteSignature states;
    private finiteSignature inputSignature;
    private symbol initialState;
    private term[][] rule;
    private double[] weight;
    private extendedTerm currTerm = null;
    private extendedTerm lastArgument = null;
    private Random randGen = new Random();
    protected boolean deterministic = false;
    private mtComputationTree ioDerivation = null;
    private mtComputationTree ioBlindDerivation = null;
    private mtComputationTree oiDerivation = null;
    private mtComputationTree oiBlindDerivation = null;
    private mtComputationTree currCompTree = null;
    public static int stateSize = 0;

    public list commands() {
        String[] stringArray;
        list list2 = new list();
        boolean bl = false;
        if (this.currCompTree != null && !this.performance) {
            bl = this.currCompTree.getStepwise();
        }
        if (bl && !this.performance) {
            stringArray = new String[]{nextStep, parallelStep, back};
            list2.append(stringArray);
        }
        if (!this.deterministic) {
            stringArray = new String[]{this.safeMode ? unSafeText : safeText, newSeedText};
            list2.append(stringArray);
        }
        if (this.performance) {
            stringArray = new String[1];
        } else {
            stringArray = new String[2];
            String string = stringArray[0] = bl ? completeRuns : singleSteps;
        }
        stringArray[this.performance ? 0 : 1] = this.io ? oiText : ioText;
        list2.append(stringArray);
        return list2;
    }

    public void execute(String string) {
        if (this.lastArgument == null) {
            return;
        }
        if (string.equals(ioText)) {
            this.io = true;
            if (this.ioDerivation == null && this.safeMode) {
                this.ioDerivation = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), true, this);
            } else if (this.ioBlindDerivation == null && !this.safeMode) {
                this.ioBlindDerivation = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), false, this);
            }
            this.currCompTree = this.safeMode ? this.ioDerivation : this.ioBlindDerivation;
        }
        if (string.equals(oiText)) {
            this.io = false;
            if (this.oiDerivation == null && this.safeMode) {
                this.oiDerivation = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), true, this);
            } else if (this.oiBlindDerivation == null && !this.safeMode) {
                this.oiBlindDerivation = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), false, this);
            }
            this.currCompTree = this.safeMode ? this.oiDerivation : this.oiBlindDerivation;
        } else if (string.equals(completeRuns)) {
            this.currCompTree.setResultsOnly();
        } else if (string.equals(singleSteps)) {
            this.currCompTree.setStepwise();
        } else if (string.equals(nextStep)) {
            this.currCompTree.singleStep();
        } else if (string.equals(parallelStep)) {
            this.currCompTree.parallelStep();
        } else if (string.equals(back)) {
            this.currCompTree.back();
        } else if (string.equals(newSeedText)) {
            this.newSeed();
        } else if (string.equals(safeText)) {
            this.safeMode = true;
            if (this.io) {
                this.execute(ioText);
            } else {
                this.execute(oiText);
            }
        } else if (string.equals(unSafeText)) {
            this.safeMode = false;
            if (this.io) {
                this.execute(ioText);
            } else {
                this.execute(oiText);
            }
        }
    }

    public term apply(term term2) {
        this.ioDerivation = null;
        this.ioBlindDerivation = null;
        this.oiDerivation = null;
        this.oiBlindDerivation = null;
        this.lastArgument = new extendedTerm(term2);
        this.currCompTree = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), this.safeMode, this);
        this.currTerm = this.currCompTree.getOutput();
        if (this.io && this.safeMode) {
            this.ioDerivation = this.currCompTree;
        } else if (this.io) {
            this.ioBlindDerivation = this.currCompTree;
        } else if (this.safeMode) {
            this.oiDerivation = this.currCompTree;
        } else {
            this.oiBlindDerivation = this.currCompTree;
        }
        return this.currTerm;
    }

    public void newSeed() {
        this.currCompTree = new mtComputationTree(this.lastArgument, this.io, this.states, this.rule, this.weight, this.initialState, this.randGen.nextLong(), this.safeMode, this);
        if (this.io) {
            this.ioDerivation = this.currCompTree;
        } else {
            this.oiDerivation = this.currCompTree;
        }
    }

    public term currentTerm() {
        if (this.currCompTree != null) {
            return this.currCompTree.getOutput();
        }
        return null;
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        mtTransducerParser mtTransducerParser2 = new mtTransducerParser(aSCII_CharStream);
        mtTransducerParser2.mtTransducer();
        this.states = mtTransducerParser2.states;
        if (stateSize < this.states.size()) {
            stateSize = this.states.size();
        }
        this.inputSignature = mtTransducerParser2.in;
        this.rule = mtTransducerParser2.rule;
        this.weight = mtTransducerParser2.weight;
        this.initialState = mtTransducerParser2.initial;
        this.deterministic = this.checkDeterminism();
        this.performance = mtTransducerParser2.performance;
        if (this.deterministic) {
            this.safeMode = false;
        } else if (this.checkTotality()) {
            this.safeMode = false;
        }
    }

    public boolean checkDeterminism() {
        for (int i = 0; i < this.rule.length; ++i) {
            for (int j = i + 1; j < this.rule.length; ++j) {
                symbol symbol2 = this.rule[i][0].topSymbol();
                symbol symbol3 = this.rule[j][0].topSymbol();
                symbol symbol4 = this.rule[i][0].subterm(0).topSymbol();
                symbol symbol5 = this.rule[j][0].subterm(0).topSymbol();
                if (!symbol2.equals(symbol3) || !symbol4.equals(symbol5)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkTotality() {
        int n;
        BitSet[] bitSetArray = new BitSet[this.states.size()];
        for (n = 0; n < this.states.size(); ++n) {
            bitSetArray[n] = new BitSet();
        }
        for (n = 0; n < this.rule.length; ++n) {
            symbol symbol2 = this.rule[n][0].topSymbol();
            symbol symbol3 = this.rule[n][0].subterm(0).topSymbol();
            int n2 = this.states.indexOf(symbol2);
            int n3 = this.inputSignature.indexOf(symbol3);
            bitSetArray[n2].set(n3);
        }
        for (n = 0; n < this.states.size(); ++n) {
            for (int i = 0; i < this.inputSignature.size(); ++i) {
                if (bitSetArray[n].get(i)) continue;
                return false;
            }
        }
        return true;
    }

    public void allowExit() {
        super.allowExit();
    }

    private class mtComputationTree {
        private extendedTerm input = null;
        private finiteSignature states = null;
        private term[][] rule = null;
        private double[] weight = null;
        private symbol initialState = null;
        private boolean io = false;
        private boolean stepwise = false;
        private Random randGen = null;
        private boolean safeMode = true;
        private boolean unSafeAndError = false;
        private mtTransducer exitRef = null;
        private boolean performance = false;
        private boolean deterministic = false;
        private int RUNS_BEFORE_ALLOWEXIT = 20;
        private boolean singleStepPerformed;
        private boolean singleStepMode;
        int goExit = 0;

        public mtComputationTree(extendedTerm extendedTerm2, boolean bl, finiteSignature finiteSignature2, term[][] termArray, double[] dArray, symbol symbol2, long l, boolean bl2, mtTransducer mtTransducer3) {
            this.initialState = symbol2;
            this.input = new extendedTerm(extendedTerm2);
            this.io = bl;
            this.states = finiteSignature2;
            this.rule = termArray;
            this.weight = dArray;
            if (!this.deterministic) {
                this.randGen = new Random(l);
            }
            this.safeMode = bl2;
            this.exitRef = mtTransducer3;
            this.performance = mtTransducer3.performance;
            this.deterministic = mtTransducer3.deterministic;
            if (bl2) {
                if (bl) {
                    this.calcIOGamma(this.input);
                } else {
                    this.calcOIGamma(this.input);
                }
            }
            this.input = this.addInitialState(this.input);
            try {
                this.input = this.run(this.input);
            }
            catch (UnsolvableStateException unsolvableStateException) {
                if (bl2) {
                    this.input = null;
                }
                this.unSafeAndError = true;
            }
        }

        public extendedTerm getOutput() {
            if (this.unSafeAndError && !this.stepwise) {
                return null;
            }
            if (this.input != null) {
                if (this.performance) {
                    return this.input;
                }
                return this.getOutput(this.input);
            }
            return null;
        }

        private extendedTerm getOutput(extendedTerm extendedTerm2) {
            extendedTerm extendedTerm3 = extendedTerm2.getResult();
            if (!(extendedTerm3 == null || extendedTerm2.getCounter() <= -1 && this.stepwise)) {
                return this.getOutput(extendedTerm3);
            }
            if (extendedTerm2.topSymbol().rank() == 0) {
                return new extendedTerm(extendedTerm2.topSymbol());
            }
            extendedTerm3 = new extendedTerm(extendedTerm2.topSymbol());
            for (int i = 0; i < extendedTerm3.topSymbol().rank(); ++i) {
                extendedTerm3.defineSubterm(i, this.getOutput((extendedTerm)extendedTerm2.subterm(i)));
            }
            return extendedTerm3;
        }

        public void setStepwise() {
            this.stepwise = true;
        }

        public boolean getStepwise() {
            return this.stepwise;
        }

        public void setResultsOnly() {
            this.stepwise = false;
        }

        public void parallelStep() {
            this.singleStepMode = false;
            this.step(this.input);
        }

        public void singleStep() {
            this.singleStepMode = true;
            this.singleStepPerformed = false;
            this.step(this.input);
        }

        private boolean step(extendedTerm extendedTerm2) {
            if (extendedTerm2 == null) {
                return false;
            }
            if (this.io) {
                if (extendedTerm2.getResult() != null && extendedTerm2.getCounter() >= 0) {
                    extendedTerm2.increaseCounter();
                    return this.step(extendedTerm2.getResult());
                }
                boolean bl = false;
                for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                    if (!this.step((extendedTerm)extendedTerm2.subterm(i))) continue;
                    bl = true;
                }
                if (this.singleStepPerformed && this.singleStepMode) {
                    return true;
                }
                extendedTerm extendedTerm3 = extendedTerm2.getResult();
                if (extendedTerm3 != null && !bl) {
                    extendedTerm2.increaseCounter();
                    if (extendedTerm2.getCounter() == 0) {
                        this.singleStepPerformed = true;
                        return true;
                    }
                    return false;
                }
                return bl;
            }
            if (this.singleStepPerformed && this.singleStepMode) {
                return false;
            }
            extendedTerm extendedTerm4 = extendedTerm2.getResult();
            if (extendedTerm4 != null) {
                extendedTerm2.increaseCounter();
                if (extendedTerm2.getCounter() == 0) {
                    this.singleStepPerformed = true;
                    return false;
                }
                this.step(extendedTerm4);
                return false;
            }
            for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                this.step((extendedTerm)extendedTerm2.subterm(i));
            }
            return false;
        }

        public void back() {
            if (this.input != null) {
                this.back(this.input);
            }
        }

        private void back(extendedTerm extendedTerm2) {
            block6: {
                block4: {
                    block5: {
                        if (!this.io) break block4;
                        if (extendedTerm2.getResult() == null || extendedTerm2.getCounter() < 0) break block5;
                        this.back(extendedTerm2.getResult());
                        extendedTerm2.decreaseCounter();
                        if (extendedTerm2.getCounter() != -1) break block6;
                        this.back(extendedTerm2);
                        break block6;
                    }
                    for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                        this.back((extendedTerm)extendedTerm2.subterm(i));
                    }
                    break block6;
                }
                extendedTerm2.decreaseCounter();
                if (extendedTerm2.getResult() != null) {
                    this.back(extendedTerm2.getResult());
                } else {
                    for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                        this.back((extendedTerm)extendedTerm2.subterm(i));
                    }
                }
            }
        }

        public extendedTerm currentTerm() {
            return null;
        }

        private extendedTerm run(extendedTerm extendedTerm2) throws UnsolvableStateException {
            if (this.goExit++ % this.RUNS_BEFORE_ALLOWEXIT == 0) {
                this.exitRef.allowExit();
            }
            if (this.unSafeAndError) {
                return extendedTerm2;
            }
            if (extendedTerm2.topSymbol().rank() == 0) {
                return extendedTerm2;
            }
            if (this.io) {
                if (!this.performance || !extendedTerm2.bottomMostState()) {
                    for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                        extendedTerm2.defineSubterm(i, this.run((extendedTerm)extendedTerm2.subterm(i)));
                    }
                }
                if (this.states.contains(extendedTerm2.topSymbol()) && !this.unSafeAndError) {
                    extendedTerm extendedTerm3 = this.applyRuleAt(extendedTerm2);
                    extendedTerm3 = this.run(extendedTerm3);
                    if (this.performance) {
                        return extendedTerm3;
                    }
                    extendedTerm2.setResult(extendedTerm3);
                }
                return extendedTerm2;
            }
            if (this.states.contains(extendedTerm2.topSymbol()) && !this.unSafeAndError) {
                extendedTerm extendedTerm4 = this.applyRuleAt(extendedTerm2);
                extendedTerm4 = this.run(extendedTerm4);
                if (this.performance) {
                    return extendedTerm4;
                }
                extendedTerm2.setResult(extendedTerm4);
                return extendedTerm2;
            }
            for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                extendedTerm2.defineSubterm(i, this.run((extendedTerm)extendedTerm2.subterm(i)));
            }
            return extendedTerm2;
        }

        private extendedTerm applyRuleAt(extendedTerm extendedTerm2) throws UnsolvableStateException {
            int n;
            if (!this.performance) {
                extendedTerm2 = extendedTerm2.getCurrentResultTree();
            }
            if (this.safeMode) {
                n = this.chooseRule(extendedTerm2);
            } else {
                try {
                    n = this.chooseRule(extendedTerm2);
                }
                catch (UnsolvableStateException unsolvableStateException) {
                    this.unSafeAndError = true;
                    extendedTerm extendedTerm3 = new extendedTerm(extendedTerm2);
                    String string = extendedTerm3.topSymbol().toString();
                    String string2 = new String("-- ");
                    string2 = string2.concat(string).concat(" --");
                    symbol symbol2 = new symbol(string2, extendedTerm3.topSymbol().rank());
                    extendedTerm3.relabel(symbol2);
                    return extendedTerm3;
                }
            }
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            this.substituteBind(this.rule[n][0], extendedTerm2, hashtable, hashtable2);
            term term2 = this.performance ? this.rule[n][1] : (term)this.rule[n][1].clone();
            extendedTerm extendedTerm4 = new extendedTerm(term2);
            extendedTerm4 = this.substituteReplace(extendedTerm4, hashtable, hashtable2, new BitSet(), new BitSet());
            if (!this.io && this.safeMode) {
                this.calcNewSafeParameters(this.rule[n][1], extendedTerm4);
            }
            return extendedTerm4;
        }

        private void calcNewSafeParameters(term term2, extendedTerm extendedTerm2) {
            if (term2.topSymbol().rank() == 0) {
                return;
            }
            for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                this.calcNewSafeParameters(term2.subterm(i), extendedTerm2.extendedSubterm(i));
            }
            if (this.states.contains(term2.topSymbol())) {
                BitSet bitSet = new BitSet();
                for (int i = 1; i < extendedTerm2.topSymbol().rank(); ++i) {
                    if (!this.OK_OI(extendedTerm2.extendedSubterm(i), null)) continue;
                    bitSet.set(i - 1);
                }
                extendedTerm2.setSafeParameters(bitSet);
            }
        }

        private extendedTerm substituteReplace(extendedTerm extendedTerm2, Hashtable hashtable, Hashtable hashtable2, BitSet bitSet, BitSet bitSet2) {
            symbol symbol2 = extendedTerm2.topSymbol();
            if (symbol2 instanceof variable) {
                int n = ((variable)symbol2).index();
                extendedTerm extendedTerm3 = (extendedTerm)hashtable.get(new Integer(n));
                if (this.performance && !bitSet.get(n)) {
                    bitSet.set(n);
                } else {
                    extendedTerm3 = new extendedTerm(extendedTerm3);
                }
                extendedTerm3.setBottomMostState();
                return extendedTerm3;
            }
            if (symbol2 instanceof parameter) {
                if (hashtable2 == null) {
                    return extendedTerm2;
                }
                int n = ((parameter)symbol2).index();
                extendedTerm extendedTerm4 = (extendedTerm)hashtable2.get(new Integer(n));
                if (this.performance && !bitSet2.get(n)) {
                    bitSet2.set(n);
                } else {
                    extendedTerm4 = new extendedTerm(extendedTerm4);
                }
                return extendedTerm4;
            }
            for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                extendedTerm2.defineSubterm(i, this.substituteReplace((extendedTerm)extendedTerm2.subterm(i), hashtable, hashtable2, bitSet, bitSet2));
            }
            return extendedTerm2;
        }

        private void substituteBind(term term2, extendedTerm extendedTerm2, Hashtable hashtable, Hashtable hashtable2) {
            symbol symbol2 = term2.topSymbol();
            if (symbol2 instanceof variable) {
                int n = ((variable)symbol2).index();
                extendedTerm extendedTerm3 = this.performance ? extendedTerm2 : new extendedTerm(extendedTerm2);
                hashtable.put(new Integer(n), extendedTerm3);
            } else if (symbol2 instanceof parameter) {
                if (hashtable2 == null) {
                    return;
                }
                int n = ((parameter)symbol2).index();
                extendedTerm extendedTerm4 = this.performance ? extendedTerm2 : new extendedTerm(extendedTerm2);
                hashtable2.put(new Integer(n), extendedTerm4);
            } else {
                for (int i = 0; i < symbol2.rank(); ++i) {
                    this.substituteBind(term2.subterm(i), extendedTerm2.extendedSubterm(i), hashtable, hashtable2);
                }
            }
        }

        private int chooseRule(extendedTerm extendedTerm2) throws UnsolvableStateException {
            int n = -1;
            double d = 0.0;
            BitSet bitSet = new BitSet(this.rule.length);
            for (int i = 0; i < this.rule.length; ++i) {
                symbol symbol2;
                symbol symbol3;
                term term2 = this.rule[i][0];
                if (!term2.topSymbol().equals(extendedTerm2.topSymbol()) || this.weight[i] <= 0.0 || !(symbol3 = term2.subterm(0).topSymbol()).equals(symbol2 = extendedTerm2.subterm(0).topSymbol()) || !this.solvableRule(i, extendedTerm2) && this.safeMode) continue;
                if (this.deterministic) {
                    return i;
                }
                bitSet.set(i);
                d += this.weight[i];
                if (n != -1) continue;
                n = i;
            }
            double d2 = this.randGen.nextDouble() * d;
            for (int i = 0; i < this.rule.length; ++i) {
                if (!bitSet.get(i) || !((d2 -= this.weight[i]) <= 0.0)) continue;
                return i;
            }
            throw new UnsolvableStateException();
        }

        private boolean solvableRule(int n, extendedTerm extendedTerm2) {
            if (this.deterministic) {
                return true;
            }
            Hashtable hashtable = new Hashtable();
            term term2 = this.rule[n][0];
            term term3 = this.rule[n][1];
            if (this.io && !term2.topSymbol().equals(extendedTerm2.topSymbol())) {
                this.substituteBind(term2.subterm(0), extendedTerm2, hashtable, null);
            } else {
                this.substituteBind(term2, extendedTerm2, hashtable, null);
            }
            extendedTerm extendedTerm3 = new extendedTerm(term3);
            extendedTerm3 = this.substituteReplace(extendedTerm3, hashtable, null, new BitSet(), new BitSet());
            if (this.io) {
                return this.OK_IO(extendedTerm3);
            }
            boolean bl = this.OK_OI(extendedTerm3, extendedTerm2.getSafeParameters());
            return bl;
        }

        private boolean OK_IO(extendedTerm extendedTerm2) {
            if (!this.states.contains(extendedTerm2.topSymbol())) {
                for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                    if (this.OK_IO(extendedTerm2.extendedSubterm(i))) continue;
                    return false;
                }
                return true;
            }
            if (this.states.contains(extendedTerm2.topSymbol())) {
                symbol symbol2 = extendedTerm2.topSymbol();
                extendedTerm extendedTerm3 = extendedTerm2.extendedSubterm(0);
                if (!extendedTerm3.get(this.states.indexOf(symbol2))) {
                    return false;
                }
                for (int i = 1; i < extendedTerm2.topSymbol().rank(); ++i) {
                    if (this.OK_IO(extendedTerm2.extendedSubterm(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void calcIOGamma(extendedTerm extendedTerm2) {
            if (extendedTerm2.topSymbol().rank() == 0) {
                extendedTerm2.defineSolvableStates(this.findTransformations(extendedTerm2.topSymbol()));
            } else {
                int n;
                for (n = 0; n < extendedTerm2.topSymbol().rank(); ++n) {
                    this.calcIOGamma((extendedTerm)extendedTerm2.subterm(n));
                }
                for (n = 0; n < this.rule.length; ++n) {
                    if (!this.rule[n][0].subterm(0).topSymbol().equals(extendedTerm2.topSymbol()) || !this.solvableRule(n, extendedTerm2)) continue;
                    symbol symbol2 = this.rule[n][0].topSymbol();
                    extendedTerm2.set(this.states.indexOf(symbol2));
                }
            }
        }

        private BitSet findTransformations(symbol symbol2) {
            BitSet bitSet = new BitSet(this.states.maxIndex());
            for (int i = 0; i < this.rule.length; ++i) {
                if (!this.rule[i][0].subterm(0).topSymbol().equals(symbol2)) continue;
                symbol symbol3 = this.rule[i][0].topSymbol();
                bitSet.set(this.states.indexOf(symbol3));
            }
            return bitSet;
        }

        private extendedTerm addInitialState(extendedTerm extendedTerm2) {
            extendedTerm extendedTerm3 = new extendedTerm(this.initialState);
            if (!this.io) {
                BitSet bitSet = new BitSet();
                bitSet.set(0);
                extendedTerm3.setSafeParameters(bitSet);
            }
            extendedTerm3.defineSubterm(0, extendedTerm2);
            return extendedTerm3;
        }

        private boolean OK_OI(extendedTerm extendedTerm2, BitSet bitSet) {
            if (!this.safeMode) {
                return true;
            }
            if (extendedTerm2.topSymbol() instanceof parameter) {
                int n = ((parameter)extendedTerm2.topSymbol()).index();
                return bitSet.get(n - 1);
            }
            if (!this.states.contains(extendedTerm2.topSymbol())) {
                for (int i = 0; i < extendedTerm2.topSymbol().rank(); ++i) {
                    if (this.OK_OI(extendedTerm2.extendedSubterm(i), bitSet)) continue;
                    return false;
                }
                return true;
            }
            symbol symbol2 = extendedTerm2.topSymbol();
            extendedTerm extendedTerm3 = extendedTerm2.extendedSubterm(0);
            int n = this.states.indexOf(symbol2);
            for (int i = 0; i < extendedTerm3.getBSize(n); ++i) {
                boolean bl = true;
                BitSet bitSet2 = extendedTerm3.getB(n, i);
                for (int j = 0; j < symbol2.rank(); ++j) {
                    if (!bitSet2.get(j) || this.OK_OI(extendedTerm2.extendedSubterm(j + 1), bitSet)) continue;
                    bl = false;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }

        private void calcOIGamma(extendedTerm extendedTerm2) {
            int n;
            for (n = 0; n < extendedTerm2.topSymbol().rank(); ++n) {
                this.calcOIGamma(extendedTerm2.extendedSubterm(n));
            }
            for (n = 0; n < this.rule.length; ++n) {
                symbol symbol2 = this.rule[n][0].topSymbol();
                symbol symbol3 = this.rule[n][0].subterm(0).topSymbol();
                if (!symbol3.equals(extendedTerm2.topSymbol())) continue;
                long l = Math.round(Math.pow(2.0, (double)symbol2.rank() - 1.0));
                int n2 = 0;
                while ((long)n2 < l) {
                    BitSet bitSet = new BitSet(symbol2.rank());
                    int n3 = 1;
                    int n4 = 0;
                    while ((long)n3 < l) {
                        if ((n2 & n3) > 0) {
                            bitSet.set(n4);
                        }
                        n3 *= 2;
                        ++n4;
                    }
                    Hashtable hashtable = new Hashtable();
                    term term2 = this.rule[n][0];
                    this.substituteBind(term2.subterm(0), extendedTerm2, hashtable, null);
                    term term3 = (term)this.rule[n][1].clone();
                    extendedTerm extendedTerm3 = new extendedTerm(term3);
                    extendedTerm3 = this.substituteReplace(extendedTerm3, hashtable, null, new BitSet(), new BitSet());
                    if (this.OK_OI(extendedTerm3, bitSet) || l == 1L) {
                        extendedTerm2.addB(this.states.indexOf(symbol2), bitSet);
                    }
                    ++n2;
                }
            }
        }

        private class UnsolvableStateException
        extends Exception {
            private static final long serialVersionUID = 631877830901645571L;

            private UnsolvableStateException() {
            }
        }
    }
}

