/*
 * Decompiled with CFR 0.152.
 */
package generators;

import generators.treeTransducer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.tdTransducerParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.term;
import terms.variable;
import util.list;

public class tdTransducer
extends treeTransducer {
    private static String nextStep = "single step";
    private static String parallelStep = "parallel step";
    private static String back = "back";
    private static String singleSteps = "derive stepwise";
    private static String completeRuns = "results only";
    private static String newSeed = "new random seed";
    private static String variable = "variable random seed";
    private static String fixed = "fixed random seed";
    private boolean stepwise = false;
    protected boolean fixedSeed = true;
    private boolean isDeterministic;
    private boolean isTotal;
    private term[][] rule;
    private double[] weight;
    private symbol[][] rhsQ;
    private int[][] rhsIndex;
    private term[] rhs;
    private fixedRankSignature states;
    private finiteSignature inputSignature;
    private symbol initialState;
    private term lastArgument = null;
    private term currTerm = null;
    private computationTree ct;
    private long randomSeed;
    private Random random = new Random();
    private int decompositionIndex;
    private lookAheadTree lookAhead;
    boolean singleStepPerformed;

    public list commands() {
        String[] stringArray;
        list list2 = new list();
        if (this.stepwise) {
            stringArray = new String[]{nextStep, parallelStep, back};
            list2.append(stringArray);
        }
        if (this.isDeterministic) {
            stringArray = new String[]{this.stepwise ? completeRuns : singleSteps};
            list2.append(stringArray);
        } else {
            stringArray = new String[]{this.stepwise ? completeRuns : singleSteps, newSeed};
            list2.append(stringArray);
            stringArray = new String[]{this.fixedSeed ? variable : fixed};
            list2.append(stringArray);
        }
        return list2;
    }

    public void execute(String string) {
        if (nextStep.equals(string) && this.ct != null) {
            this.singleStep();
        } else if (parallelStep.equals(string)) {
            this.parallelStep();
        } else if (back.equals(string)) {
            this.back();
        } else if (newSeed.equals(string)) {
            this.newSeed();
            this.apply(this.lastArgument);
        } else if (variable.equals(string) || fixed.equals(string)) {
            this.fixedSeed = !this.fixedSeed;
        } else if (singleSteps.equals(string) || completeRuns.equals(string)) {
            boolean bl = this.stepwise = !this.stepwise;
            if (this.ct != null && this.stepwise) {
                this.ct.stepCount = -1;
            }
            this.currTerm = this.getTerm(this.ct);
        }
    }

    public tdTransducer() {
        this.newSeed();
    }

    private void newSeed() {
        this.randomSeed = (long)(9.223372036854776E18 * Math.random());
        this.random.setSeed(this.randomSeed);
    }

    private void resetSeed() {
        if (this.fixedSeed) {
            this.random.setSeed(this.randomSeed);
        } else {
            this.newSeed();
        }
    }

    public term apply(term term2) {
        this.lastArgument = term2;
        if (term2 == null) {
            this.ct = null;
            this.lookAhead = null;
        } else {
            if (this.isDeterministic || this.isTotal) {
                this.lookAhead = null;
            } else {
                this.lookAhead = this.lookAhead(term2);
                if (!this.lookAhead.reachable.get(this.states.indexOf(this.initialState))) {
                    this.lookAhead = null;
                }
            }
            this.resetSeed();
            this.run();
            if (this.stepwise) {
                this.ct.stepCount = -1;
            }
        }
        this.currTerm = this.getTerm();
        return this.currTerm;
    }

    /*
     * Unable to fully structure code
     */
    private void run() {
        var1_1 = this.lookAhead != null;
        var2_2 = new list();
        if (var1_1) {
            var2_2.prepend(this.lookAhead);
        }
        this.ct = new computationTree();
        var2_2.prepend(this.ct);
        var2_2.prepend(this.lastArgument);
        var2_2.prepend(this.initialState);
        var3_3 = new list();
        block0: while (true) {
            this.allowExit();
            if (var2_2.isEmpty()) {
                if (var3_3.isEmpty()) {
                    return;
                }
                var2_2 = var3_3;
                var3_3 = new list();
            }
            var4_4 = (symbol)var2_2.head();
            var2_2 = var2_2.tail();
            var5_5 = (term)var2_2.head();
            var2_2 = var2_2.tail();
            var6_6 = (computationTree)var2_2.head();
            var2_2 = var2_2.tail();
            if (var1_1) {
                var7_7 = (lookAheadTree)var2_2.head();
                var2_2 = var2_2.tail();
            } else {
                var7_7 = null;
            }
            var8_8 = new term(var4_4);
            var8_8.defineSubterm(0, var5_5);
            var9_9 = this.chooseRule(var8_8, var7_7);
            var6_6.initialize(var8_8, var9_9);
            if (var9_9 == -1) continue;
            var10_10 = 0;
            while (true) {
                if (var10_10 < this.rhsQ[var6_6.rule].length) ** break;
                continue block0;
                if (var1_1) {
                    var3_3.prepend(var7_7.sub[this.rhsIndex[var6_6.rule][var10_10]]);
                }
                var6_6.subcomputation[var10_10] = new computationTree();
                var3_3.prepend(var6_6.subcomputation[var10_10]);
                var3_3.prepend(var5_5.subterm(this.rhsIndex[var6_6.rule][var10_10]));
                var3_3.prepend(this.rhsQ[var6_6.rule][var10_10]);
                ++var10_10;
            }
            break;
        }
    }

    private void singleStep() {
        this.singleStepPerformed = false;
        this.singleStep(this.ct);
        this.currTerm = this.getTerm();
    }

    private void singleStep(computationTree computationTree2) {
        block3: {
            block2: {
                if (computationTree2.stepCount == -1) break block2;
                ++computationTree2.stepCount;
                for (int i = 0; i < computationTree2.subcomputation.length; ++i) {
                    this.singleStep(computationTree2.subcomputation[i]);
                }
                break block3;
            }
            if (this.singleStepPerformed) break block3;
            this.singleStepPerformed = true;
            computationTree2.stepCount = 0;
            for (int i = 0; i < computationTree2.subcomputation.length; ++i) {
                computationTree2.subcomputation[i].stepCount = -1;
            }
        }
    }

    private void parallelStep() {
        this.parallelStep(this.ct);
        this.currTerm = this.getTerm();
    }

    private void parallelStep(computationTree computationTree2) {
        if (computationTree2.stepCount++ != -1) {
            for (int i = 0; i < computationTree2.subcomputation.length; ++i) {
                this.parallelStep(computationTree2.subcomputation[i]);
            }
        } else {
            for (int i = 0; i < computationTree2.subcomputation.length; ++i) {
                computationTree2.subcomputation[i].stepCount = -1;
            }
        }
    }

    private void back() {
        this.back(this.ct);
        this.currTerm = this.getTerm();
    }

    private void back(computationTree computationTree2) {
        if (computationTree2.stepCount != -1) {
            --computationTree2.stepCount;
            for (int i = 0; i < computationTree2.subcomputation.length; ++i) {
                this.back(computationTree2.subcomputation[i]);
            }
        }
    }

    private int chooseRule(term term2, lookAheadTree lookAheadTree2) {
        symbol symbol2 = term2.topSymbol();
        symbol symbol3 = term2.subterm(0).topSymbol();
        double d = 0.0;
        double d2 = 0.0;
        int n = -1;
        block0: for (int i = 0; i < this.rule.length; ++i) {
            double d3;
            if (!symbol2.equals(this.rule[i][0].topSymbol()) || !symbol3.equals(this.rule[i][0].subterm(0).topSymbol())) continue;
            if (lookAheadTree2 != null) {
                for (int j = 0; j < this.rhsQ[i].length; ++j) {
                    if (!lookAheadTree2.sub[this.rhsIndex[i][j]].reachable.get(this.states.indexOf(this.rhsQ[i][j]))) continue block0;
                }
            }
            if ((d += this.weight[i]) > 0.0) {
                if (!(this.weight[i] > 0.0) || !((double)this.random.nextFloat() <= this.weight[i] / d)) continue;
                n = i;
                continue;
            }
            d2 += 1.0;
            if (!((double)this.random.nextFloat() <= 1.0 / d3)) continue;
            n = i;
        }
        return n;
    }

    private term getTerm() {
        if (this.ct == null) {
            return null;
        }
        return this.getTerm(this.ct);
    }

    private term getTerm(computationTree computationTree2) {
        if (this.stepwise && computationTree2.stepCount == -1) {
            return computationTree2.initial;
        }
        if (computationTree2.rule == -1) {
            return null;
        }
        return this.constructTerm(this.rhs[computationTree2.rule], computationTree2.subcomputation);
    }

    private term constructTerm(term term2, computationTree[] computationTreeArray) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable) {
            return this.getTerm(computationTreeArray[((variable)symbol2).index()]);
        }
        term term3 = new term(symbol2);
        for (int i = 0; i < symbol2.rank(); ++i) {
            term term4 = this.constructTerm(term2.subterm(i), computationTreeArray);
            if (term4 == null) {
                return null;
            }
            term3.defineSubterm(i, term4);
        }
        return term3;
    }

    public term currentTerm() {
        return this.currTerm;
    }

    protected boolean isDeterministic() {
        return this.isDeterministic;
    }

    private void checkDeterminism() {
        this.isDeterministic = false;
        for (int i = 0; i < this.rule.length; ++i) {
            for (int j = i + 1; j < this.rule.length; ++j) {
                if (!this.rule[i][0].topSymbol().equals(this.rule[j][0].topSymbol()) || !this.rule[i][0].subterm(0).topSymbol().equals(this.rule[j][0].subterm(0).topSymbol())) continue;
                return;
            }
        }
        this.isDeterministic = true;
    }

    private void checkTotality() {
        this.isTotal = true;
        Enumeration enumeration2 = this.states.elements();
        while (enumeration2.hasMoreElements()) {
            symbol symbol2 = (symbol)enumeration2.nextElement();
            Enumeration enumeration3 = this.inputSignature.elements();
            block1: while (enumeration3.hasMoreElements()) {
                symbol symbol3 = (symbol)enumeration3.nextElement();
                for (int i = 0; i < this.rule.length; ++i) {
                    if (this.rule[i][0].topSymbol().equals(symbol2) && this.rule[i][0].subterm(0).topSymbol().equals(symbol3)) continue block1;
                }
                this.isTotal = false;
                return;
            }
        }
    }

    public void parse(ASCII_CharStream aSCII_CharStream) throws ParseException {
        tdTransducerParser tdTransducerParser2 = new tdTransducerParser(aSCII_CharStream);
        tdTransducerParser2.tdTransducer();
        this.initialState = tdTransducerParser2.initial;
        this.rule = tdTransducerParser2.rule;
        this.weight = tdTransducerParser2.weight;
        this.states = tdTransducerParser2.states;
        this.inputSignature = tdTransducerParser2.in;
        this.rhsQ = new symbol[this.rule.length][];
        this.rhsIndex = new int[this.rule.length][];
        this.rhs = new term[this.rule.length];
        for (int i = 0; i < this.rule.length; ++i) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.decompositionIndex = 0;
            this.rhs[i] = this.decompose(vector, vector2, this.rule[i][1]);
            this.rhsQ[i] = new symbol[vector.size()];
            vector.copyInto(this.rhsQ[i]);
            this.rhsIndex[i] = new int[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                this.rhsIndex[i][j] = (Integer)vector2.elementAt(j);
            }
        }
        this.checkDeterminism();
        this.checkTotality();
    }

    private term decompose(Vector vector, Vector vector2, term term2) {
        symbol symbol2 = term2.topSymbol();
        if (this.states.contains(symbol2)) {
            vector.addElement(symbol2);
            vector2.addElement(new Integer(((variable)term2.subterm(0).topSymbol()).index() - 1));
            return new term(new variable(this.decompositionIndex++));
        }
        term term3 = new term(symbol2);
        for (int i = 0; i < symbol2.rank(); ++i) {
            term3.defineSubterm(i, this.decompose(vector, vector2, term2.subterm(i)));
        }
        return term3;
    }

    private lookAheadTree lookAhead(term term2) {
        int n;
        symbol symbol2 = term2.topSymbol();
        lookAheadTree lookAheadTree2 = new lookAheadTree(symbol2.rank());
        for (n = 0; n < symbol2.rank(); ++n) {
            lookAheadTree2.sub[n] = this.lookAhead(term2.subterm(n));
        }
        block1: for (n = 0; n < this.rule.length; ++n) {
            symbol symbol3 = this.rule[n][0].topSymbol();
            if (lookAheadTree2.reachable.get(this.states.indexOf(symbol3)) || !this.rule[n][0].subterm(0).topSymbol().equals(symbol2)) continue;
            for (int i = 0; i < this.rhsQ[n].length; ++i) {
                int n2 = this.states.indexOf(this.rhsQ[n][i]);
                if (!lookAheadTree2.sub[this.rhsIndex[n][i]].reachable.get(n2)) continue block1;
            }
            lookAheadTree2.reachable.set(this.states.indexOf(symbol3));
        }
        return lookAheadTree2;
    }

    private class lookAheadTree {
        public BitSet reachable;
        public lookAheadTree[] sub;

        public lookAheadTree(int n) {
            this.sub = new lookAheadTree[n];
            this.reachable = new BitSet(tdTransducer.this.states.maxIndex());
        }
    }

    private class computationTree {
        public term initial;
        public int rule;
        public int stepCount;
        public computationTree[] subcomputation = null;

        private computationTree() {
        }

        public void initialize(term term2, int n) {
            this.initial = term2;
            this.rule = n;
            this.stepCount = -1;
            this.subcomputation = n != -1 ? new computationTree[tdTransducer.this.rhsQ[n].length] : new computationTree[0];
        }
    }
}

