/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.componentGraph;
import gui.errorDisplay;
import gui.fileChooser;
import gui.nodeTypes.worksheetNode;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AccessControlException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class editor
extends JFrame
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = -7969931654315423028L;
    private static String openCMD = "Open...";
    private static String saveCMD = "Save";
    private static String saveasCMD = "Save as...";
    private static String saveqCMD = "Save & quit";
    private static String quitCMD = "Quit";
    private static String undoCMD = "Undo";
    private static String redoCMD = "Redo";
    private static String copyCMD = "Copy";
    private static String cutCMD = "Cut";
    private static String pasteCMD = "Paste";
    private static String selectAllCMD = "Select all";
    private static String reloadCMD = "Auto (re)load";
    private static String indentCMD = "Auto indent";
    private UndoManager undo = null;
    private String fileName = null;
    private myJTextArea text = new myJTextArea(30, 80);
    JCheckBoxMenuItem reload = new JCheckBoxMenuItem(reloadCMD);
    JCheckBoxMenuItem indent = new JCheckBoxMenuItem(indentCMD);
    private worksheetNode myNode;
    private boolean unsaved = false;
    private componentGraph graph = null;
    private Point nodePos = null;

    private editor() {
        this.reload.setState(true);
        this.indent.setState(true);
        this.setDefaultCloseOperation(0);
        this.enableEvents(64L);
        this.getContentPane().add(new JScrollPane(this.text));
        this.text.setFont(new Font("Monospaced", 0, 14));
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setMargin(new Insets(5, 7, 5, 7));
        this.setJMenuBar(this.menus());
    }

    public editor(String fileName, worksheetNode node2) {
        this();
        this.myNode = node2;
        node2.addEditor(this);
        if (!this.load(fileName)) {
            this.dispose();
            return;
        }
        this.pack();
        this.show();
        this.text.getDocument().addDocumentListener(this);
        this.undo = new UndoManager();
        this.text.getDocument().addUndoableEditListener(this.undo);
    }

    public editor(Point pos, componentGraph g) {
        this();
        this.nodePos = pos;
        this.graph = g;
        this.pack();
        this.show();
        this.text.getDocument().addDocumentListener(this);
        this.undo = new UndoManager();
        this.text.getDocument().addUndoableEditListener(this.undo);
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && this.confirm()) {
            if (this.myNode != null) {
                this.myNode.removeEditor(this);
            }
            this.dispose();
        }
    }

    private JMenuBar menus() {
        JMenuBar bar = new JMenuBar();
        JMenu m = new JMenu("File");
        bar.add(m);
        this.addItem(new JMenuItem(openCMD), m, 79);
        m.addSeparator();
        this.addItem(new JMenuItem(saveCMD), m, 83);
        this.addItem(new JMenuItem(saveasCMD), m, -1);
        m.addSeparator();
        this.addItem(new JMenuItem(saveqCMD), m, 69);
        this.addItem(new JMenuItem(quitCMD), m, 81);
        m = new JMenu("Edit");
        bar.add(m);
        this.addItem(new JMenuItem(undoCMD), m, 90);
        this.addItem(new JMenuItem(redoCMD), m, 82);
        m.addSeparator();
        this.addItem(new JMenuItem(copyCMD), m, 67);
        this.addItem(new JMenuItem(cutCMD), m, 88);
        this.addItem(new JMenuItem(pasteCMD), m, 86);
        m.addSeparator();
        this.addItem(new JMenuItem(selectAllCMD), m, 65);
        m = new JMenu("Options");
        bar.add(m);
        this.addItem(this.reload, m, -1);
        this.addItem(this.indent, m, -1);
        return bar;
    }

    private void addItem(JMenuItem i, JMenu m, int key) {
        if (key != -1) {
            i.setAccelerator(KeyStroke.getKeyStroke(key, 2));
        }
        i.addActionListener(this);
        m.add(i);
    }

    private boolean load(String file) {
        try {
            this.text.read(new FileReader(file), null);
            this.setTitle(file);
            this.fileName = file;
            return true;
        }
        catch (IOException e) {
            errorDisplay.show("Failed to read file\n" + file);
            return false;
        }
        catch (AccessControlException ex) {
            errorDisplay.show("Failed to write file\n" + this.fileName);
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(saveCMD)) {
            this.save();
        } else if (e.getActionCommand().equals(saveasCMD)) {
            this.saveAs();
        } else if (e.getActionCommand().equals(openCMD) && this.confirm()) {
            this.open();
        } else if (e.getActionCommand().equals(saveqCMD)) {
            this.saveQuit();
        } else if (e.getActionCommand().equals(quitCMD) && this.confirm()) {
            if (this.myNode != null) {
                this.myNode.removeEditor(this);
            }
            this.dispose();
        } else if (e.getActionCommand().equals(undoCMD)) {
            try {
                this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {}
        } else if (e.getActionCommand().equals(redoCMD)) {
            try {
                this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {}
        } else if (e.getActionCommand().equals(copyCMD)) {
            this.text.copy();
        } else if (e.getActionCommand().equals(cutCMD)) {
            this.text.cut();
        } else if (e.getActionCommand().equals(pasteCMD)) {
            this.text.paste();
        } else if (e.getActionCommand().equals(selectAllCMD)) {
            this.text.selectAll();
        }
    }

    private boolean save() {
        if (this.fileName == null) {
            return this.saveAs();
        }
        try {
            this.text.write(new FileWriter(this.fileName));
            this.setUnsaved(false);
            if (this.reload.getState()) {
                if (this.myNode != null) {
                    return this.myNode.reload(this.fileName);
                }
                return this.mkNode();
            }
            return true;
        }
        catch (IOException ex) {
            errorDisplay.show("Failed to write file\n" + this.fileName);
            return false;
        }
        catch (AccessControlException ex) {
            errorDisplay.show("Failed to write file\n" + this.fileName);
            return false;
        }
    }

    private boolean saveAs() {
        String name = fileChooser.selectFile("Save file", 1);
        if (name != null) {
            try {
                this.text.write(new FileWriter(name));
                this.setUnsaved(false);
                this.fileName = name;
                this.setTitle(this.fileName);
                if (this.reload.getState()) {
                    if (this.myNode != null) {
                        return this.myNode.reload(this.fileName);
                    }
                    return this.mkNode();
                }
                return true;
            }
            catch (IOException ex) {
                errorDisplay.show("Failed to write file\n" + this.fileName);
                return false;
            }
            catch (AccessControlException ex) {
                errorDisplay.show("Failed to write file\n" + this.fileName);
                return false;
            }
        }
        return false;
    }

    private void open() {
        String name = fileChooser.selectFile("Open file in editor", 0);
        if (name != null) {
            this.text.getDocument().removeDocumentListener(this);
            this.load(name);
            this.text.getDocument().addDocumentListener(this);
        }
    }

    private void saveQuit() {
        if (this.save()) {
            this.dispose();
        }
    }

    private boolean mkNode() {
        this.myNode = this.graph.newNode(this.nodePos, this.fileName);
        if (this.myNode != null) {
            this.myNode.addEditor(this);
        }
        return this.myNode != null;
    }

    private boolean confirm() {
        if (this.unsaved) {
            int choice = JOptionPane.showConfirmDialog(null, "Save modified file?", "Unsaved file!", 1, 3);
            if (choice == 0) {
                try {
                    this.text.write(new FileWriter(this.fileName));
                    if (this.reload.getState()) {
                        this.myNode.reload(this.fileName);
                    }
                }
                catch (IOException ex) {
                    errorDisplay.show("Failed to write file\n" + this.fileName);
                    return false;
                }
                catch (AccessControlException ex) {
                    errorDisplay.show("Failed to write file\n" + this.fileName);
                    return false;
                }
                return true;
            }
            if (choice == 2) {
                return false;
            }
            this.setUnsaved(false);
        }
        return true;
    }

    private synchronized void setUnsaved(boolean b) {
        this.unsaved = b;
    }

    public synchronized boolean isUnsaved() {
        return this.unsaved;
    }

    public synchronized void changedUpdate(DocumentEvent e) {
        this.setUnsaved(true);
    }

    public synchronized void insertUpdate(DocumentEvent e) {
        this.setUnsaved(true);
    }

    public synchronized void removeUpdate(DocumentEvent e) {
        this.setUnsaved(true);
    }

    private class myJTextArea
    extends JTextArea {
        private static final long serialVersionUID = 216835670162489493L;

        public myJTextArea(int rows, int cols) {
            super(rows, cols);
        }

        protected void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
            if (!editor.this.indent.getState()) {
                return;
            }
            try {
                if (e.getID() == 402 && e.getKeyCode() == 10) {
                    this.insert(this.getWhiteSpace(new StringBuffer(), this.getCaretPosition() - 2), this.getCaretPosition());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        private String getWhiteSpace(StringBuffer result, int i) throws BadLocationException {
            while (i >= 0) {
                char c;
                if ((c = this.getText(i--, 1).charAt(0)) == ' ' || c == '\t') {
                    result.insert(0, c);
                    continue;
                }
                if (c == '\n') {
                    return result.toString();
                }
                result.setLength(0);
            }
            return result.toString();
        }
    }
}

