/*
 * Decompiled with CFR 0.152.
 */
package gui.nodeTypes;

import algebras.algebra;
import displays.display;
import gui.edge;
import gui.nodeTypes.algebraNode;
import gui.nodeTypes.worksheetNode;
import gui.scrollCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import javax.swing.JFrame;
import parsers.parsable;

public class displayNode
extends worksheetNode {
    private static final long serialVersionUID = 4008427967317872359L;
    private JFrame window = null;
    private static int xDist = 4 * radius / 7;
    private static int delta = radius / 7;
    private static int yDist = 4 * radius / 9;
    private static int[] iconX = new int[]{-xDist, -xDist + delta, xDist - delta, xDist, xDist, xDist - delta, -xDist + delta, -xDist};
    private static int[] iconY = new int[]{yDist - delta, yDist, yDist, yDist - delta, -yDist + delta, -yDist, -yDist, -yDist + delta};

    public displayNode(display disp, String fileName) {
        super(disp, fileName);
        this.figureX = iconX;
        this.figureY = iconY;
    }

    public int openWindows() {
        return super.openWindows() + (this.window != null && this.window.isShowing() ? 1 : 0);
    }

    private synchronized boolean initWindow() {
        Component c = ((display)this.contents).visualizer();
        if (c != null) {
            this.window = new JFrame();
            this.windowTitle();
            Container cp2 = this.window.getContentPane();
            cp2.setBackground(Color.white);
            cp2.add(c);
            if (c instanceof scrollCanvas) {
                cp2.add((Component)((scrollCanvas)c).getVScrollBar(), "East");
                cp2.add((Component)((scrollCanvas)c).getHScrollBar(), "South");
            }
            this.window.pack();
            Point p = this.parent().getLocationOnScreen();
            this.window.setLocation(new Point(p.x + this.position.x + radius, p.y + this.position.y + radius));
            return true;
        }
        return false;
    }

    private void windowTitle() {
        if (this.window != null) {
            if (this.inputEdge != null) {
                worksheetNode source = (worksheetNode)this.inputEdge.source;
                String inputName = source.getName();
                this.window.setTitle(String.valueOf(this.getName()) + " (input: " + inputName + ")");
            } else {
                this.window.setTitle(String.valueOf(this.getName()) + " <no input>");
            }
        }
    }

    public boolean acceptsSource(worksheetNode source) {
        if (!(source instanceof algebraNode)) {
            return false;
        }
        algebra alg = (algebra)source.contents;
        return ((display)this.contents).acceptable(alg);
    }

    public void inputEdgeEstablished(edge e) {
        super.inputEdgeEstablished(e);
        this.windowTitle();
        this.redisplay();
    }

    public void redisplay() {
        if (this.inputEdge != null) {
            algebraNode source = (algebraNode)this.inputEdge.source;
            this.transferCommand(source.current(), VALUE);
        } else {
            this.transferCommand(null, VALUE);
        }
    }

    public void open() {
        if (this.window != null || this.initWindow()) {
            if (this.window.isShowing()) {
                this.window.setVisible(true);
                super.open();
            } else {
                this.window.setVisible(true);
            }
        } else {
            super.open();
        }
    }

    protected void reinit(parsable newContents) {
        super.reinit(newContents);
        Component c = ((display)this.contents).visualizer();
        if (this.window != null) {
            if (c != null) {
                Container cp2 = this.window.getContentPane();
                cp2.removeAll();
                cp2.add(c);
                if (c instanceof scrollCanvas) {
                    cp2.add((Component)((scrollCanvas)c).getVScrollBar(), "East");
                    cp2.add((Component)((scrollCanvas)c).getHScrollBar(), "South");
                }
                this.window.pack();
            } else {
                this.window.dispose();
                this.window = null;
            }
        }
    }

    public void runContents(Object command, int type) {
        if (type == VALUE) {
            display d = (display)this.contents;
            d.display(command);
        } else {
            super.runContents(command, type);
        }
    }

    public void inputEdgeDeleted(edge e) {
        super.inputEdgeDeleted(e);
        this.windowTitle();
        this.redisplay();
    }

    protected void dispose() {
        if (this.window != null) {
            this.window.getContentPane().removeAll();
            this.window.dispose();
        }
        this.window = null;
        super.dispose();
    }
}

