/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.node;
import gui.textCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class visibleNode
extends node
implements MouseListener,
MouseMotionListener,
ComponentListener {
    public static int radius = 15;
    protected Color col = new Color(0.75f, 1.0f, 0.75f);
    protected int[] figureX = null;
    protected int[] figureY = null;
    private static int textGap = 5;
    private Point pressedAt = null;
    private boolean clickedOnce = false;
    private textCanvas labels = new textCanvas();

    public visibleNode() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setTextLocation();
        this.add(this.labels);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            this.clickedOnce = true;
        } else if (e.getClickCount() == 2) {
            this.clickedOnce = false;
            this.open();
        }
    }

    protected abstract void open();

    public void mousePressed(MouseEvent e) {
        this.pressedAt = new Point(e.getPoint());
    }

    public void mouseReleased(MouseEvent e) {
        this.pressedAt = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this.clickedOnce) {
            this.clickedOnce = false;
            this.parent().createDanglingEdge(this, e.getPoint());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.clickedOnce = false;
        if (this.pressedAt != null) {
            this.setPosition(this.position.x + e.getPoint().x - this.pressedAt.x, this.position.y + e.getPoint().y - this.pressedAt.y);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.setPosition(this.position);
    }

    public void componentShown(ComponentEvent e) {
    }

    private void setPosition(int x, int y) {
        Dimension d = this.getParent().getSize();
        x = Math.min(x, d.width - radius);
        y = Math.min(y, d.height - radius);
        x = Math.max(radius, x);
        y = Math.max(radius, y);
        if (x != this.position.x || y != this.position.y) {
            this.position.x = x;
            this.position.y = y;
            this.updateBounds();
            this.setTextLocation();
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void setPosition(Point p) {
        this.setPosition(p.x, p.y);
    }

    private void updateBounds() {
        this.setBounds(this.position.x - Math.max(radius, this.labels.getSize().width / 2), this.position.y - radius, Math.max(2 * radius, this.labels.getSize().width), 2 * radius + this.labels.getSize().height + textGap);
    }

    public void addLabel(String line2) {
        this.labels.addTextLine(line2);
        this.setTextLocation();
        this.updateBounds();
        this.invalidate();
        this.repaint();
    }

    public void removeLabels() {
        this.labels.removeTextLines();
        this.setTextLocation();
        this.updateBounds();
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        g.translate(this.getSize().width / 2, radius);
        g.fillArc(-radius, -radius, 2 * radius, 2 * radius, 0, 360);
        if (this.figureX != null) {
            g.setColor(this.col);
            g.fillPolygon(this.figureX, this.figureY, this.figureX.length);
            g.drawPolygon(this.figureX, this.figureY, this.figureX.length);
            g.setColor(Color.black);
        }
    }

    public boolean contains(int x, int y) {
        return Math.sqrt((x -= this.getSize().width / 2) * x + (y -= radius) * y) <= (double)radius;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Point getBorderPoint(Point seenFrom) {
        int deltaX = seenFrom.x - this.position.x;
        int deltaY = seenFrom.y - this.position.y;
        double len = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        if (len <= (double)radius) {
            return null;
        }
        return new Point((int)((double)this.position.x + (double)(deltaX * radius) / len), (int)((double)this.position.y + (double)(deltaY * radius) / len));
    }

    private void setTextLocation() {
        this.labels.setLocation(Math.max(0, radius - this.labels.getSize().width / 2), 2 * radius + textGap);
    }
}

