/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import applications.collages.collage;
import applications.collages.collageAlgebra;
import applications.collages.collageOperation;
import applications.collages.colourOperation;
import applications.collages.part;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.InputStream;
import java.io.Reader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.Token;
import parsers.collageAlgebraParserConstants;
import parsers.collageAlgebraParserTokenManager;
import parsers.nameParser;
import terms.symbol;

public class collageAlgebraParser
implements collageAlgebraParserConstants {
    private nameParser names;
    private Hashtable transTable = new Hashtable();
    private Hashtable constTable = new Hashtable();
    private Hashtable colTable = new Hashtable();
    private Hashtable colOpTable = new Hashtable();
    private ASCII_CharStream inputStream = null;
    private collageAlgebra result;
    private Vector attribs = new Vector();
    private boolean attribsDefined = false;
    float firstCx;
    float firstCy;
    float firstPx;
    float firstPy;
    float lx;
    float ly;
    float rx;
    float ry;
    float px;
    float py;
    boolean close;
    public collageAlgebraParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[51];
    private final int[] jj_la1_0 = new int[]{0, 0, 0x140000, 262144, 0, 532694016, 0, 0, 0, -536870848, 1024, 0, 0, 262144, 64, 64, 4096, -536870848, 20480, 20480, 0, 262656, 0, 0, 0, 0, 262144, 0x100000, 262144, 262144, 0, 262656, 262144, 528482304, 294912, 128, 262144, 0x200000, 0x280000, 262144, 384, 0, 0, 0, 0, 384, 0, 0, 0, 0, 384};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 212992, 0, 0, 0, 127, 65536, 786432, 786432, 0, 14336, 14336, 0, 127, 0, 0, 32768, 0, 256, 128, 384, 384, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, -1881079808, 0, 0, 0, 0, -1881079808, 0, 0, 0, 0, -1881079808};
    private final int[] jj_la1_2 = new int[]{16, 196608, 0, 0, 32, 0, 12288, 12288, 34816, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1536, 0, 0, 0, 0, 64, 0, 0, 0, 0, 524295, 786432, 786432, 0x300000, 0x300000, 524303, 786432, 786432, 0x300000, 0x300000, 524291};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public collageAlgebraParser(ASCII_CharStream aSCII_CharStream) {
        this(new collageAlgebraParserTokenManager(aSCII_CharStream));
        this.names = new nameParser(aSCII_CharStream);
        this.inputStream = aSCII_CharStream;
    }

    private AffineTransform linearMapping(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws ParseException {
        double d9;
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        double d10 = d;
        dArrayArray[1][2] = d10;
        dArrayArray[0][0] = d10;
        double d11 = d2;
        dArrayArray[1][3] = d11;
        dArrayArray[0][1] = d11;
        double d12 = d5;
        dArrayArray[3][2] = d12;
        dArrayArray[2][0] = d12;
        double d13 = d6;
        dArrayArray[3][3] = d13;
        dArrayArray[2][1] = d13;
        dArrayArray[0][4] = d3;
        dArrayArray[1][4] = d4;
        dArrayArray[2][4] = d7;
        dArrayArray[3][4] = d8;
        if (dArrayArray[0][0] == 0.0) {
            collageAlgebraParser.swap(dArrayArray, 0, 2);
            collageAlgebraParser.swap(dArrayArray, 1, 3);
        }
        if ((d9 = dArrayArray[0][0] * dArrayArray[2][1] - dArrayArray[0][1] * dArrayArray[2][0]) == 0.0) {
            throw new ParseException("vectors (" + d + ", " + d2 + ") and (" + d5 + ", " + d6 + ") linearly dependent");
        }
        double d14 = (dArrayArray[0][0] * dArrayArray[2][4] - dArrayArray[2][0] * dArrayArray[0][4]) / d9;
        double d15 = (dArrayArray[0][4] - dArrayArray[0][1] * d14) / dArrayArray[0][0];
        double d16 = (dArrayArray[0][0] * dArrayArray[3][4] - dArrayArray[2][0] * dArrayArray[1][4]) / d9;
        double d17 = (dArrayArray[1][4] - dArrayArray[0][1] * d16) / dArrayArray[0][0];
        return new AffineTransform(d15, d17, d14, d16, 0.0, 0.0);
    }

    private static void swap(double[][] dArray, int n, int n2) {
        double[] dArray2 = (double[])dArray[n].clone();
        dArray[n] = dArray[n2];
        dArray[n2] = dArray2;
    }

    private AffineTransform affineMapping(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d9, -d10);
        d -= d9;
        d2 -= d10;
        d5 -= d9;
        d6 -= d10;
        d3 -= d11;
        d4 -= d12;
        d7 -= d11;
        d8 -= d12;
        try {
            AffineTransform affineTransform2 = this.linearMapping(d, d2, d3, d4, d5, d6, d7, d8);
            affineTransform.preConcatenate(affineTransform2);
        }
        catch (ParseException parseException) {
            throw new ParseException("vectors linearly dependent");
        }
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d11, d12));
        return affineTransform;
    }

    private AffineTransform similarity(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws ParseException {
        double d9 = Math.sqrt((d -= d5) * d + (d2 -= d6) * d2);
        double d10 = Math.sqrt((d3 -= d7) * d3 + (d4 -= d8) * d4);
        if (d9 == 0.0) {
            throw new ParseException("pre-images in definition of similarity must not be identical");
        }
        if (d10 == 0.0) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(0.0, 0.0);
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d7, d8));
            return affineTransform;
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d5, -d6);
        affineTransform.preConcatenate(AffineTransform.getScaleInstance(d10 / d9, d10 / d9));
        affineTransform.preConcatenate(AffineTransform.getRotateInstance(Math.atan2(d4 / d10, d3 / d10) - Math.atan2(d2 / d9, d / d9)));
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d7, d8));
        return affineTransform;
    }

    private collage lookup(String string) throws ParseException {
        Object v = this.colTable.get(string);
        if (v == null) {
            throw new ParseException("Collage '" + string + "' undefined");
        }
        collage collage2 = (collage)v;
        return (collage)collage2.clone();
    }

    public final void collageAlgebra(collageAlgebra collageAlgebra2) throws ParseException {
        this.result = collageAlgebra2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                this.attributes();
                this.attribsDefined = true;
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        if (!this.attribsDefined) {
            this.attribs.addElement("r");
            this.attribs.addElement("g");
            this.attribs.addElement("b");
        }
        this.jj_consume_token(10);
        this.token_source.SwitchTo(0);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                this.definitions();
                this.jj_consume_token(11);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attributes() throws ParseException {
        boolean bl = false;
        String string = this.names.name();
        if (this.attribs.contains(string)) {
            throw new ParseException("Attribute name " + string + " declared twice");
        }
        this.attribs.addElement(string);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.attributes();
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void definitions() throws ParseException {
        this.definition();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.definitions();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    public final void definition() throws ParseException {
        collage collage2 = new collage();
        String string = this.names.name();
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                if (this.constTable.put(string, new Double(d)) == null) break;
                throw new ParseException("constant " + string + " defined twice");
            }
            case 10: 
            case 48: {
                this.collageUnion(collage2);
                if (this.result.defineSymbol(new symbol(string, 0), (Object)collage2) != null) {
                    throw new ParseException("constant " + string + " defined twice");
                }
                this.colTable.put(string, collage2);
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 49: {
                AffineTransform affineTransform = this.composedTransformation(new AffineTransform());
                if (this.transTable.put(string, affineTransform) == null) break;
                throw new ParseException("transformation " + string + " defined twice");
            }
            case 14: {
                int n;
                Object[] objectArray = this.operation();
                int[] nArray = new int[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    nArray[n] = -1;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        this.jj_consume_token(8);
                        Vector vector = new Vector();
                        this.shuffle(vector);
                        this.jj_consume_token(9);
                        if (vector.size() != objectArray.length) {
                            throw new ParseException(objectArray.length + " shuffle counts required");
                        }
                        for (n = 0; n < objectArray.length; ++n) {
                            nArray[n] = (Integer)vector.get(n);
                        }
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                    }
                }
                n = 0;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!(objectArray[i] instanceof AffineTransform)) continue;
                    ++n;
                }
                if (this.result.defineSymbol(new symbol(string, n), (Object)new collageOperation(objectArray, nArray)) == null) break;
                if (n == 0) {
                    throw new ParseException("constant " + string + " defined twice");
                }
                throw new ParseException("operation " + string + " defined twice");
            }
            case 46: {
                colourOperation colourOperation2 = this.colourOperation();
                if (this.result.defineSymbol(new symbol(string, 1), (Object)colourOperation2) != null) {
                    throw new ParseException("operation " + string + " defined twice");
                }
                this.colOpTable.put(string, colourOperation2);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void collageUnion(collage collage2) throws ParseException {
        collage collage3;
        block14: {
            AffineTransform affineTransform = null;
            colourOperation colourOperation2 = null;
            collage3 = new collage();
            this.collage(collage3);
            this.token_source.SwitchTo(1);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: 
                    case 77: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 76: {
                        this.jj_consume_token(76);
                        this.jj_consume_token(78);
                        affineTransform = this.transByName();
                        if (affineTransform != null) {
                            collage3.transform(affineTransform);
                        }
                        affineTransform = null;
                        continue block11;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        this.jj_consume_token(78);
                        colourOperation2 = this.colByName();
                        if (colourOperation2 != null) {
                            collage3.changeColours(colourOperation2);
                        }
                        colourOperation2 = null;
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[7] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        collage2.unionWith(collage3);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                this.collageUnion(collage2);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void collage(collage collage2) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: {
                        this.parts(collage2);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                this.jj_consume_token(11);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                collage2.unionWith(this.lookup(this.names.name()));
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parts(collage collage2) throws ParseException {
        part part2;
        block13: {
            AffineTransform affineTransform = null;
            colourOperation colourOperation2 = null;
            part2 = this.part();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: 
                    case 51: {
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        this.jj_consume_token(52);
                        affineTransform = this.transByName();
                        if (affineTransform != null) {
                            part2.transform(affineTransform);
                        }
                        affineTransform = null;
                        continue block10;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        this.jj_consume_token(52);
                        colourOperation2 = this.colByName();
                        if (colourOperation2 != null) {
                            part2.changeColour(colourOperation2);
                        }
                        colourOperation2 = null;
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[12] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        collage2.add(part2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.parts(collage2);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final part part() throws ParseException {
        var1_1 = new GeneralPath();
        var20_2 = null;
        var21_3 = false;
        var22_4 = false;
        var23_5 = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(8);
                var1_1 = this.segments(false);
                var17_6 = new part(1, var1_1);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                this.jj_consume_token(8);
                var1_1 = this.segments(true);
                var17_6 = new part(1, var1_1);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                this.jj_consume_token(8);
                var1_1 = this.segments(true);
                var17_6 = new part(0, var1_1);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                this.jj_consume_token(8);
                var2_7 = this.expr();
                this.jj_consume_token(18);
                var4_15 = this.expr();
                this.jj_consume_token(18);
                var8_23 = this.expr();
                this.jj_consume_token(18);
                var10_25 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(1, new GeneralPath(new Ellipse2D.Double(var2_7 - var8_23, var4_15 - var10_25, var8_23 * 2.0, var10_25 * 2.0)));
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                this.jj_consume_token(8);
                var2_8 = this.expr();
                this.jj_consume_token(18);
                var4_16 = this.expr();
                this.jj_consume_token(18);
                var8_24 = this.expr();
                this.jj_consume_token(18);
                var10_26 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(0, new GeneralPath(new Ellipse2D.Double(var2_8 - var8_24, var4_16 - var10_26, var8_24 * 2.0, var10_26 * 2.0)));
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                this.jj_consume_token(8);
                var2_9 = this.expr();
                this.jj_consume_token(18);
                var4_17 = this.expr();
                this.jj_consume_token(18);
                var6_27 = this.expr();
                this.jj_consume_token(18);
                var12_32 = this.expr();
                this.jj_consume_token(18);
                var14_37 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(1, new GeneralPath(new Arc2D.Double(var2_9 - var6_27, var4_17 - var6_27, var6_27 * 2.0, var6_27 * 2.0, -var12_32, -var14_37, 2)));
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(8);
                var2_10 = this.expr();
                this.jj_consume_token(18);
                var4_18 = this.expr();
                this.jj_consume_token(18);
                var6_28 = this.expr();
                this.jj_consume_token(18);
                var12_33 = this.expr();
                this.jj_consume_token(18);
                var14_38 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(0, new GeneralPath(new Arc2D.Double(var2_10 - var6_28, var4_18 - var6_28, var6_28 * 2.0, var6_28 * 2.0, -var12_33, -var14_38, 2)));
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                this.jj_consume_token(8);
                var2_11 = this.expr();
                this.jj_consume_token(18);
                var4_19 = this.expr();
                this.jj_consume_token(18);
                var6_29 = this.expr();
                this.jj_consume_token(18);
                var12_34 = this.expr();
                this.jj_consume_token(18);
                var14_39 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(1, new GeneralPath(new Arc2D.Double(var2_11 - var6_29, var4_19 - var6_29, var6_29 * 2.0, var6_29 * 2.0, -var12_34, -var14_39, 0)));
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                this.jj_consume_token(8);
                var2_12 = this.expr();
                this.jj_consume_token(18);
                var4_20 = this.expr();
                this.jj_consume_token(18);
                var6_30 = this.expr();
                this.jj_consume_token(18);
                var12_35 = this.expr();
                this.jj_consume_token(18);
                var14_40 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(1, new GeneralPath(new Arc2D.Double(var2_12 - var6_30, var4_20 - var6_30, var6_30 * 2.0, var6_30 * 2.0, -var12_35, -var14_40, 1)));
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                this.jj_consume_token(8);
                var2_13 = this.expr();
                this.jj_consume_token(18);
                var4_21 = this.expr();
                this.jj_consume_token(18);
                var6_31 = this.expr();
                this.jj_consume_token(18);
                var12_36 = this.expr();
                this.jj_consume_token(18);
                var14_41 = this.expr();
                this.jj_consume_token(9);
                var17_6 = new part(0, new GeneralPath(new Arc2D.Double(var2_13 - var6_31, var4_21 - var6_31, var6_31 * 2.0, var6_31 * 2.0, -var12_36, -var14_41, 1)));
                break;
            }
            case 6: {
                var18_42 = this.str();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        block35: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: 
                                case 43: 
                                case 44: 
                                case 45: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[14] = this.jj_gen;
                                    ** GOTO lbl218
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 6: {
                                    var19_43 = this.str();
                                    if (var20_2 != null && !var19_43.equals(var20_2)) {
                                        throw new ParseException("Two font names specified");
                                    }
                                    var20_2 = var19_43;
                                    continue block35;
                                }
                                case 43: {
                                    this.jj_consume_token(43);
                                    var21_3 = true;
                                    continue block35;
                                }
                                case 44: {
                                    this.jj_consume_token(44);
                                    var22_4 = true;
                                    continue block35;
                                }
                                case 45: {
                                    this.jj_consume_token(45);
                                    var23_5 = 1;
                                    continue block35;
                                }
                            }
                            break;
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
lbl218:
                        // 1 sources

                        this.jj_consume_token(13);
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                this.jj_consume_token(42);
                var16_44 = this.exprf();
                if (Math.rint(Math.abs(var16_44)) != (double)var16_44) {
                    throw new ParseException("Point size of font must be a nonnegative integer");
                }
                this.jj_consume_token(41);
                this.jj_consume_token(8);
                var2_14 = this.expr();
                this.jj_consume_token(18);
                var4_22 = this.expr();
                this.jj_consume_token(9);
                v0 = var24_45 = var21_3 != false ? 1 : 0;
                if (var22_4) {
                    var24_45 += 2;
                }
                var25_47 = new Font(var20_2 == null ? "SansSerif" : var20_2, var24_45 == 0 ? 0 : var24_45, Math.round(var16_44));
                var26_48 = var25_47.createGlyphVector(new FontRenderContext(null, false, true), var18_42);
                var27_49 = new GeneralPath(var26_48.getOutline());
                var28_50 = var27_49.getBounds2D();
                var27_49.transform(new AffineTransform(1.0, 0.0, 0.0, -1.0, var2_14 - var28_50.getCenterX(), var4_22 + var28_50.getCenterY()));
                var17_6 = new part(var23_5, var27_49);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block25 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 14: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 12: {
                        this.jj_consume_token(12);
                        this.staticColour(var17_6);
                        this.jj_consume_token(13);
                        break block25;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        this.variableColour(var17_6);
                        this.jj_consume_token(15);
                        break block25;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.jj_consume_token(47);
                var24_46 = this.expr();
                if (var24_46 < 0.0) {
                    throw new ParseException("Negative line width " + var24_46);
                }
                var17_6.setThickness(var24_46);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        return var17_6;
    }

    public final GeneralPath segments(boolean bl) throws ParseException {
        GeneralPath generalPath = new GeneralPath();
        this.curvePoint();
        generalPath.moveTo(this.px, this.py);
        this.firstCx = this.lx;
        this.firstCy = this.ly;
        this.firstPx = this.px;
        this.firstPy = this.py;
        this.close = bl;
        this.tail(generalPath, this.px, this.py, this.rx, this.ry);
        return generalPath;
    }

    public final void tail(GeneralPath generalPath, float f, float f2, float f3, float f4) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.curvePoint();
                if (this.lx == 0.0f && this.ly == 0.0f) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        generalPath.lineTo(this.px, this.py);
                    } else {
                        generalPath.quadTo(f + f3, f2 + f4, this.px, this.py);
                    }
                } else {
                    generalPath.curveTo(f + f3, f2 + f4, this.px + this.lx, this.py + this.ly, this.px, this.py);
                }
                this.tail(generalPath, this.px, this.py, this.rx, this.ry);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                if (!this.close) break;
                if (this.firstCx == 0.0f && this.firstCy == 0.0f) {
                    if (f3 == 0.0f && f4 == 0.0f) {
                        generalPath.lineTo(this.firstPx, this.firstPy);
                    } else {
                        generalPath.quadTo(f + f3, f2 + f4, this.firstPx, this.firstPy);
                    }
                } else {
                    generalPath.curveTo(f + f3, f2 + f4, this.firstCx + this.firstPx, this.firstCy + this.firstPy, this.firstPx, this.firstPy);
                }
                generalPath.closePath();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void curvePoint() throws ParseException {
        this.ry = 0.0f;
        this.rx = 0.0f;
        this.ly = 0.0f;
        this.lx = 0.0f;
        this.jj_consume_token(8);
        this.px = this.exprf();
        this.jj_consume_token(18);
        this.py = this.exprf();
        this.jj_consume_token(9);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 40: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        this.jj_consume_token(8);
                        this.lx = this.exprf();
                        this.jj_consume_token(18);
                        this.ly = this.exprf();
                        this.jj_consume_token(9);
                        this.rx = -this.lx;
                        this.ry = -this.ly;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 40: {
                                this.jj_consume_token(40);
                                this.jj_consume_token(8);
                                this.rx = this.exprf();
                                this.jj_consume_token(18);
                                this.ry = this.exprf();
                                this.jj_consume_token(9);
                                break block0;
                            }
                        }
                        this.jj_la1[22] = this.jj_gen;
                        break block0;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        this.jj_consume_token(8);
                        this.rx = this.exprf();
                        this.jj_consume_token(18);
                        this.ry = this.exprf();
                        this.jj_consume_token(9);
                        this.lx = -this.rx;
                        this.ly = -this.ry;
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 39: {
                                this.jj_consume_token(39);
                                this.jj_consume_token(8);
                                this.lx = this.exprf();
                                this.jj_consume_token(18);
                                this.ly = this.exprf();
                                this.jj_consume_token(9);
                                break block0;
                            }
                        }
                        this.jj_la1[23] = this.jj_gen;
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
    }

    public final void staticColour(part part2) throws ParseException {
        float f;
        float f2;
        float f3 = this.exprf();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                f2 = this.exprf();
                this.jj_consume_token(18);
                f = this.exprf();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                f2 = f = f3;
            }
        }
        if (f3 < 0.0f || f3 > 1.0f || f2 < 0.0f || f2 > 1.0f || f < 0.0f || f > 1.0f) {
            throw new ParseException("rgb values must be numbers in the interval [0,1]");
        }
        part2.setColour(f3, f2, f);
    }

    public final void variableColour(part part2) throws ParseException {
        if (this.attribsDefined) {
            part2.initAttribs(this.attribs.size());
            this.complexColourDefinition(part2);
        } else {
            part2.initAttribs(3);
            part2.setRgb(0, 1, 2);
            this.simpleColourDefinition(part2);
        }
    }

    public final void complexColourDefinition(part part2) throws ParseException {
        int n = this.attribute();
        this.jj_consume_token(18);
        int n2 = this.attribute();
        this.jj_consume_token(18);
        int n3 = this.attribute();
        part2.setRgb(n, n2, n3);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                this.attributeAssignments(part2, new BitSet(this.attribs.size()));
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
    }

    public final void attributeAssignments(part part2, BitSet bitSet) throws ParseException {
        int n = this.attribute();
        if (bitSet.get(n)) {
            throw new ParseException("Part has two values assigned to an attribute");
        }
        bitSet.set(n);
        this.jj_consume_token(16);
        part2.setAttrib(n, this.exprf());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.attributeAssignments(part2, bitSet);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
    }

    public final void simpleColourDefinition(part part2) throws ParseException {
        float f;
        float f2;
        float f3 = this.exprf();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                f2 = this.exprf();
                this.jj_consume_token(18);
                f = this.exprf();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                f2 = f = f3;
            }
        }
        part2.setAttrib(0, f3);
        part2.setAttrib(1, f2);
        part2.setAttrib(2, f);
    }

    public final AffineTransform composedTransformation(AffineTransform affineTransform) throws ParseException {
        AffineTransform affineTransform2 = this.transformation();
        affineTransform.preConcatenate(affineTransform2);
        this.token_source.SwitchTo(2);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                this.jj_consume_token(73);
                this.composedTransformation(affineTransform);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return affineTransform;
    }

    public final AffineTransform transformation() throws ParseException {
        AffineTransform affineTransform;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: {
                affineTransform = this.usedTrans();
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.jj_consume_token(8);
                double d5 = this.expr();
                this.jj_consume_token(9);
                affineTransform = AffineTransform.getRotateInstance(d5 / 180.0 * Math.PI);
                break;
            }
            case 24: {
                double d6;
                this.jj_consume_token(24);
                this.jj_consume_token(8);
                double d7 = this.expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: {
                        this.jj_consume_token(9);
                        d6 = d7;
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        d6 = this.expr();
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                affineTransform = AffineTransform.getScaleInstance(d7, d6);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(8);
                double d8 = this.expr();
                this.jj_consume_token(18);
                double d9 = this.expr();
                this.jj_consume_token(9);
                affineTransform = AffineTransform.getTranslateInstance(d8, d9);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                this.jj_consume_token(8);
                double d10 = this.expr();
                this.jj_consume_token(18);
                double d11 = this.expr();
                this.jj_consume_token(18);
                double d12 = this.expr();
                this.jj_consume_token(18);
                double d13 = this.expr();
                this.jj_consume_token(9);
                affineTransform = new AffineTransform(d10, d12, d11, d13, 0.0, 0.0);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                this.jj_consume_token(8);
                this.jj_consume_token(8);
                double d14 = this.expr();
                this.jj_consume_token(18);
                double d15 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(17);
                this.jj_consume_token(8);
                double d16 = this.expr();
                this.jj_consume_token(18);
                double d17 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(18);
                this.jj_consume_token(8);
                double d18 = this.expr();
                this.jj_consume_token(18);
                double d19 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(17);
                this.jj_consume_token(8);
                double d20 = this.expr();
                this.jj_consume_token(18);
                double d21 = this.expr();
                this.jj_consume_token(9);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        this.jj_consume_token(8);
                        d = this.expr();
                        this.jj_consume_token(18);
                        d2 = this.expr();
                        this.jj_consume_token(9);
                        this.jj_consume_token(17);
                        this.jj_consume_token(8);
                        d3 = this.expr();
                        this.jj_consume_token(18);
                        d4 = this.expr();
                        this.jj_consume_token(9);
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                this.jj_consume_token(9);
                affineTransform = this.affineMapping(d14, d15, d16, d17, d18, d19, d20, d21, d, d2, d3, d4);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                this.jj_consume_token(8);
                this.jj_consume_token(8);
                double d22 = this.expr();
                this.jj_consume_token(18);
                double d23 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(17);
                this.jj_consume_token(8);
                double d24 = this.expr();
                this.jj_consume_token(18);
                double d25 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(18);
                this.jj_consume_token(8);
                double d26 = this.expr();
                this.jj_consume_token(18);
                double d27 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(17);
                this.jj_consume_token(8);
                double d28 = this.expr();
                this.jj_consume_token(18);
                double d29 = this.expr();
                this.jj_consume_token(9);
                this.jj_consume_token(9);
                affineTransform = this.similarity(d22, d23, d24, d25, d26, d27, d28, d29);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return affineTransform;
    }

    public final Object[] operation() throws ParseException {
        Vector vector = new Vector();
        this.jj_consume_token(14);
        this.token_source.SwitchTo(3);
        if (this.token_source.getNextToken().kind != 71) {
            this.opComponents(vector);
        }
        return vector.toArray();
    }

    public final void opComponents(Vector vector) throws ParseException {
        String string = this.names.nameOrNull();
        if (string != null) {
            AffineTransform affineTransform = (AffineTransform)this.transTable.get(string);
            if (affineTransform == null) {
                throw new ParseException("undefined transformation " + string);
            }
            vector.add(affineTransform);
        } else {
            collage collage2 = new collage();
            this.collageUnion(collage2);
            vector.add(collage2);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.opComponents(vector);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void shuffle(Vector vector) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 70: {
                this.jj_consume_token(70);
                vector.add(new Integer(-1));
                break;
            }
            case 7: {
                Token token = this.jj_consume_token(7);
                try {
                    int n = Integer.parseInt(token.image);
                    if (n <= 0) {
                        throw new ParseException("shuffle count must be positive");
                    }
                    vector.add(new Integer(n));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("shuffle count must be a positive integer");
                }
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.shuffle(vector);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
    }

    public final AffineTransform usedTrans() throws ParseException {
        this.jj_consume_token(49);
        this.jj_consume_token(8);
        AffineTransform affineTransform = this.transByName();
        this.jj_consume_token(9);
        return affineTransform;
    }

    public final AffineTransform transByName() throws ParseException {
        String string = this.names.name();
        Object v = this.transTable.get(string);
        if (v == null) {
            throw new ParseException("Transformation '" + string + "' undefined");
        }
        return (AffineTransform)((AffineTransform)v).clone();
    }

    public final colourOperation colByName() throws ParseException {
        String string = this.names.name();
        Object v = this.colOpTable.get(string);
        if (v == null) {
            throw new ParseException("Colour operation '" + string + "' undefined");
        }
        return (colourOperation)v;
    }

    public final colourOperation colourOperation() throws ParseException {
        colourOperation colourOperation2 = new colourOperation(this.attribs.size());
        this.jj_consume_token(46);
        this.jj_consume_token(8);
        this.linearCombinations(colourOperation2, new BitSet(this.attribs.size()));
        this.jj_consume_token(9);
        return colourOperation2;
    }

    public final void linearCombinations(colourOperation colourOperation2, BitSet bitSet) throws ParseException {
        boolean bl = false;
        int n = this.attribute();
        if (bitSet.get(n)) {
            throw new ParseException("Attribute " + this.attribs.elementAt(n) + " is assigned two values in colour operation");
        }
        bitSet.set(n);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(16);
                colourOperation.rightHandSide rightHandSide2 = this.attributeExpression();
                colourOperation2.setRhs(n, rightHandSide2);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        bl = true;
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                    }
                }
                float f = this.opParam();
                this.jj_consume_token(19);
                float f2 = this.opParam();
                colourOperation2.setRhs(n, new colourOperation.rightHandSide(n, f, f2, bl));
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                this.linearCombinations(colourOperation2, bitSet);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
    }

    public final float opParam() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 48: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 63: 
            case 64: 
            case 65: 
            case 83: {
                float f = this.exprf();
                if (f < 0.0f || f > 1.0f) {
                    throw new ParseException("Invalid attribute modification in colour operation.\nNumbers must be in the interval [0,1]");
                }
                return f;
            }
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(8);
                float f = this.attribute();
                this.jj_consume_token(9);
                return -(f + 1.0f);
            }
        }
        this.jj_la1[40] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final colourOperation.rightHandSide attributeExpression() throws ParseException {
        colourOperation.rightHandSide rightHandSide2;
        block8: {
            rightHandSide2 = this.aeTerm();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: 
                    case 83: {
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        this.jj_consume_token(82);
                        rightHandSide2 = new colourOperation.rightHandSide(4, rightHandSide2, this.aeTerm());
                        continue block7;
                    }
                    case 83: {
                        this.jj_consume_token(83);
                        rightHandSide2 = new colourOperation.rightHandSide(6, rightHandSide2, this.aeTerm());
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[42] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return rightHandSide2;
    }

    public final colourOperation.rightHandSide aeTerm() throws ParseException {
        colourOperation.rightHandSide rightHandSide2;
        block8: {
            rightHandSide2 = this.aeFactor();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 84: 
                    case 85: {
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 84: {
                        this.jj_consume_token(84);
                        rightHandSide2 = new colourOperation.rightHandSide(3, rightHandSide2, this.aeFactor());
                        continue block7;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        rightHandSide2 = new colourOperation.rightHandSide(5, rightHandSide2, this.aeFactor());
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[44] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return rightHandSide2;
    }

    public final colourOperation.rightHandSide aeFactor() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                this.jj_consume_token(83);
                return new colourOperation.rightHandSide(7, this.aeFactor());
            }
            case 48: {
                double d = this.constant();
                return new colourOperation.rightHandSide(d);
            }
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(8);
                int n = this.attribute();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(n);
            }
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide2 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(14, rightHandSide2);
            }
            case 63: {
                this.jj_consume_token(63);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide3 = this.attributeExpression();
                this.jj_consume_token(18);
                colourOperation.rightHandSide rightHandSide4 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(15, rightHandSide3, rightHandSide4);
            }
            case 64: {
                this.jj_consume_token(64);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide5 = this.attributeExpression();
                this.jj_consume_token(18);
                colourOperation.rightHandSide rightHandSide6 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(16, rightHandSide5, rightHandSide6);
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide7 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(8, rightHandSide7);
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide8 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(9, rightHandSide8);
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide9 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(10, rightHandSide9);
            }
            case 56: {
                this.jj_consume_token(56);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide10 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(11, rightHandSide10);
            }
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide11 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(13, rightHandSide11);
            }
            case 58: {
                this.jj_consume_token(58);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide12 = this.attributeExpression();
                this.jj_consume_token(18);
                colourOperation.rightHandSide rightHandSide13 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(12, rightHandSide12, rightHandSide13);
            }
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide14 = this.attributeExpression();
                this.jj_consume_token(18);
                colourOperation.rightHandSide rightHandSide15 = this.attributeExpression();
                this.jj_consume_token(18);
                colourOperation.rightHandSide rightHandSide16 = this.attributeExpression();
                this.jj_consume_token(9);
                return new colourOperation.rightHandSide(17, rightHandSide14, rightHandSide15, rightHandSide16);
            }
            case 59: {
                this.jj_consume_token(59);
                return new colourOperation.rightHandSide(Math.E);
            }
            case 7: {
                this.token = this.jj_consume_token(7);
                try {
                    return new colourOperation.rightHandSide(Double.parseDouble(this.token.image));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(this.token.image + " not a valid number");
                }
            }
            case 8: {
                this.jj_consume_token(8);
                colourOperation.rightHandSide rightHandSide17 = this.attributeExpression();
                this.jj_consume_token(9);
                return rightHandSide17;
            }
        }
        this.jj_la1[45] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double expr() throws ParseException {
        double d;
        block8: {
            d = this.term();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: 
                    case 83: {
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 82: {
                        this.jj_consume_token(82);
                        d += this.term();
                        continue block7;
                    }
                    case 83: {
                        this.jj_consume_token(83);
                        d -= this.term();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[47] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return d;
    }

    public final float exprf() throws ParseException {
        double d = this.expr();
        return (float)d;
    }

    public final double term() throws ParseException {
        double d;
        block8: {
            d = this.factor();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 84: 
                    case 85: {
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 84: {
                        this.jj_consume_token(84);
                        d *= this.factor();
                        continue block7;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        d /= this.factor();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[49] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return d;
    }

    public final double factor() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                this.jj_consume_token(83);
                return -this.factor();
            }
            case 48: {
                double d = this.constant();
                return d;
            }
            case 53: {
                this.jj_consume_token(53);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return Math.sin(Math.PI * d / 180.0);
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return Math.cos(Math.PI * d / 180.0);
            }
            case 55: {
                this.jj_consume_token(55);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return Math.tan(Math.PI * d / 180.0);
            }
            case 56: {
                this.jj_consume_token(56);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return Math.sqrt(d);
            }
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return Math.log(d);
            }
            case 58: {
                this.jj_consume_token(58);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(18);
                double d2 = this.expr();
                this.jj_consume_token(9);
                return Math.pow(d, d2);
            }
            case 63: {
                this.jj_consume_token(63);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(18);
                double d3 = this.expr();
                this.jj_consume_token(9);
                return Math.min(d, d3);
            }
            case 64: {
                this.jj_consume_token(64);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(18);
                double d4 = this.expr();
                this.jj_consume_token(9);
                return Math.max(d, d4);
            }
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(18);
                double d5 = this.expr();
                this.jj_consume_token(18);
                double d6 = this.expr();
                this.jj_consume_token(9);
                return d < 0.0 ? d5 : d6;
            }
            case 59: {
                this.jj_consume_token(59);
                return Math.E;
            }
            case 7: {
                this.token = this.jj_consume_token(7);
                try {
                    return Double.parseDouble(this.token.image);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(this.token.image + " not a valid number");
                }
            }
            case 8: {
                this.jj_consume_token(8);
                double d = this.expr();
                this.jj_consume_token(9);
                return d;
            }
        }
        this.jj_la1[50] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double constant() throws ParseException {
        this.jj_consume_token(48);
        String string = this.names.name();
        Object v = this.constTable.get(string);
        if (v == null) {
            throw new ParseException("constant " + string + " undefined");
        }
        return (Double)v;
    }

    public final int attribute() throws ParseException {
        String string = this.names.name();
        int n = this.attribs.indexOf(string);
        if (n == -1) {
            throw new ParseException("Undefined attribute " + string);
        }
        return n;
    }

    public final String str() throws ParseException {
        Token token = this.jj_consume_token(6);
        return token.image.substring(1, token.image.length() - 1);
    }

    public collageAlgebraParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new collageAlgebraParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public collageAlgebraParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new collageAlgebraParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public collageAlgebraParser(collageAlgebraParserTokenManager collageAlgebraParserTokenManager2) {
        this.token_source = collageAlgebraParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(collageAlgebraParserTokenManager collageAlgebraParserTokenManager2) {
        this.token_source = collageAlgebraParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 51; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[86];
        for (n2 = 0; n2 < 86; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 51; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((this.jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((this.jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 86; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, collageAlgebraParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

