/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import java.io.InputStream;
import java.io.Reader;
import java.util.BitSet;
import java.util.Vector;
import parsers.ASCII_CharStream;
import parsers.ParseException;
import parsers.Token;
import parsers.nameParser;
import parsers.tdTransducerParserConstants;
import parsers.tdTransducerParserTokenManager;
import parsers.trsParser;
import terms.finiteSignature;
import terms.fixedRankSignature;
import terms.symbol;
import terms.term;
import terms.variable;

public class tdTransducerParser
implements tdTransducerParserConstants {
    private ASCII_CharStream inputStream = null;
    protected rulesParser rules;
    public term[][] rule = new term[0][];
    public double[] weight = new double[0];
    public fixedRankSignature states;
    public finiteSignature in;
    public finiteSignature out;
    public symbol initial;
    public tdTransducerParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private final int[] jj_la1_0 = new int[0];
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public tdTransducerParser(ASCII_CharStream aSCII_CharStream) {
        this(new tdTransducerParserTokenManager(aSCII_CharStream));
        this.rules = new rulesParser(aSCII_CharStream);
        this.inputStream = aSCII_CharStream;
    }

    protected void verifyRule(term term2, term term3) throws ParseException {
        BitSet bitSet = new BitSet();
        if (!this.getVariables(term2, bitSet)) {
            throw new ParseException("Rule not left-linear");
        }
        this.verifyVariables(term3, bitSet);
        this.verifyLhs(term2);
        this.verifyRhs(term3);
    }

    private boolean getVariables(term term2, BitSet bitSet) {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable) {
            if (bitSet.get(((variable)symbol2).index())) {
                return false;
            }
            bitSet.set(((variable)symbol2).index());
            return true;
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            if (this.getVariables(term2.subterm(i), bitSet)) continue;
            return false;
        }
        return true;
    }

    private void verifyVariables(term term2, BitSet bitSet) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (symbol2 instanceof variable && !bitSet.get(((variable)symbol2).index())) {
            throw new ParseException("Variable " + symbol2.toString() + " appears in rhs but not in lhs");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            this.verifyVariables(term2.subterm(i), bitSet);
        }
    }

    private void verifyLhs(term term2) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (!this.states.contains(symbol2)) {
            throw new ParseException("Topmost symbol " + symbol2 + " of left-hand side not a state");
        }
        symbol2 = (term2 = term2.subterm(0)).topSymbol();
        if (!this.in.contains(symbol2)) {
            throw new ParseException("Symbol " + symbol2 + " of rank " + symbol2.rank() + " in left-hand side not in input signature");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            symbol2 = term2.subterm(i).topSymbol();
            if (symbol2 instanceof variable) continue;
            throw new ParseException("Symbol " + symbol2.toString() + " in left-hand side not a variable");
        }
    }

    private void verifyRhs(term term2) throws ParseException {
        symbol symbol2 = term2.topSymbol();
        if (!this.out.contains(symbol2)) {
            if (this.states.contains(symbol2)) {
                symbol2 = term2.subterm(0).topSymbol();
                if (symbol2 instanceof variable) {
                    return;
                }
                throw new ParseException("Symbol " + symbol2 + " in right-hand side must be a variable");
            }
            throw new ParseException("Symbol " + symbol2 + " of rank " + symbol2.rank() + " in right-hand side is neither an output symbol nor a state");
        }
        for (int i = 0; i < symbol2.rank(); ++i) {
            this.verifyRhs(term2.subterm(i));
        }
    }

    public final void tdTransducer() throws ParseException {
        this.jj_consume_token(6);
        this.in = new finiteSignature();
        this.in.parse(this.inputStream);
        this.jj_consume_token(8);
        this.out = new finiteSignature();
        this.out.parse(this.inputStream);
        this.jj_consume_token(8);
        this.states = new fixedRankSignature(1);
        this.states.parse(this.inputStream);
        if (!this.states.disjointWith(this.in) || !this.states.disjointWith(this.out)) {
            throw new ParseException("set of states must be disjoint with input and output signatures");
        }
        this.jj_consume_token(8);
        this.rules.rules();
        this.jj_consume_token(8);
        nameParser nameParser2 = new nameParser(this.inputStream);
        this.initial = new symbol(nameParser2.name(), 1);
        if (!this.states.contains(this.initial)) {
            throw new ParseException("initial state not an element of the state set");
        }
    }

    public tdTransducerParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new tdTransducerParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public tdTransducerParser(Reader reader) {
        this.jj_input_stream = new ASCII_CharStream(reader, 1, 1);
        this.token_source = new tdTransducerParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public tdTransducerParser(tdTransducerParserTokenManager tdTransducerParserTokenManager2) {
        this.token_source = tdTransducerParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(tdTransducerParserTokenManager tdTransducerParserTokenManager2) {
        this.token_source = tdTransducerParserTokenManager2;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[9];
        for (n2 = 0; n2 < 9; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 0; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((this.jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 9; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, tdTransducerParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private class rulesParser
    extends trsParser {
        public rulesParser(ASCII_CharStream aSCII_CharStream) {
            super(aSCII_CharStream);
        }

        protected void insertRule(term term2, term term3, double d) throws ParseException {
            tdTransducerParser.this.verifyRule(term2, term3);
            term[][] termArray = tdTransducerParser.this.rule;
            tdTransducerParser.this.rule = new term[termArray.length + 1][];
            System.arraycopy(termArray, 0, tdTransducerParser.this.rule, 0, termArray.length);
            tdTransducerParser.this.rule[termArray.length] = new term[2];
            tdTransducerParser.this.rule[termArray.length][0] = term2;
            tdTransducerParser.this.rule[termArray.length][1] = term3;
            double[] dArray = tdTransducerParser.this.weight;
            tdTransducerParser.this.weight = new double[dArray.length + 1];
            System.arraycopy(dArray, 0, tdTransducerParser.this.weight, 0, dArray.length);
            tdTransducerParser.this.weight[dArray.length] = d;
        }
    }
}

