package algebras;

import terms.*;

/** An algebra over strings. Symbols or rank 0 are interpreted
  * as constant strings whereas all symbols of rank greater than 0
  * are viewed as concatenation operations.
  * Since the semantics of symbols is fixed, the <code>parse</code>
  * method is meaningless. It simply does nothing.
  * @see algebra
  * @see symbol
  */
public class stringAlgebra extends algebra {

/** A symbol of rank 0 is considered as a constant string, whereas a symbol of rank
  * <em>n</em>&gt;0 is interpreted as the <em>n</em>-ary concatenation operation
  * (in particular, for <em>n</em> = 1 the identity is obtained).
  */
  protected Object apply(symbol op, Object[] args) {
    if (op.rank() == 0) return op.toString();
    StringBuffer result = new StringBuffer();
    for (int i = 0; i < args.length; i++) {
      if (args[i] instanceof String) result.append((String)args[i]);
      else return null;
    }
    return result.toString();
  }
  
}
