package applications.collages;

import java.awt.geom.*;
import parsers.*;
import terms.*;
import algebras.*;

public class collageAlgebra extends extensibleAlgebra {

  protected Object apply(symbol s, Object[] args) {
    Object o = operationOf(s);
    if (o == null) return null;
    if (o instanceof collage) return ((collage)o).clone();
    if (o instanceof collageOperation) return ((collageOperation)o).apply(args);
    if (o instanceof colourOperation) {
      if (args[0] instanceof collage) {
        ((collage)args[0]).changeColours((colourOperation)o);
        return args[0];
      }
    }
    return null;
  }
    
  protected Object extendBy(symbol s) {
    AffineTransform[] result = new AffineTransform[s.rank()];
    for (int i = 0; i < s.rank(); i++) result[i] = new AffineTransform();
    return new collageOperation(result);
  }

/** Initialize a <code>collageAlgebra</code> by reading its definition from a stream.
  * @see collageAlgebraParser
  * @exception ParseException if an error occurs
  */
  public void parse(ASCII_CharStream stream) throws ParseException {
    collageAlgebraParser parser = new collageAlgebraParser(stream);
    parser.collageAlgebra(this);
  }

}
