package applications.collages;

public class colourOperation {

  private rightHandSide[] rhs;

  public colourOperation(int attribs) {
    rhs = new rightHandSide[attribs];
    for (int i = 0; i < attribs; i++) rhs[i] = new rightHandSide(i);
  }
  
  public void setRhs(int attr, rightHandSide rhs) {
    this.rhs[attr] = rhs;
  }
  
  public void apply(double[] attrValue) {
    double[] in = (double[])attrValue.clone();
    for (int i = 0; i < in.length; i++) attrValue[i] = rhs[i].evaluate(in);
  }
  
  public static double fold(double x) {
    int f = (int)Math.floor(x);
    if (f % 2 == 0) return x - f; else return f + 1 - x;
  }
  
  public static class rightHandSide {
  
    public static final int ATTR_TYPE = 0;
    public static final int FD_TYPE = 1;
    public static final int CONST_TYPE = 2;
    public static final int MULT_TYPE =3;
    public static final int SUM_TYPE = 4;
    public static final int DIV_TYPE = 5;
    public static final int DIFF_TYPE = 6;
    public static final int NEG_TYPE = 7;
    public static final int SIN_TYPE = 8;
    public static final int COS_TYPE = 9;
    public static final int TAN_TYPE = 10;
    public static final int SQRT_TYPE = 11;
    public static final int POWER_TYPE = 12;
    public static final int LN_TYPE = 13;
    public static final int FOLD_TYPE = 14;
    public static final int MIN_TYPE = 15;
    public static final int MAX_TYPE = 16;
    public static final int IFNEG_TYPE = 17;

    private int type;
    private Object[] arg;
    
    public rightHandSide(int attr) {
      type = ATTR_TYPE;
      arg = new Object[1];
      arg[0] = new Integer(attr);
    }
    
    public rightHandSide(int attr, double f, double d, boolean flip) {
      type = FD_TYPE;
      arg = new Object[4];
      arg[0] = new Integer(attr);
      arg[1] = new Double(f);
      arg[2] = new Double(d);
      arg[3] = new Boolean(flip);
    }
    
    public rightHandSide(double c) {
      type = CONST_TYPE;
      arg = new Object[1];
      arg[0] = new Double(c);
    }
    
    public rightHandSide(int type, rightHandSide arg) {
      this.type = type;
      this.arg = new Object[1];
      this.arg[0] = arg;
    }
    
    public rightHandSide(int type, rightHandSide arg1, rightHandSide arg2) {
      this.type = type;
      arg = new Object[2];
      arg[0] = arg1;
      arg[1] = arg2;
    }
    
    public rightHandSide(int type, rightHandSide arg1, rightHandSide arg2, rightHandSide arg3) {
      this.type = type;
      arg = new Object[3];
      arg[0] = arg1;
      arg[1] = arg2;
      arg[2] = arg3;
    }

    private double evaluate(double[] attrValues) {
      switch (type) {
        case ATTR_TYPE:
          return attrValues[((Integer)arg[0]).intValue()];
        case FD_TYPE:
          double x = attrValues[((Integer)arg[0]).intValue()];
          double f = ((Double)arg[1]).doubleValue(); if (f < 0) f = attrValues[-(int)f - 1];
          double d = ((Double)arg[2]).doubleValue(); if (d < 0) d = attrValues[-(int)d - 1];
          if (((Boolean)arg[3]).booleanValue()) x = 1-x;
          return x + f*(d-x);
        case CONST_TYPE:
          return ((Double)arg[0]).doubleValue();
        case MULT_TYPE:
          return ((rightHandSide)arg[0]).evaluate(attrValues) * ((rightHandSide)arg[1]).evaluate(attrValues);
        case SUM_TYPE:
          return ((rightHandSide)arg[0]).evaluate(attrValues) + ((rightHandSide)arg[1]).evaluate(attrValues);
        case DIV_TYPE:
          return ((rightHandSide)arg[0]).evaluate(attrValues) / ((rightHandSide)arg[1]).evaluate(attrValues);
        case DIFF_TYPE:
          return ((rightHandSide)arg[0]).evaluate(attrValues) - ((rightHandSide)arg[1]).evaluate(attrValues);
        case NEG_TYPE:
          return -((rightHandSide)arg[0]).evaluate(attrValues);
        case SIN_TYPE:
          return Math.sin(Math.PI*((rightHandSide)arg[0]).evaluate(attrValues)/180.0);
        case COS_TYPE:
          return Math.cos(Math.PI*((rightHandSide)arg[0]).evaluate(attrValues)/180.0);
        case TAN_TYPE:
          return Math.tan(Math.PI*((rightHandSide)arg[0]).evaluate(attrValues)/180.0);
        case SQRT_TYPE:
          return Math.sqrt(((rightHandSide)arg[0]).evaluate(attrValues));
        case POWER_TYPE:
          return Math.pow(((rightHandSide)arg[0]).evaluate(attrValues),((rightHandSide)arg[1]).evaluate(attrValues));
        case MIN_TYPE:
          return Math.min(((rightHandSide)arg[0]).evaluate(attrValues),((rightHandSide)arg[1]).evaluate(attrValues));
        case MAX_TYPE:
          return Math.max(((rightHandSide)arg[0]).evaluate(attrValues),((rightHandSide)arg[1]).evaluate(attrValues));
        case LN_TYPE:
          return Math.log(((rightHandSide)arg[0]).evaluate(attrValues));
        case IFNEG_TYPE:
          return ((rightHandSide)arg[0]).evaluate(attrValues) < 0 ?
                   ((rightHandSide)arg[1]).evaluate(attrValues) :
                   ((rightHandSide)arg[2]).evaluate(attrValues);
        case FOLD_TYPE:
          return fold(((rightHandSide)arg[0]).evaluate(attrValues));
        default:
          throw new RuntimeException("unknown case " + type + " in evaluation of attribute values");
      }
    }

  }
  
}
