package applications.lineDrawings;

import terms.*;
import parsers.*;
import java.awt.*;

public class turtleAlgebra extends lineDrawingAlgebra {

  private signature Fs;
  private signature fs;
  private static String hide = "hide";
  private static String encapsulate = "enc";
  private static char plus = '+';
  private static char minus = '-';
  private static String branch = "branch";
  private static String fill = "fill";
  private static int rotOp = 0;
  private static int branchOp = 1;
  private static int fillOp = 2;
  private double angle = Math.PI/2;
  private double Fx, Fy;

  protected Object apply(symbol op, Object[] args) {
    if (Fs.contains(op)) return new lineDrawing(new line(0, 0, Fx, Fy));
    if (fs.contains(op)) {
      line l = new line(0, 0, Fx, Fy);
      l.hidden = true;
      lineDrawing result = new lineDrawing(l);
      return result;
    }
    lineDrawing result = (lineDrawing)super.apply(op, args);
    if (hide.equals(op.toString())) result.hideLines();
    else if (encapsulate.equals(op.toString())) {
      result.setEndpoint(0,0);
      result = new lineDrawing(result, lineDrawing.branch, null);
    }
    else {
      Object o = operationOf(op);
      if (o instanceof operation) {
        operation oper = (operation)o;
        if (oper.type == rotOp || oper.type == branchOp) {
          if (oper.angle != 0) result.rotate(oper.angle);
          if (oper.type == branchOp) {
            result.setEndpoint(0,0);
            result = new lineDrawing(result, lineDrawing.branch, null);
          }
        }
        else result = new lineDrawing(result, lineDrawing.filledPolygon, new Color(oper.r, oper.g, oper.b));
      }
    }
    return result;
  }
  
  protected Object extendBy(symbol s) {
    Object o = super.extendBy(s);
    if (o != null) return o;
    String name = s.toString();
    if (name.startsWith(encapsulate))
      name = name.substring(encapsulate.length()) + branch;
    if (name.endsWith(branch)) return rotOp(name, true);
    if (name.startsWith(fill)) return fillOp(name);
    else return rotOp(name, false);
  }
  
  private operation rotOp(String name, boolean isBranch) {
    int sign = 1;
    int last = name.length() - 1;
    if (isBranch) last -= branch.length();
    if (last < 0 ||
        name.charAt(last) != plus && name.charAt(last) != minus ) return new operation(0, false);
    if (name.charAt(last) == minus) sign = -1;
    if (last == 0) return new operation(sign * angle, isBranch);
    String num = name.substring(0, last);
    int factor;
    try { factor = Integer.parseInt(num); }
    catch (NumberFormatException e) { return new operation(0, false); }
    if (factor <= 0) return new operation(0, false);
    else return new operation(sign * angle * factor, isBranch);
  }
  
  private operation fillOp(String name) {
    String R,G,B;
    name = name.substring(fill.length());
    int sep = name.indexOf('-');
    if (sep < 0) { R = G = B = name; }
    else {
      R = name.substring(0,sep);
      name = name.substring(sep+1);
      sep = name.indexOf('-');
      if (sep < 0) return new operation(0, false);
      G = name.substring(0,sep);
      B = name.substring(sep+1);
    }
    try {
      float r = Float.valueOf(R).floatValue();
      float g = Float.valueOf(G).floatValue();
      float b = Float.valueOf(B).floatValue();
      if ((r >= 0) && ( r <= 1) &&
          (g >= 0) && ( g <= 1) &&
          (b >= 0) && ( b <= 1)) return new operation(r,g,b);
      else return new operation(0, false);
    }
    catch (NumberFormatException e) { return new operation(0, false); }
  }      
  
  private class operation {
    public double angle;
    public float r, g, b;
    public int type;
    public operation(double angle, boolean isBranch) {
      this.angle = angle;
      this.type = isBranch ? branchOp : rotOp;
    }
    public operation(float r, float g, float b) {
      this.r = r; this.g = g; this.b = b;
      this.type = fillOp;
    }
  }

/** Initialize a <code>turtleAlgebra</code> by reading its definition (= rotation angle) from a stream.
  * @see turtleAlgebraParser
  * @exception ParseException if an error occurs
  */ 
  public void parse(ASCII_CharStream stream) throws ParseException {
    turtleAlgebraParser parser = new turtleAlgebraParser(stream);
    parser.turtleAlgebra();
    angle = parser.angle;
    Fx = Math.cos(parser.Fangle);
    Fy = Math.sin(parser.Fangle);
    Fs = parser.FSynonyms;
    fs = parser.fSynonyms;
  }
  
}
