package displays;

import java.awt.*;
import util.*;

/** A display that consists of a small text-area component and displays arbitrary objects as
  * strings which are obtained by applying the <code>toString()</code> method. Every
  * occurrence of the sub-string \\ is replaced with a newline character.
  */
public class textualDisplay extends display {

  private int fontSize = 18;
  private String fontName;
  private static int fontStyle = Font.BOLD;
  private static String noText = "   < undefined >   ";
  private int rows = 1;
  private int columns = 30;
  private TextArea area 
    = new TextArea("", rows, columns, TextArea.SCROLLBARS_BOTH);
  private static String larger = "larger";
  private static String smaller = "smaller";
  private static String adjustSize = "adjust window size";
  private static String[] fontCommands = { larger, smaller };
  private static String[] windowCommands = { adjustSize };
  
  public textualDisplay() {
    area.setEditable(false);
    area.setBackground(Color.white);
    fontName = "Monospaced"; //area.getFont().getName(); There seems to be no default font!?
    setFontSize();
  }
  
  private void setFontSize() {
    area.setFont(new Font(fontName, fontStyle, fontSize));
  }
  
  private String formatText(String s) {
    StringBuffer result = new StringBuffer(" ");
    int i = 0;
    while (i < s.length()) {
      if (s.charAt(i) == '\n') result.append(" \n ");
      else if (s.charAt(i) == '\\' && i+1 < s.length() && s.charAt(i+1) == '\\') {
        result.append(" \n ");
        i++;
      }
      else result.append(s.charAt(i));
      i++;
    }
    result.append(" ");
    return result.toString();
  }

/** Objects are represented by their string representation. */
  protected void displayObject(Object obj) {
    if (obj != null) {
      int colCounter = columns = 0;
      rows = 1;
      String text = formatText(obj.toString());
      for (int i = 0; i < text.length(); i++) {
        if (text.charAt(i) == '\n') {
          rows++;
          columns = Math.max(columns, colCounter);
          colCounter = 0;
        }
        else colCounter++;
      }
      columns = Math.max(columns, colCounter);
      area.setText(text);
    }
    else {
      area.setText(noText);
      rows = 1;
      columns = noText.length();
    }
  }
  
  public Component visualizer() { return area; }

/** Understands the commands "larger" and "smaller", which affect the font size, and
  * "adjust window size", which adjusts the window size to the dimensions of the currently
  * displayed text.
  */
  public list commands() {
    list result = new list();
    result.append(fontCommands);
    result.append(windowCommands);
    return result;
  }
  
  public void execute(String command) {
    if (adjustSize.equals(command)) {
      area.setRows(rows);
      area.setColumns(columns);
    }
    else {
      if (larger.equals(command) || smaller.equals(command) && fontSize > 1) {
        if (larger.equals(command)) fontSize++;
        else fontSize--;
        setFontSize();
        area.setColumns(area.getColumns());
      }
    }
    Component c = area.getParent();
    while (c != null) {
      if (c instanceof Window) {
        ((Window)c).pack();
        c.repaint();
        break;
      }
      c = c.getParent();
    }
  }
  
}
