package gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.metal.*;
import gui.nodeTypes.*;
import util.*;

public class commandPanel extends Box implements ActionListener {

  /**
	 * 
	 */
  private static final long serialVersionUID = 4041136588066740406L;
  private list currentCommands = new list();
  private worksheetNode notify;
  private JPanel cPanel = new JPanel(new GridLayout(0,1,0,0));
  
  public commandPanel(worksheetNode notify) {
	super(BoxLayout.Y_AXIS);
	setBorder(new EtchedBorder());
	JPanel nameBox = new JPanel(new BorderLayout());
	JLabel name = new JLabel(notify.getName(), JLabel.CENTER);
	name.setBorder(new EtchedBorder());
	nameBox.add(name, BorderLayout.WEST);
	JButton b = new JButton(new MetalIconFactory.PaletteCloseIcon());
	b.addActionListener(this);
	nameBox.add(b, BorderLayout.EAST);
	add(nameBox);
	add(cPanel);
    this.notify = notify;
  }
  
  public void actionPerformed(ActionEvent e) {
    worksheet.tabs.removeTab(this);
  }
  
  public void setCommands(list commands) {
    if (!comp.compare(currentCommands,commands)) {
      currentCommands = (list)commands.clone();
      cPanel.removeAll();
      while (!commands.isEmpty()) {
        Panel row = new Panel();
        row.setLayout(new GridLayout(1, 0));
        cPanel.add(row);
        String[] command = (String[])commands.head();
        for (int i = 0; i < command.length; i++) {
          Button button = new Button(command[i]);
          button.addActionListener(notify);
          row.add(button);
        }
        commands = commands.tail();
      }
      if (worksheet.tabs.isShowing() && worksheet.tabs.isShown(this)) worksheet.tabs.pack();
    }
  }
  
  public void dispose() {
    notify = null;
    worksheet.tabs.removeTab(this);
  }
    
}
