package gui;

import java.applet.*;

public class tbApplet extends Applet {

  /**  This class is used to launch TREEBAG as an applet from within a web browser.
   *   The code makes sure that only one instance of the applet at a time is
   *   active. This is necessary because the instance creates an instance of
   *   the class <code>worksheet</code>, of which there cannot be more than one.
	 */
  public static boolean startedAsApplet = false;
	
  private static final long serialVersionUID = -8420341620699560776L;
  private static Object lock = new Object();
  private static Applet theApplet = null;
  private String path = null;
  private boolean terminated = false;
  private worksheet myWorksheet;
  
  public void start() {
	synchronized (lock) {
      if (theApplet != null) theApplet.stop();
    	  theApplet = this;
    	  startedAsApplet = true;
      String url = getDocumentBase().getPath().toString();
      path = url.substring(0,url.lastIndexOf('/')+1);
      String file = getParameter("file");
      if (file == null) myWorksheet = new worksheet(this, null);
      else {
        myWorksheet = new worksheet(this, file);
      }
    }
  }
  
  public void destroy() {
    synchronized (lock)
    {
    	  if (!terminated && myWorksheet != null) myWorksheet.dispose();
      terminated = true;
    }
  }
  
  public void stop() {
    destroy();
  }
  
  public String absolutePath(String name) {
    synchronized (lock)
    {
    	  return (path + name).replaceAll("%20"," ");
    }
  }
    
}