package gui;

import java.awt.*;

public class textCanvas extends Component {

  /**
	 * 
	 */
  private static final long serialVersionUID = 281753164828405722L;
  private String[] textLines = new String[0];
  
  public textCanvas() {
    setBounds(0,0,0,0);
    setFont(new Font(null));
  }
  
  public void addTextLine(String line) {
    String[] old = textLines;
    textLines = new String[old.length+1];
    System.arraycopy(old, 0, textLines, 0, old.length);
    textLines[old.length] = line;
    updateBounds();
    invalidate();
  }
  
  public void removeTextLines() {
    textLines = new String[0];
    updateBounds();
    invalidate();
  }
  
  private void updateBounds() {
    int width = 0;
    int height = 0;
    FontMetrics fm = getFontMetrics(getFont());
    for (int i = 0; i < textLines.length; i++) {
      width = Math.max(width, fm.stringWidth(textLines[i]));
      height = height + fm.getMaxAscent() + fm.getMaxDescent();
    }
    Rectangle old = getBounds();
    setBounds(old.x + (old.width-width)/2, old.y, width, height);
  }
  
  public void paint(Graphics g) {
    super.paint(g);
    g.setColor(Color.black);
    FontMetrics fm = g.getFontMetrics();
    int ypos = 0;
    for (int i = 0; i < textLines.length; i++) {
      String s = textLines[i];
      g.drawString(s, (getBounds().width - fm.stringWidth(s))/2, ypos += fm.getMaxAscent());
      ypos += fm.getMaxDescent();
    }
  }
  
}
