/* Generated By:JavaCC: Do not edit this line. ET0LTreeGrammarParser.java */
package parsers;

import terms.*;
import java.util.*;
import generators.*;
import util.*;

/** This is the class used to parse ET0L tree grammars.
  * The syntax is <code>(nont, sig, tables, start)</code>, where
  * <code>nont</code>
  * is a set of nonterminal symbols like <code>{A, bla, aa-bb}</code>,
  * <code>sig</code> is a finite signature,
  * <code>tables</code> is the set of sets of rules denoted as usual (e.g.,
  * <code>{A -> f[a, g[B,C]], B -> b, C -> f[b,b], A -> a}</code>), and
  * <code>start</code> is the start nonterminal.
  * Note that there must be some white space between the left-hand side
  * and the arrow because otherwise the "-" will be taken as the
  * last letter of the left-hand side. 
  * @see finiteSignatureParser
  */
public class ET0LTreeGrammarParser implements componentParser, ET0LTreeGrammarParserConstants {

  protected ASCII_CharStream inputStream;
  private rulesParser tableParser;
  private termParser terms;
  private setParser tablesParser;

  public ET0LTreeGrammarParser(ASCII_CharStream input) {
    this(new ET0LTreeGrammarParserTokenManager(input));
    tableParser = new rulesParser(input);
    tablesParser = new setParser(input);
    terms = new termParser(input);
    inputStream = input;
  }

  private Vector rules;
  private int tableNameNo = 0;
  private String tableName;

  public Vector tables = new Vector();
  public Vector tableNames = new Vector();
  public fixedRankSignature nonterminals = new fixedRankSignature(0);
  public finiteSignature sig = new finiteSignature();
  public term axiom;
  public rexp regulation = null;

  private class rulesParser extends trsParser {

    public rulesParser(ASCII_CharStream input) {
      super(input);
    }

    protected void insertRule(term lhs, term rhs, double weight) throws ParseException {
      if (!nonterminals.contains(lhs.topSymbol())) {
        throw new ParseException("Left-hand side `" + lhs.topSymbol() + "' not a nonterminal");
      }
      Object[] rule = new Object[3];
      rule[0] = mkLHS(lhs);
      rule[1] = mkRHS(rhs);
      rule[2] = new Double(weight);
      rules.addElement(rule);
    }

    public term mkLHS(term t) {
      symbol s = new variable(1);
      term aux = new term(s);
      s = new symbol(tableName, 1);
      term result = new term(s);
      result.defineSubterm(0, aux);
      aux = result;
      s = new symbol(t.topSymbol().toString(), 1);
      result = new term(s);
      result.defineSubterm(0, aux);
      return result;
    }

    public term mkRHS(term t) throws ParseException {
      symbol top = t.topSymbol();
      if (nonterminals.contains(top)) {
        t.relabel(new symbol(top.toString(),1));
        t.defineSubterm(0, new term(new variable(1)));
      }
      else if (sig.contains(top)) {
        for (int i = 0; i < top.rank(); i++) mkRHS(t.subterm(i));
      }
      else if (top.rank() > 0) {
        throw new ParseException("signature contains no symbol " + top + " of rank " + top.rank());
      }
      else {
        throw new ParseException("symbol " + top +
                                           " of rank zero neither in signature nor among the nonterminals");
      }
      return t;
    }

  }

  public void component() throws ParseException {
    while (true) {
      tableName = "t" + ++tableNameNo;
      if (!nonterminals.contains(new symbol(tableName,0)) &&
          !sig.contains(new symbol(tableName,1))) break;
    }
    tableNames.addElement(tableName);
    rules = new Vector();
    tables.addElement(rules);
    tableParser.rules();
  }

/** Parse an ET0L tree grammar, where the syntax is as defined above.
  * @exception ParseException if an error occurs
  */
  final public void ET0LTreeGrammar() throws ParseException {
    jj_consume_token(LEFT_PAR);
    nonterminals.parse(inputStream);
    jj_consume_token(COMMA);
    sig.parse(inputStream);
    jj_consume_token(COMMA);
    tablesParser.set(this);
    jj_consume_token(COMMA);
    axiom = tableParser.mkRHS(terms.term());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      regulation = rexp();
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    jj_consume_token(RIGHT_PAR);
  }

  final public rexp rexp() throws ParseException {
  Token t;
  rexp r1, r2;
    r1 = rexp1();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      r2 = rexp();
                          {if (true) return rexp.union(r1, r2);}
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    {if (true) return r1;}
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp1() throws ParseException {
  Token t;
  rexp r1, r2;
    r1 = rexp2();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_PAR:
    case LEFT_BRACKET:
    case NAT:
      r2 = rexp1();
                   {if (true) return rexp.conc(r1, r2);}
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    {if (true) return r1;}
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp2() throws ParseException {
  Token t;
  rexp r;
    r = rexp3();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STAR:
      jj_consume_token(STAR);
             {if (true) return rexp.star(r);}
      break;
    case PLUS:
      jj_consume_token(PLUS);
             {if (true) return rexp.plus(r);}
      break;
    default:
      jj_la1[3] = jj_gen;
      {if (true) return r;}
    }
    throw new Error("Missing return statement in function");
  }

  final public rexp rexp3() throws ParseException {
  Token t;
  rexp r;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NAT:
      t = jj_consume_token(NAT);
    int n=0;
    try { n = Integer.parseInt(t.image); }
    catch (NumberFormatException e) { }
    if (n > tables.size()) {
      {if (true) throw new ParseException("undefined table `" + n + "' in regulating expression");}
    }
    {if (true) return rexp.num(n);}
      break;
    case LEFT_PAR:
      jj_consume_token(LEFT_PAR);
      r = rexp();
      jj_consume_token(RIGHT_PAR);
                                      {if (true) return r;}
      break;
    case LEFT_BRACKET:
      jj_consume_token(LEFT_BRACKET);
      r = rexp();
      jj_consume_token(RIGHT_BRACKET);
                                              {if (true) return rexp.opt(r);}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  public ET0LTreeGrammarParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[5];
  final private int[] jj_la1_0 = {0x400,0x400,0x2140,0x1800,0x2140,};

  public ET0LTreeGrammarParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ET0LTreeGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public ET0LTreeGrammarParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ET0LTreeGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public ET0LTreeGrammarParser(ET0LTreeGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  public void ReInit(ET0LTreeGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 5; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[14];
    for (int i = 0; i < 14; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 5; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 14; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
