/* Generated By:JavaCC: Do not edit this line. PSDisplayParser.java */
package parsers;

import java.awt.*;
import java.util.*;
import java.io.*;
import gui.*;

public class PSDisplayParser implements PSDisplayParserConstants {

  private static char numberSymbol = '#';
  private static char pathSeparator = '/';

  public StringBuffer dirName = new StringBuffer();
  public StringBuffer[] fileName;
  public double lineWidth;
  public Color background = null;

  public PSDisplayParser(ASCII_CharStream input) {
    this(new PSDisplayParserTokenManager(input));
  }

/** Parse a display that allows to write a PostScript descriptions of displayed objects onto files.
  * Expects to find either the keyword "disabled" (in which case PostScript output is disabled)
  * or the keyword "pathname", followed by a path name in double quotes (where directory names
  * are separated by "/"), followed by a comma, followed by the keyword "filename" and a file name.
  * Every occurrence of the character "#" in the file name is replaced with the numbers 1, 2, ...
  * as the display receives its input terms, so that every object may be written to a separate file.
  * Both the path and the file names must be non-empty strings.
  * @exception ParseException if an error occurs
  */
  final public boolean initialize() throws ParseException {
  Token path, file;
  File dir;
  double r,g,b;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BGKEY:
      jj_consume_token(BGKEY);
      r = rat2();
      jj_consume_token(COMMA);
      g = rat2();
      jj_consume_token(COMMA);
      b = rat2();
       background = new Color((float)r,(float)g,(float)b);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PS:
      jj_consume_token(PS);
      jj_consume_token(DISABLED);
                    {if (true) return false;}
      break;
    case PATHKEY:
      jj_consume_token(PATHKEY);
      path = jj_consume_token(NAME);
      jj_consume_token(COMMA);
      jj_consume_token(FILEKEY);
      file = jj_consume_token(NAME);
    lineWidth = 0;
    for (int i = 1; i < path.image.length()-1; i++) {
      if (path.image.charAt(i) == pathSeparator) dirName.append(File.separatorChar);
      else dirName.append(path.image.charAt(i));
    }
    dir = new File(dirName.toString());
    Vector parts = new Vector();
    StringBuffer current = new StringBuffer();
    parts.addElement(current);
    for (int i = 1; i < file.image.length()-1; i++) {
      if (file.image.charAt(i) == numberSymbol) {
        current = new StringBuffer();
        parts.addElement(current);
      }
      else current.append(file.image.charAt(i));
    }
    fileName = new StringBuffer[parts.size()];
    for (int i = 0; i < parts.size(); i++) fileName[i] = (StringBuffer)parts.elementAt(i);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(LWKEY);
        lineWidth = rat();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case pt:
          jj_consume_token(pt);
          break;
        case cm:
          jj_consume_token(cm);
             lineWidth *= 72.0/2.54;
          break;
        case mm:
          jj_consume_token(mm);
             lineWidth *= 72.0/25.4;
          break;
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[2] = jj_gen;
        ;
      }
    if (tbApplet.startedAsApplet) {if (true) return false;}
    dir.mkdirs();
    if (!dir.isDirectory()) {
      errorDisplay.show("Could not create directory " + dir + ".\nPostScript output disabled.");
      {if (true) return false;}
    }
    {if (true) return true;}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public double rat() throws ParseException {
  Token r;
    r = jj_consume_token(RAT);
    Double d;
    try { d = new Double(r.image); }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException(r.image + " is not a valid number");}
      d = new Double(0);
    }
    {if (true) return d.doubleValue();}
    throw new Error("Missing return statement in function");
  }

  final public double rat2() throws ParseException {
  double d;
    d = rat();
    if (d<0 || d>1) {
      {if (true) throw new ParseException(d + " out of range; should be in [0,1]");}
      d=0;
    }
    {if (true) return d;}
    throw new Error("Missing return statement in function");
  }

  public PSDisplayParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[4];
  final private int[] jj_la1_0 = {0x800,0x38000,0x2000,0x140,};

  public PSDisplayParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new PSDisplayParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public PSDisplayParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new PSDisplayParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public PSDisplayParser(PSDisplayParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  public void ReInit(PSDisplayParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 4; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[18];
    for (int i = 0; i < 18; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 4; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 18; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
