/* Generated By:JavaCC: Do not edit this line. collageAlgebraParser.java */
package parsers;

import java.util.*;
import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import applications.collages.*;
import applications.collages.colourOperation.rightHandSide;
import terms.*;
import util.*;

public class collageAlgebraParser implements collageAlgebraParserConstants {

  private nameParser names;
  private Hashtable transTable = new Hashtable();
  private Hashtable constTable = new Hashtable();
  private Hashtable colTable = new Hashtable();
  private Hashtable colOpTable = new Hashtable();
  private ASCII_CharStream inputStream = null;
  private collageAlgebra result;
  private Vector attribs = new Vector();
  private boolean attribsDefined = false;

  // Used as global variables by segments(...):
  float firstCx, firstCy, firstPx, firstPy, lx, ly, rx, ry, px, py;
  boolean close;

  public collageAlgebraParser(ASCII_CharStream input) {
    this(new collageAlgebraParserTokenManager(input));
    names = new nameParser(input);
    inputStream = input;
  }

  private AffineTransform linearMapping(double a, double b, double a2, double b2,
                               double c, double d, double c2, double d2)
  throws ParseException {
    double[][] eqSys = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}};
    eqSys[0][0] = eqSys[1][2] = a;
    eqSys[0][1] = eqSys[1][3] = b;
    eqSys[2][0] = eqSys[3][2] = c;
    eqSys[2][1] = eqSys[3][3] = d;
    eqSys[0][4] = a2; eqSys[1][4] = b2; eqSys[2][4] = c2; eqSys[3][4] = d2;
    if (eqSys[0][0] == 0) {
      swap(eqSys, 0, 2);
      swap(eqSys, 1, 3);
    }
    double det = eqSys[0][0]*eqSys[2][1] - eqSys[0][1]*eqSys[2][0];
    if (det == 0) throw
      new ParseException("vectors (" + a + ", " + b + ") and (" + c + ", " + d + ") linearly dependent");
    double m12 = (eqSys[0][0] * eqSys[2][4] - eqSys[2][0] * eqSys[0][4]) / det;
    double m11 = (eqSys[0][4] - eqSys[0][1] * m12)/eqSys[0][0];
    double m22 = (eqSys[0][0] * eqSys[3][4] - eqSys[2][0] * eqSys[1][4]) / det;
    double m21 = (eqSys[1][4] - eqSys[0][1] * m22)/eqSys[0][0];
    return new AffineTransform(m11, m21, m12, m22, 0, 0);
  }

  private static void swap(double[][] matrix, int line1, int line2) {
    double[] help = (double[])matrix[line1].clone();
    matrix[line1] = matrix[line2];
    matrix[line2] = help;
  }

  private AffineTransform affineMapping(double a, double b, double a2, double b2,
                               double c, double d, double c2, double d2,
                               double e, double f, double e2, double f2)
  throws ParseException {
    AffineTransform result = AffineTransform.getTranslateInstance(-e,-f);
    a -= e; b -= f; c -= e; d -= f;
    a2 -= e2; b2 -= f2; c2 -= e2; d2 -= f2;
    try {
      AffineTransform lin = linearMapping(a, b, a2, b2, c, d, c2, d2);
      result.preConcatenate(lin);
    } catch (ParseException exc) { throw new ParseException("vectors linearly dependent"); }
    result.preConcatenate(AffineTransform.getTranslateInstance(e2,f2));
    return result;
  }

  private AffineTransform similarity(double a, double b, double a2, double b2,
                                                             double c, double d, double c2, double d2)
  throws ParseException {
    a -= c; b -= d; a2 -= c2; b2 -= d2;
    double len1 = Math.sqrt(a*a+b*b);
    double len2 = Math.sqrt(a2*a2+b2*b2);
    if (len1 == 0) throw new ParseException("pre-images in definition of similarity must not be identical");
    if (len2 == 0) {
      AffineTransform result = AffineTransform.getScaleInstance(0,0);
      result.preConcatenate(AffineTransform.getTranslateInstance(c2, d2));
      return result;
    }
    AffineTransform result = AffineTransform.getTranslateInstance(-c,-d);
    result.preConcatenate(AffineTransform.getScaleInstance(len2/len1,len2/len1));
    result.preConcatenate(AffineTransform.getRotateInstance(Math.atan2(b2/len2,a2/len2) - Math.atan2(b/len1,a/len1)));
    result.preConcatenate(AffineTransform.getTranslateInstance(c2,d2));
    return result;
  }

  private collage lookup(String name) throws ParseException {
    Object o = colTable.get(name);
    if (o == null) throw new ParseException("Collage '" + name + "' undefined");
    collage c = (collage)o;
    return ((collage)c.clone());
  }

  final public void collageAlgebra(collageAlgebra alg) throws ParseException {
  result = alg;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATTRIBUTES:
      jj_consume_token(ATTRIBUTES);
      attributes();
      attribsDefined = true;
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    if (!attribsDefined) {
      attribs.addElement("r");
      attribs.addElement("g");
      attribs.addElement("b");
    }
    jj_consume_token(LEFT_BRACE);
    token_source.SwitchTo(RIGHT_BRACE_OR_NOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOT_RIGHT_BRACE:
      jj_consume_token(NOT_RIGHT_BRACE);
      definitions();
      jj_consume_token(RIGHT_BRACE);
      break;
    case IS_RIGHT_BRACE:
      jj_consume_token(IS_RIGHT_BRACE);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void attributes() throws ParseException {
  String name;
  boolean linear = false;
    name = names.name();
    if (attribs.contains(name))
      {if (true) throw new ParseException("Attribute name " + name + " declared twice");}
    attribs.addElement(name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      attributes();
      break;
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void definitions() throws ParseException {
    definition();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      definitions();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
  }

  final public void definition() throws ParseException {
  String name;
  collage col = new collage();
  AffineTransform trans;
  Object[] op;
  int[] shuffle;
  Vector shuffleCounts;
  colourOperation cop;
  double d;
    name = names.name();
    jj_consume_token(EQUALS);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      jj_consume_token(CONST);
      jj_consume_token(LEFT_PAR);
      d = expr();
      jj_consume_token(RIGHT_PAR);
      if (constTable.put(name, new Double(d)) != null) {
        {if (true) throw new ParseException("constant " + name + " defined twice");}
      }
      break;
    case LEFT_BRACE:
    case USECONST:
      collageUnion(col);
      if (result.defineSymbol(new symbol(name, 0), col) != null) {
        {if (true) throw new ParseException("constant " + name + " defined twice");}
      }
      colTable.put(name, col);
      break;
    case ROT:
    case SCALE:
    case TRANS:
    case MATRIX:
    case MAP:
    case SIM:
    case USETRANS:
      trans = composedTransformation(new AffineTransform());
      if (transTable.put(name, trans) != null) {
        {if (true) throw new ParseException("transformation " + name + " defined twice");}
      }
      break;
    case LEFT_ANGLE:
      op = operation();
      shuffle = new int[op.length];
      for (int i = 0; i < op.length; i++) shuffle[i] = -1;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHUFFLE:
        jj_consume_token(SHUFFLE);
        jj_consume_token(LEFT_PAR);
        shuffle(shuffleCounts = new Vector());
        jj_consume_token(RIGHT_PAR);
        if (shuffleCounts.size() != op.length) {if (true) throw new ParseException(op.length + " shuffle counts required");}
        for (int i = 0; i < op.length; i++) shuffle[i] = ((Integer)shuffleCounts.get(i)).intValue();
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      int arity = 0;
      for (int i = 0; i < op.length; i++) if (op[i] instanceof AffineTransform) arity++;
      if (result.defineSymbol(new symbol(name, arity), new collageOperation(op,shuffle)) != null) {
        if (arity == 0) {if (true) throw new ParseException("constant " + name + " defined twice");}
        else {if (true) throw new ParseException("operation " + name + " defined twice");}
      }
      break;
    case COP:
      cop = colourOperation();
      if (result.defineSymbol(new symbol(name, 1), cop) != null) {
        {if (true) throw new ParseException("operation " + name + " defined twice");}
      }
      colOpTable.put(name, cop);
      break;
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void collageUnion(collage col) throws ParseException {
  AffineTransform trans = null;
  colourOperation colOp = null;
  collage tmp = new collage();
    collage(tmp);
    token_source.SwitchTo(AFTER_COLLAGE);
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRANSFORMED2:
      case COLOURED2:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRANSFORMED2:
        jj_consume_token(TRANSFORMED2);
        jj_consume_token(BY2);
        trans = transByName();
        if (trans != null) tmp.transform(trans);
        trans = null;
        break;
      case COLOURED2:
        jj_consume_token(COLOURED2);
        jj_consume_token(BY2);
        colOp = colByName();
        if (colOp != null) tmp.changeColours(colOp);
        colOp = null;
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      col.unionWith(tmp);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS_UNION:
      jj_consume_token(IS_UNION);
      collageUnion(col);
      break;
    case NOTHING:
      jj_consume_token(NOTHING);
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void collage(collage col) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_BRACE:
      jj_consume_token(LEFT_BRACE);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING:
      case CURVE:
      case FILLED_CURVE:
      case CLOSED_CURVE:
      case ELLIPSE:
      case FILLED_ELLIPSE:
      case PIE:
      case FILLED_PIE:
      case ARC:
      case CLOSED_ARC:
      case FILLED_ARC:
        parts(col);
        break;
      default:
        jj_la1[9] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_BRACE);
      break;
    case USECONST:
      jj_consume_token(USECONST);
               col.unionWith(lookup(names.name()));
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void parts(collage col) throws ParseException {
  part p;
  AffineTransform trans = null;
  colourOperation colOp = null;
    p = part();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRANSFORMED:
      case COLOURED:
        ;
        break;
      default:
        jj_la1[11] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRANSFORMED:
        jj_consume_token(TRANSFORMED);
        jj_consume_token(BY);
        trans = transByName();
      if (trans != null) p.transform(trans);
      trans = null;
        break;
      case COLOURED:
        jj_consume_token(COLOURED);
        jj_consume_token(BY);
        colOp = colByName();
      if (colOp != null) p.changeColour(colOp);
      colOp = null;
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    col.add(p);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      parts(col);
      break;
    default:
      jj_la1[13] = jj_gen;
      ;
    }
  }

  final public part part() throws ParseException {
  GeneralPath seg = new GeneralPath();
  double x,y,r,rx,ry,alpha,beta;
  float pt;
  part result;
  String s,t;
  String fname = null;
  boolean bold = false;
  boolean italic = false;
  int style = part.FILLED;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CURVE:
      jj_consume_token(CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(false);
                                       result = new part(part.OUTLINE,seg);
      break;
    case CLOSED_CURVE:
      jj_consume_token(CLOSED_CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(true);
                                      result = new part(part.OUTLINE,seg);
      break;
    case FILLED_CURVE:
      jj_consume_token(FILLED_CURVE);
      jj_consume_token(LEFT_PAR);
      seg = segments(true);
                                      result = new part(part.FILLED,seg);
      break;
    case ELLIPSE:
      jj_consume_token(ELLIPSE);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      rx = expr();
      jj_consume_token(COMMA);
      ry = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Ellipse2D.Double(x-rx,y-ry,rx*2.0,ry*2.0)));
      break;
    case FILLED_ELLIPSE:
      jj_consume_token(FILLED_ELLIPSE);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      rx = expr();
      jj_consume_token(COMMA);
      ry = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Ellipse2D.Double(x-rx,y-ry,rx*2.0,ry*2.0)));
      break;
    case PIE:
      jj_consume_token(PIE);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      r = expr();
      jj_consume_token(COMMA);
      alpha = expr();
      jj_consume_token(COMMA);
      beta = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.PIE)));
      break;
    case FILLED_PIE:
      jj_consume_token(FILLED_PIE);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      r = expr();
      jj_consume_token(COMMA);
      alpha = expr();
      jj_consume_token(COMMA);
      beta = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.PIE)));
      break;
    case ARC:
      jj_consume_token(ARC);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      r = expr();
      jj_consume_token(COMMA);
      alpha = expr();
      jj_consume_token(COMMA);
      beta = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.OPEN)));
      break;
    case CLOSED_ARC:
      jj_consume_token(CLOSED_ARC);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      r = expr();
      jj_consume_token(COMMA);
      alpha = expr();
      jj_consume_token(COMMA);
      beta = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.OUTLINE,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.CHORD)));
      break;
    case FILLED_ARC:
      jj_consume_token(FILLED_ARC);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(COMMA);
      r = expr();
      jj_consume_token(COMMA);
      alpha = expr();
      jj_consume_token(COMMA);
      beta = expr();
      jj_consume_token(RIGHT_PAR);
      result = new part(part.FILLED,new GeneralPath(new Arc2D.Double(x-r,y-r,r*2.0,r*2.0,-alpha,-beta,Arc2D.CHORD)));
      break;
    case STRING:
      s = str();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT_BRACKET:
        jj_consume_token(LEFT_BRACKET);
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
          case BOLD:
          case ITALIC:
          case OUTLINED:
            ;
            break;
          default:
            jj_la1[14] = jj_gen;
            break label_3;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRING:
            t = str();
                    if (fname != null && !t.equals(fname)) {if (true) throw new ParseException("Two font names specified");} fname = t;
            break;
          case BOLD:
            jj_consume_token(BOLD);
                 bold = true;
            break;
          case ITALIC:
            jj_consume_token(ITALIC);
                   italic = true;
            break;
          case OUTLINED:
            jj_consume_token(OUTLINED);
                     style = part.OUTLINE;
            break;
          default:
            jj_la1[15] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(RIGHT_BRACKET);
        break;
      default:
        jj_la1[16] = jj_gen;
        ;
      }
      jj_consume_token(SIZE);
      pt = exprf();
      if (Math.rint(Math.abs(pt)) != pt)
        {if (true) throw new ParseException("Point size of font must be a nonnegative integer");}
      jj_consume_token(AT);
      jj_consume_token(LEFT_PAR);
      x = expr();
      jj_consume_token(COMMA);
      y = expr();
      jj_consume_token(RIGHT_PAR);
      int spec = bold ? Font.BOLD : 0;
      if (italic) spec += Font.ITALIC;
      Font f = new Font(fname==null ? "SansSerif" : fname,
                        spec==0 ? Font.PLAIN : spec, Math.round(pt));
      GlyphVector gv = f.createGlyphVector(new FontRenderContext(null,false,true),s);
// For some reason, the following yields the wrong vertical placement on Mac OS X.
//      Rectangle2D b = gv.getVisualBounds();
//      GeneralPath path = new GeneralPath(gv.getOutline((float)(x-b.getCenterX()),-(float)(y+b.getCenterY())));
//      path.transform(new AffineTransform(1,0,0,-1,0,0));
      GeneralPath path = new GeneralPath(gv.getOutline());
      Rectangle2D b = path.getBounds2D();
      path.transform(new AffineTransform(1,0,0,-1,x-b.getCenterX(),y+b.getCenterY()));
      result = new part(style,path);
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT_BRACKET:
    case LEFT_ANGLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT_BRACKET:
        jj_consume_token(LEFT_BRACKET);
        staticColour(result);
        jj_consume_token(RIGHT_BRACKET);
        break;
      case LEFT_ANGLE:
        jj_consume_token(LEFT_ANGLE);
        variableColour(result);
        jj_consume_token(RIGHT_ANGLE);
        break;
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WIDTH:
      jj_consume_token(WIDTH);
      double w = expr();
      if (w < 0) {if (true) throw new ParseException("Negative line width " + w);}
      result.setThickness(w);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public GeneralPath segments(boolean closePath) throws ParseException {
  GeneralPath result = new GeneralPath();
    curvePoint();
    result.moveTo(px,py);
    firstCx = lx;
    firstCy = ly;
    firstPx = px;
    firstPy = py;
    close = closePath;
    tail(result,px,py,rx,ry);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void tail(GeneralPath p, float currx, float curry, float nextCx, float nextCy) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      curvePoint();
    if (lx==0 && ly==0) {
      if (nextCx==0 && nextCy==0) p.lineTo(px,py);
      else p.quadTo(currx+nextCx,curry+nextCy,px,py);
    }
    else p.curveTo(currx+nextCx,curry+nextCy,px+lx,py+ly,px,py);
      tail(p,px,py,rx,ry);
      break;
    case RIGHT_PAR:
      jj_consume_token(RIGHT_PAR);
    if (close) {
      if (firstCx==0 && firstCy==0) {
        if (nextCx==0 && nextCy==0) p.lineTo(firstPx,firstPy);
        else p.quadTo(currx+nextCx,curry+nextCy,firstPx,firstPy);
      }
      else p.curveTo(currx+nextCx,curry+nextCy,firstCx+firstPx,firstCy+firstPy,firstPx,firstPy);
      p.closePath();
    }
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void curvePoint() throws ParseException {
  lx = ly = rx = ry = 0;
    jj_consume_token(LEFT_PAR);
    px = exprf();
    jj_consume_token(COMMA);
    py = exprf();
    jj_consume_token(RIGHT_PAR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LEFT:
    case RIGHT:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LEFT:
        jj_consume_token(LEFT);
        jj_consume_token(LEFT_PAR);
        lx = exprf();
        jj_consume_token(COMMA);
        ly = exprf();
        jj_consume_token(RIGHT_PAR);
      rx = -lx; ry = -ly;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case RIGHT:
          jj_consume_token(RIGHT);
          jj_consume_token(LEFT_PAR);
          rx = exprf();
          jj_consume_token(COMMA);
          ry = exprf();
          jj_consume_token(RIGHT_PAR);
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        break;
      case RIGHT:
        jj_consume_token(RIGHT);
        jj_consume_token(LEFT_PAR);
        rx = exprf();
        jj_consume_token(COMMA);
        ry = exprf();
        jj_consume_token(RIGHT_PAR);
      lx = -rx; ly = -ry;
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LEFT:
          jj_consume_token(LEFT);
          jj_consume_token(LEFT_PAR);
          lx = exprf();
          jj_consume_token(COMMA);
          ly = exprf();
          jj_consume_token(RIGHT_PAR);
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[25] = jj_gen;
      ;
    }
  }

  final public void staticColour(part p) throws ParseException {
  float r,g,b;
    r = exprf();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      g = exprf();
      jj_consume_token(COMMA);
      b = exprf();
      break;
    default:
      jj_la1[26] = jj_gen;
                                                            g=b=r;
    }
    if (r<0 || r>1 || g<0 || g>1 || b<0 || b>1)
      {if (true) throw new ParseException("rgb values must be numbers in the interval [0,1]");}
    p.setColour(r,g,b);
  }

  final public void variableColour(part p) throws ParseException {
    if (attribsDefined) {
      p.initAttribs(attribs.size());
      complexColourDefinition(p);
    }
    else {
      p.initAttribs(3);
      p.setRgb(0,1,2);
      simpleColourDefinition(p);
    }
  }

  final public void complexColourDefinition(part p) throws ParseException {
  int r,g,b;
  String name;
    r = attribute();
    jj_consume_token(COMMA);
    g = attribute();
    jj_consume_token(COMMA);
    b = attribute();
    p.setRgb(r,g,b);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      attributeAssignments(p, new BitSet(attribs.size()));
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
  }

  final public void attributeAssignments(part p, BitSet assigned) throws ParseException {
  String name;
  int attr;
    attr = attribute();
    if ( assigned.get(attr) )
      {if (true) throw new ParseException("Part has two values assigned to an attribute");}
    assigned.set(attr);
    jj_consume_token(EQUALS);
               p.setAttrib(attr,exprf());
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      attributeAssignments(p, assigned);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
  }

  final public void simpleColourDefinition(part p) throws ParseException {
  float r,g,b;
    r = exprf();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      g = exprf();
      jj_consume_token(COMMA);
      b = exprf();
      break;
    default:
      jj_la1[29] = jj_gen;
                                                            g=b=r;
    }
    p.setAttrib(0,r);
    p.setAttrib(1,g);
    p.setAttrib(2,b);
  }

  final public AffineTransform composedTransformation(AffineTransform previous) throws ParseException {
  AffineTransform trans;
    trans = transformation();
    previous.preConcatenate(trans);
    token_source.SwitchTo(COMPOSE_OR_NOT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IS_COMPOSE:
      jj_consume_token(IS_COMPOSE);
      composedTransformation(previous);
      break;
    case NOT_COMPOSE:
      jj_consume_token(NOT_COMPOSE);
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return previous;}
    throw new Error("Missing return statement in function");
  }

  final public AffineTransform transformation() throws ParseException {
  AffineTransform trans;
  double a; double b; double c; double d; double e = 0; double f = 0;
  double a2; double b2; double c2; double d2; double e2 = 0; double f2 = 0;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case USETRANS:
      trans = usedTrans();
      break;
    case ROT:
      jj_consume_token(ROT);
      jj_consume_token(LEFT_PAR);
      a = expr();
      jj_consume_token(RIGHT_PAR);
      trans = AffineTransform.getRotateInstance(a/180.0 * Math.PI);
      break;
    case SCALE:
      jj_consume_token(SCALE);
      jj_consume_token(LEFT_PAR);
      a = expr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case RIGHT_PAR:
        jj_consume_token(RIGHT_PAR);
        b = a;
        break;
      case COMMA:
        jj_consume_token(COMMA);
        b = expr();
        jj_consume_token(RIGHT_PAR);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      trans = AffineTransform.getScaleInstance(a, b);
      break;
    case TRANS:
      jj_consume_token(TRANS);
      jj_consume_token(LEFT_PAR);
      a = expr();
      jj_consume_token(COMMA);
      b = expr();
      jj_consume_token(RIGHT_PAR);
      trans = AffineTransform.getTranslateInstance(a, b);
      break;
    case MATRIX:
      jj_consume_token(MATRIX);
      jj_consume_token(LEFT_PAR);
      a = expr();
      jj_consume_token(COMMA);
      b = expr();
      jj_consume_token(COMMA);
      c = expr();
      jj_consume_token(COMMA);
      d = expr();
      jj_consume_token(RIGHT_PAR);
      trans = new AffineTransform(a, c, b, d, 0, 0);
      break;
    case MAP:
      jj_consume_token(MAP);
      jj_consume_token(LEFT_PAR);
      jj_consume_token(LEFT_PAR);
      a = expr();
      jj_consume_token(COMMA);
      b = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(ARROW);
      jj_consume_token(LEFT_PAR);
      a2 = expr();
      jj_consume_token(COMMA);
      b2 = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(COMMA);
      jj_consume_token(LEFT_PAR);
      c = expr();
      jj_consume_token(COMMA);
      d = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(ARROW);
      jj_consume_token(LEFT_PAR);
      c2 = expr();
      jj_consume_token(COMMA);
      d2 = expr();
      jj_consume_token(RIGHT_PAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        jj_consume_token(COMMA);
        jj_consume_token(LEFT_PAR);
        e = expr();
        jj_consume_token(COMMA);
        f = expr();
        jj_consume_token(RIGHT_PAR);
        jj_consume_token(ARROW);
        jj_consume_token(LEFT_PAR);
        e2 = expr();
        jj_consume_token(COMMA);
        f2 = expr();
        jj_consume_token(RIGHT_PAR);
        break;
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      jj_consume_token(RIGHT_PAR);
      trans = affineMapping(a, b, a2, b2, c, d, c2, d2, e, f, e2, f2);
      break;
    case SIM:
      jj_consume_token(SIM);
      jj_consume_token(LEFT_PAR);
      jj_consume_token(LEFT_PAR);
      a = expr();
      jj_consume_token(COMMA);
      b = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(ARROW);
      jj_consume_token(LEFT_PAR);
      a2 = expr();
      jj_consume_token(COMMA);
      b2 = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(COMMA);
      jj_consume_token(LEFT_PAR);
      c = expr();
      jj_consume_token(COMMA);
      d = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(ARROW);
      jj_consume_token(LEFT_PAR);
      c2 = expr();
      jj_consume_token(COMMA);
      d2 = expr();
      jj_consume_token(RIGHT_PAR);
      jj_consume_token(RIGHT_PAR);
      trans = similarity(a, b, a2, b2, c, d, c2, d2);
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return trans;}
    throw new Error("Missing return statement in function");
  }

  final public Object[] operation() throws ParseException {
  Vector components = new Vector();
    jj_consume_token(LEFT_ANGLE);
    token_source.SwitchTo(RIGHT_ANGLE_OR_NOT);
    if (token_source.getNextToken().kind != IS_RIGHT_ANGLE) opComponents(components);
    {if (true) return components.toArray();}
    throw new Error("Missing return statement in function");
  }

  final public void opComponents(Vector components) throws ParseException {
    String name = names.nameOrNull();
    if (name != null) {
      AffineTransform t = (AffineTransform)transTable.get(name);
      if (t == null) {if (true) throw new ParseException("undefined transformation " + name);}
      components.add(t);
    }
    else {
      collage col = new collage();
      collageUnion(col);
      components.add(col);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      opComponents(components);
      break;
    case RIGHT_ANGLE:
      jj_consume_token(RIGHT_ANGLE);
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void shuffle(Vector result) throws ParseException {
  Token token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALL:
      jj_consume_token(ALL);
            result.add(new Integer(-1));
      break;
    case RAT:
      token = jj_consume_token(RAT);
      try {
        int i = Integer.parseInt(token.image);
        if (i > 0) result.add(new Integer(i));
        else {if (true) throw new ParseException("shuffle count must be positive");}
      }
      catch (NumberFormatException e) {
        {if (true) throw new ParseException("shuffle count must be a positive integer");}
      }
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      shuffle(result);
      break;
    default:
      jj_la1[36] = jj_gen;
      ;
    }
  }

  final public AffineTransform usedTrans() throws ParseException {
  AffineTransform result;
    jj_consume_token(USETRANS);
    jj_consume_token(LEFT_PAR);
    result = transByName();
    jj_consume_token(RIGHT_PAR);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public AffineTransform transByName() throws ParseException {
  AffineTransform result;
    String n = names.name();
    Object o = transTable.get(n);
    if (o == null) {if (true) throw new ParseException("Transformation '" + n + "' undefined");}
    {if (true) return (AffineTransform)((AffineTransform)o).clone();}
    throw new Error("Missing return statement in function");
  }

  final public colourOperation colByName() throws ParseException {
  colourOperation result;
    String n = names.name();
    Object o = colOpTable.get(n);
    if (o == null) {if (true) throw new ParseException("Colour operation '" + n + "' undefined");}
    {if (true) return (colourOperation)o;}
    throw new Error("Missing return statement in function");
  }

  final public colourOperation colourOperation() throws ParseException {
  colourOperation result = new colourOperation(attribs.size());
    jj_consume_token(COP);
    jj_consume_token(LEFT_PAR);
    linearCombinations(result, new BitSet(attribs.size()));
    jj_consume_token(RIGHT_PAR);
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public void linearCombinations(colourOperation result, BitSet assigned) throws ParseException {
  int attr;
  String name;
  float f,d;
  boolean flip = false;
  rightHandSide rhs;
    attr = attribute();
    if ( assigned.get(attr) )
      {if (true) throw new ParseException("Attribute "+attribs.elementAt(attr)+" is assigned two values in colour operation");}
    assigned.set(attr);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      jj_consume_token(EQUALS);
      rhs = attributeExpression();
                                  result.setRhs(attr,rhs);
      break;
    case BAR:
      jj_consume_token(BAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BAR:
        jj_consume_token(BAR);
                flip = true;
        break;
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      f = opParam();
      jj_consume_token(COLON);
      d = opParam();
      result.setRhs(attr,new rightHandSide(attr,f,d,flip));
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      linearCombinations(result, assigned);
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
  }

  final public float opParam() throws ParseException {
  float result;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RAT:
    case LEFT_PAR:
    case USECONST:
    case SIN:
    case COS:
    case TAN:
    case SQRT:
    case LN:
    case POWER:
    case E:
    case MIN:
    case MAX:
    case IFNEG:
    case 83:
      result = exprf();
    if (result < 0 || result > 1)
      {if (true) throw new ParseException("Invalid attribute modification in colour operation.\n"
                             +"Numbers must be in the interval [0,1]");}
    {if (true) return result;}
      break;
    case VAL:
      jj_consume_token(VAL);
      jj_consume_token(LEFT_PAR);
      result = attribute();
      jj_consume_token(RIGHT_PAR);
    {if (true) return -(result+1);}
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public rightHandSide attributeExpression() throws ParseException {
  rightHandSide result;
    result = aeTerm();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 82:
      case 83:
        ;
        break;
      default:
        jj_la1[41] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 82:
        jj_consume_token(82);
      result = new rightHandSide(rightHandSide.SUM_TYPE,result,aeTerm());
        break;
      case 83:
        jj_consume_token(83);
      result = new rightHandSide(rightHandSide.DIFF_TYPE,result,aeTerm());
        break;
      default:
        jj_la1[42] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public rightHandSide aeTerm() throws ParseException {
  rightHandSide result;
    result = aeFactor();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 84:
      case 85:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 84:
        jj_consume_token(84);
      result = new rightHandSide(rightHandSide.MULT_TYPE,result,aeFactor());
        break;
      case 85:
        jj_consume_token(85);
      result = new rightHandSide(rightHandSide.DIV_TYPE,result,aeFactor());
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public rightHandSide aeFactor() throws ParseException {
  rightHandSide result, result2, result3;
  double d;
  int attr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 83:
      jj_consume_token(83);
        {if (true) return new rightHandSide(rightHandSide.NEG_TYPE,aeFactor());}
      break;
    case USECONST:
      d = constant();
                   {if (true) return new rightHandSide(d);}
      break;
    case VAL:
      jj_consume_token(VAL);
      jj_consume_token(LEFT_PAR);
      attr = attribute();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(attr);}
      break;
    case FOLD:
      jj_consume_token(FOLD);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.FOLD_TYPE,result);}
      break;
    case MIN:
      jj_consume_token(MIN);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(COMMA);
      result2 = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.MIN_TYPE,result,result2);}
      break;
    case MAX:
      jj_consume_token(MAX);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(COMMA);
      result2 = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.MAX_TYPE,result,result2);}
      break;
    case SIN:
      jj_consume_token(SIN);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.SIN_TYPE,result);}
      break;
    case COS:
      jj_consume_token(COS);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.COS_TYPE,result);}
      break;
    case TAN:
      jj_consume_token(TAN);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.TAN_TYPE,result);}
      break;
    case SQRT:
      jj_consume_token(SQRT);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.SQRT_TYPE,result);}
      break;
    case LN:
      jj_consume_token(LN);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.LN_TYPE,result);}
      break;
    case POWER:
      jj_consume_token(POWER);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(COMMA);
      result2 = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.POWER_TYPE,result,result2);}
      break;
    case IFNEG:
      jj_consume_token(IFNEG);
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(COMMA);
      result2 = attributeExpression();
      jj_consume_token(COMMA);
      result3 = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return new rightHandSide(rightHandSide.IFNEG_TYPE,result,result2,result3);}
      break;
    case E:
      jj_consume_token(E);
    {if (true) return new rightHandSide(Math.E);}
      break;
    case RAT:
      token = jj_consume_token(RAT);
    try { {if (true) return new rightHandSide(Double.parseDouble(token.image));} }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException(token.image+" not a valid number");}
      {if (true) return null;}
    }
      break;
    case LEFT_PAR:
      jj_consume_token(LEFT_PAR);
      result = attributeExpression();
      jj_consume_token(RIGHT_PAR);
    {if (true) return result;}
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public double expr() throws ParseException {
  double result;
    result = term();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 82:
      case 83:
        ;
        break;
      default:
        jj_la1[46] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 82:
        jj_consume_token(82);
                          result += term();
        break;
      case 83:
        jj_consume_token(83);
                                                      result -= term();
        break;
      default:
        jj_la1[47] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
                                                                               {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public float exprf() throws ParseException {
  double result;
    result = expr();
                    {if (true) return (float)result;}
    throw new Error("Missing return statement in function");
  }

  final public double term() throws ParseException {
  double result;
    result = factor();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 84:
      case 85:
        ;
        break;
      default:
        jj_la1[48] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 84:
        jj_consume_token(84);
          result *= factor();
        break;
      case 85:
        jj_consume_token(85);
                                        result /= factor();
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

  final public double factor() throws ParseException {
  double result, result2, result3;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 83:
      jj_consume_token(83);
        {if (true) return -factor();}
      break;
    case USECONST:
      result = constant();
    {if (true) return result;}
      break;
    case SIN:
      jj_consume_token(SIN);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.sin(Math.PI * result / 180.0);}
      break;
    case COS:
      jj_consume_token(COS);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.cos(Math.PI * result / 180.0);}
      break;
    case TAN:
      jj_consume_token(TAN);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.tan(Math.PI * result / 180.0);}
      break;
    case SQRT:
      jj_consume_token(SQRT);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.sqrt(result);}
      break;
    case LN:
      jj_consume_token(LN);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.log(result);}
      break;
    case POWER:
      jj_consume_token(POWER);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(COMMA);
      result2 = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.pow(result,result2);}
      break;
    case MIN:
      jj_consume_token(MIN);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(COMMA);
      result2 = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.min(result,result2);}
      break;
    case MAX:
      jj_consume_token(MAX);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(COMMA);
      result2 = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return Math.max(result,result2);}
      break;
    case IFNEG:
      jj_consume_token(IFNEG);
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(COMMA);
      result2 = expr();
      jj_consume_token(COMMA);
      result3 = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return result<0 ? result2 : result3;}
      break;
    case E:
      jj_consume_token(E);
    {if (true) return Math.E;}
      break;
    case RAT:
      token = jj_consume_token(RAT);
    try { {if (true) return Double.parseDouble(token.image);} }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException(token.image+" not a valid number");}
      {if (true) return 0;}
    }
      break;
    case LEFT_PAR:
      jj_consume_token(LEFT_PAR);
      result = expr();
      jj_consume_token(RIGHT_PAR);
    {if (true) return result;}
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public double constant() throws ParseException {
    jj_consume_token(USECONST);
    String name = names.name();
    Object d = constTable.get(name);
    if (d == null) {if (true) throw new ParseException("constant " + name + " undefined");}
    {if (true) return ((Double)d).doubleValue();}
    throw new Error("Missing return statement in function");
  }

  final public int attribute() throws ParseException {
    String name = names.name();
    int i = attribs.indexOf(name);
    if ( i==-1 ) {if (true) throw new ParseException("Undefined attribute " + name);}
    {if (true) return i;}
    throw new Error("Missing return statement in function");
  }

  final public String str() throws ParseException {
  Token s;
    s = jj_consume_token(STRING);
    {if (true) return s.image.substring(1,s.image.length()-1);}
    throw new Error("Missing return statement in function");
  }

  public collageAlgebraParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[51];
  final private int[] jj_la1_0 = {0x0,0x0,0x140000,0x40000,0x0,0x1fc04400,0x0,0x0,0x0,0xe0000040,0x400,0x0,0x0,0x40000,0x40,0x40,0x1000,0xe0000040,0x5000,0x5000,0x0,0x40200,0x0,0x0,0x0,0x0,0x40000,0x100000,0x40000,0x40000,0x0,0x40200,0x40000,0x1f800000,0x48000,0x80,0x40000,0x200000,0x280000,0x40000,0x180,0x0,0x0,0x0,0x0,0x180,0x0,0x0,0x0,0x0,0x180,};
  final private int[] jj_la1_1 = {0x0,0x0,0x0,0x0,0x0,0x34000,0x0,0x0,0x0,0x7f,0x10000,0xc0000,0xc0000,0x0,0x3800,0x3800,0x0,0x7f,0x0,0x0,0x8000,0x0,0x100,0x80,0x180,0x180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x8fe10000,0x0,0x0,0x0,0x0,0x8fe10000,0x0,0x0,0x0,0x0,0x8fe10000,};
  final private int[] jj_la1_2 = {0x10,0x30000,0x0,0x0,0x20,0x0,0x3000,0x3000,0x8800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x600,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x80007,0xc0000,0xc0000,0x300000,0x300000,0x8000f,0xc0000,0xc0000,0x300000,0x300000,0x80003,};

  public collageAlgebraParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new collageAlgebraParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  public collageAlgebraParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new collageAlgebraParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  public collageAlgebraParser(collageAlgebraParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  public void ReInit(collageAlgebraParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 51; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[86];
    for (int i = 0; i < 86; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 51; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 86; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
