/* Generated By:JavaCC: Do not edit this line. pdtGrammarParser.java */
package parsers;

import java.util.*;
import terms.*;
import generators.*;

/** This is the class used to parse parallel deterministic tree grammars.
  * The syntax is as for regular tree grammars, except that for every nonterminal symbol
  * there are exactly two rules, denoted as
  * <code>A -></code><em>t1</em><code> | </code><em>t2</em>, where <code>A</code>
  * is a nonterminal and <em>t1, t2</em> are the two right-hand sides. The second right-hand side
  * must not contain nonterminal symbols.<br>
  * Note that there must be some white space between the left-hand side
  * and the arrow because otherwise the "-" will be taken as the
  * last letter of the left-hand side. 
  * @see finiteSignatureParser
  */
public class pdtGrammarParser implements componentParser, pdtGrammarParserConstants {

  private ASCII_CharStream inputStream = null;
  private nameParser names;
  private setParser rulesParser;

  public pdtGrammarParser(ASCII_CharStream input) {
    this(new pdtGrammarParserTokenManager(input));
    names = new nameParser(input);
    rulesParser = new setParser(input);
    inputStream = input;
  }

  private finiteSignature sig;
  private fixedRankSignature nt;
  public Vector nonterminals;
  public term[][] rules;
  public int startIndex;

  private void makeVector(finiteSignature s) {
    Enumeration enm = s.elements();
    while (enm.hasMoreElements()) {
      String name = enm.nextElement().toString();
      nonterminals.addElement(name);
    }
  }

  private void  missingRules() throws ParseException {
    for (int i = 0; i < nonterminals.size(); i++) {
      if (rules[i][0] == null) {
        throw new ParseException("rules for nonterminal " + nonterminals.elementAt(i) + " are missing");
      }
    }
  }

  private void test(boolean nonterminalsAllowed, term t) throws ParseException {
    symbol top = t.topSymbol();
    if (sig.contains(top)) {
      for (int i = 0; i < top.rank(); i++) test(nonterminalsAllowed, t.subterm(i));
    }
    else if (!nt.contains(top)) {
      throw new ParseException("Undefined symbol " + top.toString() + " of rank " + top.rank());
    }
    else if (!nonterminalsAllowed) {
      throw new ParseException("Nonterminal " + top.toString() + " not allowed in terminating right-hand side");
    }
  }

  private void toVariables(term t) {
    symbol top = t.topSymbol();
    if (nt.contains(top)) t.relabel(new variable(nonterminals.indexOf(top.toString())));
    else for (int i = 0; i < top.rank(); i++) toVariables(t.subterm(i));
  }

/** Parse a parallel deterministic tree grammar, where the syntax is as defined above.
  * If parsing has been successful the fields <code>rules</code> and
  * <code>startIndex</code> contain the information needed to initialize a
  * <code>pdtGrammar</code> object in the proper way.
  * @exception ParseException if an error occurs
  */
  final public void pdtGrammar() throws ParseException {
  sig = new finiteSignature();
  nt = new fixedRankSignature(0);
  nonterminals = new Vector();
  String startSymbol;
    jj_consume_token(LEFT_PAR);
    nt.parse(inputStream);
    makeVector(nt);
    rules = new term[nonterminals.size()][];
    for (int i = 0; i < rules.length; i++) rules[i] = new term[2];
    jj_consume_token(COMMA);
    sig.parse(inputStream);
//    if (!nt.disjointWith(sig)) {
//      throw new ParseException("signatures of nonterminals and terminals intersect");
//    }

    jj_consume_token(COMMA);
    rulesParser.set(this);
    missingRules();
    jj_consume_token(COMMA);
    startSymbol = names.name();
    if (!nt.contains(new symbol(startSymbol,0))) {
      {if (true) throw new ParseException("initial nonterminal not contained in the set of nonterminals");}
    }
    startIndex = nonterminals.indexOf(startSymbol);
    jj_consume_token(RIGHT_PAR);
  }

  final public void component() throws ParseException {
  String lhs;
  int ntNumber;
    lhs = names.name();
    if (!nt.contains(new symbol(lhs,0))) {
      {if (true) throw new ParseException("undefined nonterminal " + lhs);}
    }
    ntNumber = nonterminals.indexOf(lhs);
    if (rules[ntNumber][0] != null) {
      {if (true) throw new ParseException("left-hand side " + lhs + " occurs twice");}
    }
    jj_consume_token(ARROW);
    rules[ntNumber][0] = new term();
    rules[ntNumber][0].parse(inputStream);
    test(true, rules[ntNumber][0]);
    toVariables(rules[ntNumber][0]);
    jj_consume_token(BAR);
    rules[ntNumber][1] = new term();
    rules[ntNumber][1].parse(inputStream);
    test(false, rules[ntNumber][1]);
  }

  public pdtGrammarParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  final private int[] jj_la1_0 = {};

  public pdtGrammarParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new pdtGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public pdtGrammarParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new pdtGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public pdtGrammarParser(pdtGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(pdtGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[11];
    for (int i = 0; i < 11; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 11; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
