/* Generated By:JavaCC: Do not edit this line. regularTreeGrammarParser.java */
package parsers;

import terms.*;
import java.util.*;
import generators.*;
import util.*;

/** This is the class used to parse regular tree grammars.
  * The syntax is <code>(nont, sig, rules, start)</code>, where
  * <code>nont</code>
  * is a set of nonterminal symbols like <code>{A, bla, aa-bb}</code>,
  * <code>sig</code> is a finite signature,
  * <code>rules</code> is the set of rules denoted as usual (e.g.,
  * <code>{A -> f[a, g[B,C]], B -> b, C -> f[b,b], A -> a}</code>), and
  * <code>start</code> is the start nonterminal.
  * Note that there must be some white space between the left-hand side
  * and the arrow because otherwise the "-" will be taken as the
  * last letter of the left-hand side. 
  * @see finiteSignatureParser
  */
public class regularTreeGrammarParser implements regularTreeGrammarParserConstants {

  protected ASCII_CharStream inputStream;
  private rulesParser rules;
  private nameParser names;

  public regularTreeGrammarParser(ASCII_CharStream input) {
    this(new regularTreeGrammarParserTokenManager(input));
    rules = new rulesParser(input);
    names = new nameParser(input);
    inputStream = input;
  }

  public treeEnumerator derTrees;
  public Hashtable meaning;
  public Hashtable sort;
  private fixedRankSignature nonterminals = new fixedRankSignature(0);
  private finiteSignature sig = new finiteSignature();
  private int ruleNumber = 0;
  private list ntList = new list();

  private class rulesParser extends trsParser {
    public rulesParser(ASCII_CharStream input) {
      super(input);
    }
    protected void insertRule(term lhs, term rhs, double weight) throws ParseException {
      if (!nonterminals.contains(lhs.topSymbol())) {
        throw new ParseException("Left-hand side not a nonterminal");
      }
      testRHS(rhs);
      String ruleName = nextRuleName();
      derTrees.addSymbol(ruleName, lhs.topSymbol().toString(), getNonterminals(rhs), weight);
      sort.put(ruleName, lhs.topSymbol());
      toVariables();
      meaning.put(ruleName, rhs);
    }
    private void testRHS(term rhs) throws ParseException {
      symbol top = rhs.topSymbol();
      if (sig.contains(top)) {
        for (int i = 0; i < top.rank(); i++) testRHS(rhs.subterm(i));
      }
      else if (top.rank() > 0) {
        throw new ParseException("signature contains no symbol " + top + " of rank " + top.rank());
      }
      else if (!nonterminals.contains(top)) {
        throw new ParseException("symbol " + top +
                                           " of rank zero neither in signature nor among the nonterminals");
      }
    }
  }

  private String nextRuleName() {
    Integer number = new Integer(ruleNumber++);
    return "prod".concat(number.toString());
  }

  private String[] getNonterminals(term t) {
    String[] result;
    symbol top = t.topSymbol();
    if (nonterminals.contains(top)) {
      result = new String[1];
      result[0] = top.toString();
      ntList.append(t);
      return result;
    }
    String[][] subResults = new String[top.rank()][];
    int count = 0;
    for (int i = 0; i < top.rank(); i++) {
      subResults[i] = getNonterminals(t.subterm(i));
      count += subResults[i].length;
    }
    result = new String[count];
    count = 0;
    for (int i = 0; i < subResults.length; i++) {
      for (int j = 0; j < subResults[i].length; j++) {
        result[count++] = subResults[i][j];
      }
    }
    return result;
  }

  private void toVariables() {
    int count = 0;
    while (!ntList.isEmpty()) {
      term t = (term)ntList.head();
      t.relabel(new variable(count++));
      ntList = ntList.tail();
    }
  }

/** Parse a regular tree grammar, where the syntax is as defined above.
  * If parsing has been successful the fields <code>derTrees</code>,
  * <code>meaning</code>, and <code>profile</code>
  * contain the information needed to initialize a
  * <code>regularTreeGrammar</code> object in the proper way.
  * @exception ParseException if an error occurs
  */
  final public void regularTreeGrammar(treeEnumerator derTrees) throws ParseException {
  this.derTrees = derTrees;
  meaning = new Hashtable();
  sort = new Hashtable();
  String startSymbol;
    jj_consume_token(LEFT_PAR);
    nonterminals.parse(inputStream);
    jj_consume_token(COMMA);
    sig.parse(inputStream);
    if (!nonterminals.disjointWith(sig)) {
      {if (true) throw new ParseException("signatures of nonterminals and terminals intersect");}
    }
    jj_consume_token(COMMA);
    rules.rules();
    jj_consume_token(COMMA);
    startSymbol = names.name();
    if (!nonterminals.contains(new symbol(startSymbol,0))) {
      {if (true) throw new ParseException("initial nonterminal must be contained in the set of nonterminals");}
    }
    derTrees.initMinDepths();
    derTrees.setMainSort(startSymbol);
    jj_consume_token(RIGHT_PAR);
  }

  public regularTreeGrammarParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  final private int[] jj_la1_0 = {};

  public regularTreeGrammarParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new regularTreeGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public regularTreeGrammarParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new regularTreeGrammarParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public regularTreeGrammarParser(regularTreeGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  public void ReInit(regularTreeGrammarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[9];
    for (int i = 0; i < 9; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 9; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
