/* Generated By:JavaCC: Do not edit this line. tTdTransducerParser.java */
package parsers;

import java.util.*;
import terms.*;
import generators.*;

/** The parser for top-down tree transducers with tables.
  * The syntax is identical to that of <code>tdTransducer</code>,
  * except that the set of rules is replaced by a (nonempty) set
  * of sets of rules.
  @see tdTransducerParser
  */
public class tTdTransducerParser implements tTdTransducerParserConstants {

  private ASCII_CharStream inputStream = null;
  private termParser terms;
  protected rulesParser rules;

  public Vector tables = new Vector(5);
  public Vector weights = new Vector(5);
  public fixedRankSignature states;
  public finiteSignature in;
  public finiteSignature out;
  public symbol initial;
  public term exprTerm;

  public tTdTransducerParser(ASCII_CharStream input) {
    this(new tTdTransducerParserTokenManager(input));
    rules = new rulesParser(input);
    terms = new termParser(input);
    inputStream = input;
  }

  private class rulesParser extends trsParser {

    public rulesParser(ASCII_CharStream input) {
      super(input);
    }

    protected void insertRule(term lhs, term rhs, double wght) throws ParseException {
      verifyRule(lhs, rhs);
      term[][] oldTable = (term[][])tables.elementAt(tables.size()-1);
      term[][] table = new term[oldTable.length + 1][];
      System.arraycopy(oldTable, 0, table, 0, oldTable.length);
      table[oldTable.length] = new term[2];
      table[oldTable.length][0] = lhs;
      table[oldTable.length][1] = rhs;
      tables.setElementAt(table, tables.size()-1);
      double[] oldWeight = (double[])weights.elementAt(weights.size()-1);
      double[] weight = new double[oldWeight.length + 1];
      System.arraycopy(oldWeight, 0, weight, 0, oldWeight.length);
      weight[oldWeight.length] = wght;
      weights.setElementAt(weight, weights.size()-1);
    }
  }

  protected void verifyRule(term lhs, term rhs) throws ParseException {
    BitSet lhsVars = new BitSet();
    if (getVariables(lhs, lhsVars)) verifyVariables(rhs, lhsVars);
    else throw new ParseException("Rule not left-linear");
    verifyLhs(lhs);
    verifyRhs(rhs);
  }

  private boolean getVariables(term t, BitSet result) {
    symbol top = t.topSymbol();
    if (top instanceof variable) {
      if (result.get(((variable)top).index())) return false;
      result.set(((variable)top).index());
      return true;
    }
    else {
      for (int i = 0; i < top.rank(); i++) {
        if (!getVariables(t.subterm(i), result)) return false;
      }
      return true;
    }
  }

  private void verifyVariables(term t, BitSet vars) throws ParseException {
    symbol top = t.topSymbol();
    if (top instanceof variable) {
      if (!vars.get(((variable)top).index()))
        throw new ParseException("Variable " + top.toString() + " appears in rhs but not in lhs");
    }
    for (int i = 0; i < top.rank(); i++) verifyVariables(t.subterm(i), vars);
  }

  private void verifyLhs(term lhs) throws ParseException {
    symbol sym = lhs.topSymbol();
    if (!states.contains(sym)) throw new ParseException("Topmost symbol " + sym + " of left-hand side not a state");
    lhs = lhs.subterm(0);
    sym = lhs.topSymbol();
    if (!in.contains(sym)) throw new ParseException("Symbol " + sym + " of rank " + sym.rank() + " in left-hand side not in input signature");
    for (int i = 0; i < sym.rank(); i++) {
      sym = lhs.subterm(i).topSymbol();
      if (!(sym instanceof variable)) throw new ParseException("Symbol " + sym.toString() + " in left-hand side not a variable");
    }
  }

  private void verifyRhs(term rhs) throws ParseException {
    symbol sym = rhs.topSymbol();
    if (!out.contains(sym)) {
      if (states.contains(sym)) {
        sym = rhs.subterm(0).topSymbol();
        if (sym instanceof variable) return;
        else throw new ParseException("Symbol " + sym + " in right-hand side must be a variable");
      }
      throw new ParseException("Symbol " + sym + " of rank " + sym.rank() + " in right-hand side is neither an output symbol nor a state");
    }
    for (int i = 0; i < sym.rank(); i++) verifyRhs(rhs.subterm(i));
  }

/** Parse a top-down tree transducer.
  * Expects to find a six-tuple consisting of the input signature, output signatue,
  * state set (disjoint with both the input and output signature, rule set, and initial state.
  * @exception ParseException if an error occurs
  */
  final public void tTdTransducer() throws ParseException {
    jj_consume_token(LEFT_PAR);
      in = new finiteSignature();
      in.parse(inputStream);
    jj_consume_token(COMMA);
      out = new finiteSignature();
      out.parse(inputStream);
    jj_consume_token(COMMA);
      states = new fixedRankSignature(1);
      states.parse(inputStream);
      if (!states.disjointWith(in) || !states.disjointWith(out)) {
        {if (true) throw new ParseException("set of states must be disjoint with input and output signatures");}
      }
    jj_consume_token(COMMA);
    jj_consume_token(LEFT_BRACE);
      tables.addElement(new term[0][]);
      weights.addElement(new double[0]);
      rules.rules();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      jj_consume_token(COMMA);
        tables.addElement(new term[0][]);
        weights.addElement(new double[0]);
        rules.rules();
    }
    jj_consume_token(RIGHT_BRACE);
    jj_consume_token(COMMA);
      exprTerm = terms.term();
    jj_consume_token(COMMA);
      nameParser names = new nameParser(inputStream);
      initial = new symbol(names.name(), 1);
      if (!states.contains(initial)) {
        {if (true) throw new ParseException("initial state not an element of the state set");}
      }
  }

  public tTdTransducerParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[1];
  final private int[] jj_la1_0 = {0x400,};

  public tTdTransducerParser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new tTdTransducerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public tTdTransducerParser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new tTdTransducerParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public tTdTransducerParser(tTdTransducerParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  public void ReInit(tTdTransducerParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 1; i++) jj_la1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[11];
    for (int i = 0; i < 11; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 1; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 11; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
