package terms;

import java.util.BitSet;
import java.util.Vector;
import generators.*;

/**     
 * Extension of a normal term. For the mtTransducer component.
 */     
public class extendedTerm extends term {
    private BitSet solvableStates = null;
    private BitSet safeParameters = null;
    private extendedTerm result = null;
    private int counter = -1;
    private boolean bottomMostState = false;
    
    public extendedTerm(term t) {
        super(t.topSymbol());
        for (int i = 0; i < t.topSymbol().rank(); i++) {
            extendedTerm eSub = new extendedTerm(t.subterm(i));
            defineSubterm(i, eSub);
        }
    }
    public extendedTerm(symbol s) {
        super(s);
    }

    /**
     * Copy constructor
     */
    public extendedTerm(extendedTerm et) {
        super(et.topSymbol());
        if (et.getResult() != null)
            result = new extendedTerm( et.getResult() );
        counter = et.getCounter();
        if (et.solvableStates != null)
            solvableStates = (BitSet)et.solvableStates.clone();
        bList = et.bListClone();
        safeParameters = et.safeParametersClone();
        for (int i = 0; i < et.topSymbol().rank(); i++) {
            extendedTerm eSub = new extendedTerm((extendedTerm)et.subterm(i));
            defineSubterm(i, eSub);
        }

    }

    public extendedTerm extendedSubterm(int i) {
        return (extendedTerm)super.subterm(i);
    }

    public void resetCounter() {
        counter = -1;
    }
    public void increaseCounter() {
        counter++;
    }
    public void decreaseCounter() {
        if (counter > 0)
            counter--;
        else
            counter = -1;
    }
    public int getCounter() {
        return counter;
    }
    public extendedTerm getStepwiseResult() {
        if (counter >= 0 && result != null)
            return result;
        else
            return this;
    }


    public void setResult(extendedTerm result) {
        this.result = result;
    }
    public extendedTerm getResult() {
        return result;
    }
    
    public void defineSolvableStates(BitSet solvableStates) {
        this.solvableStates = solvableStates;
    }
    public void set(int i) {
        if (solvableStates == null)
            solvableStates = new BitSet();
        solvableStates.set(i);
    }
    public boolean get(int i) {
        if (solvableStates == null)
            return false;
        else
            return solvableStates.get(i);
    }
    /*public String debugSolvable() {
        if (solvableStates == null)
            return null;
        else
            return solvableStates.toString();
    }*/

    public extendedTerm getCurrentResultTree() {
        extendedTerm currResult;
        if (result == null)
            currResult = new extendedTerm( this );
        else 
            currResult = result.getCurrentResultTree();
            
        for (int i = 0; i < currResult.topSymbol().rank(); i++) {
            extendedTerm tempChild = (extendedTerm)currResult.subterm(i);
            currResult.defineSubterm(i, tempChild.getCurrentResultTree());
        }
        return currResult;

    }

    private Vector[] bList = null;
    private void initB(){
        bList = new Vector[mtTransducer.stateSize];
        for (int i = 0; i < bList.length; i++)
            bList[i] = new Vector();
    }
    public int getBSize(int stateNum) {
        if(bList == null)
            initB();
        if(stateNum >= bList.length)
            return -1;

        return bList[stateNum].size();
    }
    public BitSet getB(int stateNum, int bNum) {
        if(bList == null)
            initB();
        if(stateNum >= bList.length)
            return null;

        return (BitSet)bList[stateNum].get(bNum);
    }
    public void addB(int stateNum, BitSet b) {
        if(bList == null)
            initB();

        if(!bList[stateNum].contains(b))
            bList[stateNum].add(b);
    }

    public String printOI(int num) {
        if (bList == null)
            return "empty";
        Vector bSet = bList[num];
        String out = new String();
        for (int x = 0; x < bSet.size(); x++){
            BitSet b = (BitSet)bSet.get(x);
            out = out.concat(" " + b.toString() + " ");
        }
        return out;
    }
    
    public String toString() {
        return super.toString();
    }

    public Vector[] bListClone() {
        if(bList == null)
            return null;

        Vector[] bCopy = new Vector[bList.length];
        for(int x = 0; x < bList.length; x++) {
            Vector bSet = bList[x];
            bCopy[x] = new Vector();
            for(int i = 0; i < bSet.size(); i++) {
                BitSet bClone = (BitSet)((BitSet)bSet.get(i)).clone();
   		bCopy[x].add(bClone);
            }
        }
        return bCopy;
    }

    public void setSafeParameters(BitSet b) {
        safeParameters = b;
    }

    public BitSet getSafeParameters() {
        return safeParameters;
    }

    public BitSet safeParametersClone() {
        if(safeParameters == null)
            return null;
        else
            return (BitSet)safeParameters.clone();
    }

    public void setBottomMostState() {
        bottomMostState = true;
    }
    public boolean bottomMostState() {
        return bottomMostState;
    }
}



